/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.pay.cmd;

import com.xunlei.channel.util.Md5Encrypt;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.PrivateKey;
import com.xunlei.niux.pay.DefaultCmd;
import com.xunlei.niux.pay.client.UserClient;
import com.xunlei.niux.pay.cmd.PayCmd;
import com.xunlei.niux.pay.proxy.ValidIPProxy;
import com.xunlei.niux.pay.util.CodeUtil;
import com.xunlei.niux.pay.util.IpUtil;
import com.xunlei.niux.pay.util.OrderIdUtil;
import com.xunlei.niux.pay.util.StringUtils;
import com.xunlei.niux.pay.util.UserUtil;
import com.xunlei.niux.pay.util.VerifyCodeUtil;
import com.xunlei.util.Log;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class CodeCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(PayCmd.class);

    @CmdMapper(value={"/jinzuan/codepay.do"})
    public Object codePay(XLHttpRequest request, XLHttpResponse response) {
        long uid = 0L;
        String userAccount = null;
        String ip = IpUtil.getIp(request);
        String acode = StringUtils.filterInputWeak(request.getParameter("acode"));
        MainParam mainParam = null;
        try {
            mainParam = this.getMainParam(request, response, true);
            uid = mainParam.getUserid();
            userAccount = mainParam.getUserAccount();
        }
        catch (Exception e) {
            logger.error("ip[" + ip + "]\u8bf7\u6c42/jinzuan/codepay.do\u7684session\u9a8c\u8bc1\u5931\u8d25", (Throwable)e);
        }
        if (mainParam == null) {
            return JsonObjectUtil.getRtnAndDataJsonObject((int)11, (Object)"session\u9a8c\u8bc1\u5931\u8d25");
        }
        if (uid == 0L || StringTools.isEmpty((String)userAccount)) {
            return JsonObjectUtil.getRtnAndDataJsonObject((int)11, (Object)"session\u9a8c\u8bc1\u5931\u8d25");
        }
        String verifycode = request.getParameter("verifycode", "");
        String verifykey = request.getCookieValue("VERIFY_KEY");
        if (StringTools.isEmpty((String)verifycode)) {
            return JsonObjectUtil.getRtnAndDataJsonObject((int)14, (Object)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String verifytype = "MVA";
        if (!VerifyCodeUtil.isVerify(verifykey, verifytype, verifycode)) {
            return JsonObjectUtil.getRtnAndDataJsonObject((int)13, (Object)"\u60a8\u8f93\u5165\u7684\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        String userid = request.getCookieValue("userid");
        if (!userid.equals(uid + "")) {
            return JsonObjectUtil.getRtnAndDataJsonObject((int)12, (Object)"\u8d26\u53f7\u975e\u6cd5");
        }
        logger.info("jinzuan codepay.do  uid=" + userid + "&userAccount=" + userAccount + "&code=" + acode);
        if (StringTools.isEmpty((String)acode)) {
            return JsonObjectUtil.getRtnAndDataJsonObject((int)1, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        }
        if (!CodeUtil.checkCode(acode = acode.toUpperCase())) {
            return JsonObjectUtil.getRtnAndDataJsonObject((int)8, (Object)"\u975e\u6cd5\u6fc0\u6d3b\u7801");
        }
        userAccount = UserUtil.getUserNameByUserId(uid + "");
        if (StringTools.isEmpty((String)userAccount)) {
            return JsonObjectUtil.getRtnAndDataJsonObject((int)2, (Object)"\u8be5\u8d26\u53f7\u975e\u8fc5\u96f7\u8d26\u53f7");
        }
        if ((userAccount.indexOf("@") > 0 || userAccount.indexOf(":") > 0) && UserClient.getInstance().checkChildrenAccount(uid + "")) {
            return JsonObjectUtil.getRtnAndDataJsonObject((int)3, (Object)"\u5b50\u8d26\u53f7\u4e0d\u80fd\u4f7f\u7528\u6fc0\u6d3b\u7801");
        }
        try {
            String orderid = OrderIdUtil.getOrderId(request);
            String actno = StringUtils.filterInputWeak(request.getParameter("actno"));
            if (StringTools.isEmpty((String)actno)) {
                actno = "niuxpaycenter";
            }
            FacadeFactory.INSTANCE.getCodeCodeBo().use(acode, orderid, userAccount, uid, ip, "000001075");
            return JsonObjectUtil.getRtnAndDataJsonObject((int)0, (Object)"\u6fc0\u6d3b\u6210\u529f");
        }
        catch (XLRuntimeException ee) {
            logger.info("jinzuan codepay.do error uid=" + uid + ",userAccount=" + userAccount + ",acode=" + acode + ",reason=" + ee.getMessage());
            ee.printStackTrace();
            return JsonObjectUtil.getRtnAndDataJsonObject((int)6, (Object)ee.getMessage());
        }
        catch (Exception e) {
            logger.info("jinzuan codepay.do othererror uid=" + uid + ",userAccount=" + userAccount + ",acode=" + acode + ",reason=" + e.getMessage());
            e.printStackTrace();
            return JsonObjectUtil.getRtnAndDataJsonObject((int)7, (Object)"\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/jinzuan/freezecode.do"})
    public Object freezeCode(XLHttpRequest request, XLHttpResponse response) {
        String acode = request.getParameter("acode");
        String type = request.getParameter("type");
        String timestamp = request.getParameter("timestamp");
        String sign = request.getParameter("sign");
        try {
            String ip = request.getRemoteIP();
            response.setInnerContentType(XLHttpResponse.ContentType.plain);
            if (!ValidIPProxy.getInstance().isValidIp(ip, 2)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)8, (Object)"\u65e0\u6548ip");
            }
            logger.info("jinzuan freezecode.do acode=" + acode + ",type=" + type + ",timestamp=" + timestamp + ",sign=" + sign);
            if (StringTools.isEmpty((String)acode) || StringTools.isEmpty((String)type) || StringTools.isEmpty((String)timestamp) || StringTools.isEmpty((String)sign)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)1, (Object)"\u53c2\u6570\u9519\u8bef");
            }
            if (!CodeUtil.checkCode(acode = acode.toUpperCase())) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)2, (Object)"\u975e\u6cd5\u6fc0\u6d3b\u7801");
            }
            int mytype = Integer.parseInt(type);
            long time = Long.parseLong(timestamp);
            long mytime = System.currentTimeMillis() / 1000L;
            if (mytime - time > 900L) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)4, (Object)"\u8bf7\u6c42\u8d85\u65f6");
            }
            PrivateKey privateKeyquery = new PrivateKey();
            privateKeyquery.setBizNo("110001".trim());
            PrivateKey privateKey = (PrivateKey)FacadeFactory.INSTANCE.getBaseSo().findObject((Object)privateKeyquery);
            if (privateKey == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)9, (Object)"\u4e1a\u52a1\u7f16\u53f7\u4e0d\u5b58\u5728");
            }
            String mysgin = Md5Encrypt.md5((String)(acode + type + timestamp + privateKey.getPrivateKey()));
            if (!sign.trim().equals(mysgin)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)5, (Object)"\u7b7e\u540d\u9519\u8bef");
            }
            FacadeFactory.INSTANCE.getCodeCodeBo().freeze(acode, mytype);
            logger.info("jinzuan freezecode.do success acode=" + acode + ",type=" + type + ",timestamp=" + timestamp + ",sign=" + sign);
            return JsonObjectUtil.getOnlyOkJson();
        }
        catch (XLRuntimeException e) {
            logger.info("jinzuan freezecode.do limit  acode=" + acode + ",type=" + type + ",timestamp=" + timestamp + ",sign=" + sign + ",reason=" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject((int)7, (Object)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("jinzuan freezecode.do error acode=" + acode + ",type=" + type + ",timestamp=" + timestamp + ",sign=" + sign + ",reason=" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject((int)6, (Object)"\u7f51\u7edc\u5f02\u5e38");
        }
    }
}

