/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.pay.cmd;

import com.ferret.common.dao.vo.Page;
import com.xunlei.channel.util.Md5Encrypt;
import com.xunlei.common.util.StringTools;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.BoxPayOrder;
import com.xunlei.niux.pay.cmd.BasePayCmd;
import com.xunlei.niux.pay.cmd.PayCmd;
import com.xunlei.niux.pay.proxy.TestAccountProxy;
import com.xunlei.niux.pay.thread.BoxTask;
import com.xunlei.niux.pay.thread.BoxThreadPool;
import com.xunlei.niux.pay.util.IpUtil;
import com.xunlei.niux.pay.util.OrderIdUtil;
import com.xunlei.niux.pay.util.RBundleUtil;
import com.xunlei.niux.pay.util.ReturnConstant;
import com.xunlei.niux.pay.util.SignUtil;
import com.xunlei.niux.pay.util.StringUtils;
import com.xunlei.niux.pay.vo.ReturnData;
import com.xunlei.util.Log;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class BoxPayCmd
extends BasePayCmd {
    private static Logger logger = Log.getLogger(PayCmd.class);
    private static final String boxbizno = RBundleUtil.getString("pay", "boxbizno");
    private static final String boxchargekey = RBundleUtil.getString("pay", "boxchargekey");
    private static final String boxPayCallBackUrl = RBundleUtil.getString("pay", "boxPayCallBackUrl");
    private static final String APPID = RBundleUtil.getString("pay", "appId");
    private static final String boxPayIps = RBundleUtil.getString("pay", "boxPayIps");
    private static final Page queryPage = new Page();

    @CmdMapper(value={"/jinzuan/boxpay.do"})
    public Object boxpay(XLHttpRequest request, XLHttpResponse response) {
        long uid = 0L;
        String userAccount = null;
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        String ip = IpUtil.getIp(request);
        try {
            String userId = StringUtils.filterInputWeak(request.getParameter("uid"));
            String userName = StringUtils.filterInputWeak(request.getParameter("username"));
            String porderId = StringUtils.filterInputWeak(request.getParameter("porderid"));
            String price = StringUtils.filterInputWeak(request.getParameter("price"));
            String productId = StringUtils.filterInputWeak(request.getParameter("productid"));
            String productName = StringUtils.filterInputWeak(request.getParameter("productname"));
            String openId = StringUtils.filterInputWeak(request.getParameter("openid"));
            String timeStamp = StringUtils.filterInputWeak(request.getParameter("timestamp"));
            String sign = StringUtils.filterInputWeak(request.getParameter("sign"));
            String copartnerId = "0000";
            String actNo = StringUtils.filterInputWeak(request.getParameter("actno"));
            String ext1 = StringUtils.filterInputWeak(request.getParameter("ext1"));
            logger.info("jinzuan boxpay.do  uid=" + userId + "&userName=" + userName + "&price=" + price + "&porderId=" + porderId + "&productId=" + productId + "&productName=" + productName + "&actNo=" + actNo + "&ext1=" + ext1);
            if (StringTools.isEmpty((String)userId) || StringTools.isEmpty((String)userName) || StringTools.isEmpty((String)porderId) || StringTools.isEmpty((String)price) || StringTools.isEmpty((String)productId) || StringTools.isEmpty((String)timeStamp) || StringTools.isEmpty((String)openId) || StringTools.isEmpty((String)sign) || StringTools.isEmpty((String)productName)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)2, (Object)ReturnConstant.returnMap.get(2));
            }
            uid = Long.parseLong(userId);
            BoxPayOrder porder = new BoxPayOrder();
            if (StringTools.isEmpty((String)actNo)) {
                porder.setActNo("box");
            } else {
                porder.setActNo(actNo);
            }
            porder.setUserId(Long.valueOf(uid));
            porder.setPrice(Double.valueOf(Double.parseDouble(price)));
            porder.setUserName(userName);
            porder.setPorderId(porderId);
            porder.setProductId(productId);
            porder.setProductName(productName);
            porder.setNoticeBox(Boolean.valueOf(false));
            porder.setChargeType("W3");
            porder.setExt1(ext1);
            porder.setOrderId(OrderIdUtil.getOrderId(request));
            porder.setOrderTime(sdf.format(new Date()));
            porder.setOrderStatus(new Integer(1));
            if (!this.checkIp(ip)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)20, (Object)ReturnConstant.returnMap.get(20));
            }
            if (this.checkTimeOut(timeStamp)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)19, (Object)ReturnConstant.returnMap.get(19));
            }
            if (!this.checkSign(porder, sign)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)7, (Object)ReturnConstant.returnMap.get(7));
            }
            FacadeFactory.INSTANCE.getBaseSo().addObject((Object)porder);
            String chargeRequestUrl = this.getboxPayUrl(porder, copartnerId, productName, openId, ip);
            logger.info("jinzuan boxpay.do addorder success uid=" + uid + ",userAccount=" + userAccount + ",order=" + porder.getOrderId() + " ,url=" + chargeRequestUrl);
            ReturnData data = this.rechargeByAccount("W3", porder.getOrderId(), chargeRequestUrl, request, response);
            if (data.getCode() == 0) {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("orderId", data.getMsg());
                result.put("appId", data.getAppId());
                result.put("nonceStr", data.getNonceStr());
                result.put("package", data.getPackpage());
                result.put("paySign", data.getPaySign());
                result.put("signType", data.getSignType());
                result.put("timeStamp", data.getTimeStamp());
                return JsonObjectUtil.getRtnAndDataJsonObject((int)data.getCode(), result);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject((int)data.getCode(), (Object)data.getMsg());
        }
        catch (SQLException e) {
            logger.info("jinzuan boxpay.do sqlerror uid=" + uid + ",userAccount=" + userAccount + ",reason=" + e.getMessage());
            e.printStackTrace();
            return JsonObjectUtil.getRtnAndDataJsonObject((int)12, (Object)ReturnConstant.returnMap.get(12));
        }
        catch (Exception e) {
            logger.info("jinzuan boxpay.do othererror uid=" + uid + ",userAccount=" + userAccount + ",reason=" + e.getMessage());
            e.printStackTrace();
            return JsonObjectUtil.getRtnAndDataJsonObject((int)14, (Object)ReturnConstant.returnMap.get(14));
        }
    }

    private boolean checkIp(String ip) {
        boolean isSuccess = IpUtil.isWhiteIp(boxPayIps, ip);
        return isSuccess;
    }

    private boolean checkTimeOut(String timeStamp) {
        long ts = Long.parseLong(timeStamp);
        long nowts = System.currentTimeMillis() / 1000L;
        return nowts - ts > 900L;
    }

    private boolean checkSign(BoxPayOrder order, String sign) {
        String mySign = Md5Encrypt.md5((String)(order.getPorderId() + order.getProductId() + order.getUserId() + order.getPrice() + boxchargekey));
        return mySign.trim().equals(sign.trim());
    }

    private String getboxPayUrl(BoxPayOrder payOrder, String copartnerid, String productName, String openId, String ip) throws Exception {
        String payerName = payOrder.getUserName();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("version", "v1.0");
        params.put("pageCharset", "1");
        if (StringTools.isEmpty((String)payOrder.getActNo()) || "niuxpaycenter".equals(payOrder.getActNo())) {
            params.put("bgUrl", callBackUrl);
        } else {
            params.put("bgUrl", boxPayCallBackUrl);
        }
        params.put("fgUrl", "http://vip.niu.xunlei.com");
        params.put("bizNo", boxbizno);
        params.put("orderId", payOrder.getOrderId());
        params.put("orderAmt", new Double(payOrder.getPrice() * 100.0).intValue() + "");
        String uid = payOrder.getUserId() + "";
        TestAccountProxy.getInstance().checkTestAccount(params, uid);
        params.put("orderTime", orderTimeDf.format(sdf.parse(payOrder.getOrderTime())));
        params.put("payType", payOrder.getChargeType());
        params.put("xunleiId", payerName);
        params.put("xlnumId", payOrder.getUserId() + "");
        params.put("productName", productName);
        params.put("productDesc", productName);
        params.put("payerName", payerName);
        params.put("ext1", "");
        params.put("ext2", "0");
        if (payOrder.getChargeType().equals("W3")) {
            params.put("other1", "wechatpubpay");
            params.put("other2", openId);
            params.put("other3", APPID);
        }
        String signMsg = SignUtil.sign(params, boxchargekey.trim());
        String requestUrl = payUrl + "?" + SignUtil.getSignatureContent(params, "utf-8") + "&signMsg=" + signMsg;
        if (!StringTools.isEmpty((String)ip)) {
            requestUrl = requestUrl + "&clientIp=" + ip;
        }
        return requestUrl;
    }

    @CmdMapper(value={"/jinzuan/boxback.do"})
    public Object boxCallBack(XLHttpRequest request, XLHttpResponse response) {
        String version = this.getChargeParameter(request, "version");
        String orderId = this.getChargeParameter(request, "orderId");
        String orderAmt = this.getChargeParameter(request, "orderAmt");
        String orderTime = this.getChargeParameter(request, "orderTime");
        String xlpayId = this.getChargeParameter(request, "xlpayId");
        String xlpayTime = this.getChargeParameter(request, "xlpayTime");
        String gameid = this.getChargeParameter(request, "ext1");
        String paybizno = this.getChargeParameter(request, "ext2");
        String payResult = this.getChargeParameter(request, "payResult");
        String signMsg = this.getChargeParameter(request, "signMsg");
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        String result = "N";
        try {
            if (!"00".equals(payResult)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)1, (Object)"\u652f\u4ed8\u672a\u6210\u529f");
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", version);
            params.put("orderId", orderId);
            params.put("orderAmt", orderAmt);
            params.put("orderTime", orderTime);
            params.put("xlpayId", xlpayId);
            params.put("xlpayTime", xlpayTime);
            params.put("ext1", gameid);
            params.put("ext2", paybizno);
            params.put("payResult", payResult);
            params.put("signMsg", signMsg);
            logger.info("jinzuan boxback.do orderid=" + orderId + ", params=" + params);
            if (!SignUtil.checkSign(params, boxchargekey)) {
                throw new Exception("\u6570\u636e\u6821\u9a8c\u4e0d\u6b63\u786e");
            }
            if (!StringTools.isEmpty((String)orderId)) {
                BoxPayOrder order = new BoxPayOrder();
                order.setOrderId(orderId);
                BaseSo baseSo = FacadeFactory.INSTANCE.getBaseSo();
                List polist = baseSo.findObjects((Object)order, queryPage);
                if (polist != null && polist.size() > 0) {
                    BoxPayOrder porder = (BoxPayOrder)polist.get(0);
                    if (porder.getNoticeBox().booleanValue()) {
                        throw new Exception("\u8be5\u5145\u503c\u8ba2\u5355\u5df2\u7ecf\u56de\u8c03\u8fc7");
                    }
                    result = "Y";
                    logger.info("BoxPayProxy  start..............,orderid:" + orderId);
                    BoxThreadPool.getInstance().execute(new BoxTask(porder));
                    logger.info("BoxPayProxy  end.............,orderid:" + orderId);
                }
            }
            logger.info("jinzuan boxback.do success orderId=" + orderId);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("jinzuan boxback.do error orderId=" + orderId + ",reason=" + e.getMessage());
            return "<xlresult>" + result + "</xlresult>";
        }
        return "<xlresult>" + result + "</xlresult>";
    }
}

