/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.pay.cmd;

import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.pay.cmd.BaseCmd;
import com.xunlei.niux.pay.cmd.CodeCmd;
import com.xunlei.niux.pay.util.RBundleUtil;
import com.xunlei.niux.pay.util.StringUtils;
import com.xunlei.niux.pay.vo.ReturnData;
import com.xunlei.util.Log;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;

public class BasePayCmd
extends BaseCmd {
    private static Logger logger = Log.getLogger(CodeCmd.class);
    protected static final String callBackUrl = RBundleUtil.getString("pay", "callBackUrl");
    protected static final String actCallBackUrl = RBundleUtil.getString("pay", "actCallBackUrl");
    protected static final String payUrl = RBundleUtil.getString("pay", "payUrl");
    protected static final SimpleDateFormat orderTimeDf = new SimpleDateFormat("yyyyMMddHHmmss");
    protected static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    protected ReturnData rechargeByAccount(String chargeType, String orderId, String payRequestUrl, XLHttpRequest request, XLHttpResponse response) {
        String errcode = "";
        ReturnData data = new ReturnData();
        try {
            String chargeCode = "";
            SAXReader reader = new SAXReader();
            Document doc = reader.read(new URL(payRequestUrl).openStream());
            logger.info("orderid=" + orderId + ",doc:" + doc.asXML());
            Iterator it = doc.selectNodes("/pay/payresult").iterator();
            if (it.hasNext()) {
                Element element = (Element)it.next();
                chargeCode = element.getText();
            }
            logger.info("orderid=" + orderId + " ,chargeCode=" + chargeCode);
            if (chargeCode.equals("00")) {
                data.setCode(0);
                if (chargeType.equals("W3")) {
                    String appId = this.getDocNodeText(doc, "/pay/appId");
                    String timeStamp = this.getDocNodeText(doc, "/pay/timeStamp");
                    String nonceStr = this.getDocNodeText(doc, "/pay/nonceStr");
                    String packpage = this.getDocNodeText(doc, "/pay/package");
                    String signType = this.getDocNodeText(doc, "/pay/signType");
                    String paySign = this.getDocNodeText(doc, "/pay/paySign");
                    data.setMsg(orderId);
                    data.setAppId(appId);
                    data.setTimeStamp(timeStamp);
                    data.setNonceStr(nonceStr);
                    data.setSignType(signType);
                    data.setPaySign(paySign);
                    data.setPackpage(packpage);
                } else if (chargeType.equals("W2")) {
                    String imgcode = this.getDocNodeText(doc, "/pay/imgcode");
                    String wechaturl = this.getDocNodeText(doc, "/pay/wechaturl");
                    String code = this.getDocNodeText(doc, "/pay/errcode");
                    String errmsg = this.getDocNodeText(doc, "/pay/errmsg");
                    imgcode = URLEncoder.encode(imgcode, "utf-8");
                    wechaturl = URLEncoder.encode(wechaturl, "utf-8");
                    code = URLEncoder.encode(code, "utf-8");
                    errmsg = URLEncoder.encode(errmsg, "utf-8");
                    data.setMsg(imgcode);
                    data.setAppId(wechaturl);
                    data.setNonceStr(code);
                    data.setPackpage(errmsg);
                } else {
                    data.setMsg(orderId);
                }
                String ext = this.getDocNodeText(doc, "/pay/ext");
                errcode = "0";
            } else if (chargeCode.equals("10")) {
                Iterator it2 = doc.selectNodes("/pay/errcode").iterator();
                if (it2.hasNext()) {
                    Element element = (Element)it2.next();
                    errcode = element.getText();
                }
                logger.error("orderid=" + orderId + " ,errcode=" + errcode);
                if (errcode.equals("11")) {
                    data.setCode(-10);
                    data.setMsg("\u7b7e\u540d\u9519\u8bef");
                } else if (errcode.equals("12")) {
                    data.setCode(-11);
                    data.setMsg("\u8ba2\u5355\u5df2\u7ecf\u5b58\u5728");
                } else if (errcode.equals("13")) {
                    data.setCode(-12);
                    data.setMsg("\u8ba2\u5355\u53c2\u6570\u503c\u4e0d\u7b26\u5408");
                } else if (errcode.equals("14")) {
                    data.setCode(-13);
                    data.setMsg("\u65e0\u6548\u5546\u6237\u53f7");
                } else if (errcode.equals("15") || errcode.equals("92")) {
                    data.setCode(-14);
                    data.setMsg("\u5e10\u6237\u4f59\u989d\u4e0d\u8db3");
                } else if (errcode.equals("16")) {
                    data.setCode(-15);
                    data.setMsg("\u8fc5\u96f7\u5e10\u6237\u4e0d\u5b58\u5728");
                } else if ("1001".equals(errcode)) {
                    data.setCode(-21);
                    data.setMsg("\u652f\u4ed8\u5bc6\u7801\u9519\u8bef");
                } else {
                    data.setCode(-16);
                    data.setMsg("\u5e10\u6237\u652f\u4ed8\u53d1\u751f\u9519\u8bef");
                }
            }
        }
        catch (Exception e) {
            data.setCode(-16);
            data.setMsg("\u5e10\u6237\u652f\u4ed8\u53d1\u751f\u9519\u8bef");
            logger.error("account pay error,orderid=" + orderId + ",payRequestUrl=" + payRequestUrl, (Throwable)e);
        }
        return data;
    }

    private String getDocNodeText(Document doc, String nodeName) {
        try {
            String nodeText = "";
            Iterator it3 = doc.selectNodes(nodeName).iterator();
            if (it3.hasNext()) {
                Element element = (Element)it3.next();
                nodeText = element.getText();
            }
            return nodeText;
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getChargeParameter(XLHttpRequest req, String name) {
        String val = req.getParameter(name);
        if (val != null) {
            try {
                String valchs = new String(val.getBytes("latin1"), "utf-8");
                return StringUtils.filterInputWeak(valchs);
            }
            catch (Exception ex) {
                return "";
            }
        }
        return "";
    }
}

