/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.pay.cmd;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.StringTools;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.PayOrder;
import com.xunlei.niux.data.jinzuan.vo.Price;
import com.xunlei.niux.pay.activity.ActivityProxy;
import com.xunlei.niux.pay.client.UserClient;
import com.xunlei.niux.pay.cmd.BasePayCmd;
import com.xunlei.niux.pay.cmd.PayCmd;
import com.xunlei.niux.pay.proxy.BuQiProxy;
import com.xunlei.niux.pay.proxy.ChargeTypeProxy;
import com.xunlei.niux.pay.proxy.PriceProxy;
import com.xunlei.niux.pay.proxy.TestAccountProxy;
import com.xunlei.niux.pay.util.CookieUtil;
import com.xunlei.niux.pay.util.DateUtil;
import com.xunlei.niux.pay.util.IpUtil;
import com.xunlei.niux.pay.util.OrderIdUtil;
import com.xunlei.niux.pay.util.RBundleUtil;
import com.xunlei.niux.pay.util.SignUtil;
import com.xunlei.niux.pay.util.StringUtils;
import com.xunlei.niux.pay.util.UserUtil;
import com.xunlei.niux.pay.vo.ReturnData;
import com.xunlei.util.Log;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class ActPayCmd
extends BasePayCmd {
    private static Logger logger = Log.getLogger(PayCmd.class);
    private static final String unionbizno = RBundleUtil.getString("pay", "unionbizno");
    private static final String unionchargekey = RBundleUtil.getString("pay", "unionchargekey");
    private static final String unionCallBackUrl = RBundleUtil.getString("pay", "unionCallBackUrl");
    private static final String unionActs = RBundleUtil.getString("pay", "unionActs");

    private boolean checkUnionAct(String actNo) {
        if (StringTools.isEmpty((String)unionActs)) {
            return true;
        }
        if (unionActs.indexOf(",") == -1) {
            if (unionActs.trim().equals(actNo)) {
                return true;
            }
        } else {
            String[] acts;
            for (String act : acts = unionActs.split(",")) {
                if (!act.trim().equals(actNo)) continue;
                return true;
            }
        }
        return false;
    }

    public Object unionpay(XLHttpRequest request, XLHttpResponse response) {
        long uid = 0L;
        String userAccount = null;
        String ip = IpUtil.getIp(request);
        MainParam mainParam = null;
        String chargeType = StringUtils.filterInputWeak(request.getParameter("chargeType"));
        String cookieprefix = StringUtils.filterInputWeak(request.getParameter("cookieprefix"));
        try {
            mainParam = this.getMainParam(request, response, true);
            uid = mainParam.getUserid();
            userAccount = mainParam.getUserAccount();
        }
        catch (Exception e) {
            logger.error("ip[" + ip + "]\u8bf7\u6c42/jinzuan/pay.do\u7684session\u9a8c\u8bc1\u5931\u8d25", (Throwable)e);
        }
        if (mainParam == null) {
            return this.getReturn(cookieprefix, 11, "session\u9a8c\u8bc1\u5931\u8d25", chargeType, response);
        }
        if (uid == 0L || StringTools.isEmpty((String)userAccount)) {
            return this.getReturn(cookieprefix, 11, "session\u9a8c\u8bc1\u5931\u8d25", chargeType, response);
        }
        String userid = request.getCookieValue("userid");
        if (!userid.equals(uid + "")) {
            return this.getReturn(cookieprefix, 15, "\u8d26\u53f7\u975e\u6cd5", chargeType, response);
        }
        try {
            String copartnerId = StringUtils.filterInputWeak(request.getParameter("copartnerId"));
            String bankNo = StringUtils.filterInputWeak(request.getParameter("bankNo"));
            String payBizNo = StringUtils.filterInputWeak(request.getParameter("payBizNo"));
            String timeType = StringUtils.filterInputWeak(request.getParameter("timeType"));
            String numValue = StringUtils.filterInputWeak(request.getParameter("numValue"));
            String money = StringUtils.filterInputWeak(request.getParameter("money"));
            String priceNo = StringUtils.filterInputWeak(request.getParameter("priceNo"));
            String advNo = StringUtils.filterInputWeak(request.getParameter("advNo"));
            if (StringTools.isEmpty((String)copartnerId)) {
                copartnerId = "0000";
            }
            String actNo = StringUtils.filterInputWeak(request.getParameter("actNo"));
            String ext1 = StringUtils.filterInputWeak(request.getParameter("ext1"));
            logger.info("jinzuan unionpay.do  uid=" + userid + "&userAccount=" + userAccount + "&copartnerId=" + copartnerId + "&bankNo=" + bankNo + "&payBizNo=" + payBizNo + "&timeType=" + timeType + "&numValue=" + numValue + "&money=" + money + "&priceNo=" + priceNo + "&cookieprefix=" + cookieprefix + "&actNo=" + actNo + "&ext1=" + ext1);
            if (StringTools.isEmpty((String)userAccount) || StringTools.isEmpty((String)copartnerId) || StringTools.isEmpty((String)chargeType) || StringTools.isEmpty((String)payBizNo) || StringTools.isEmpty((String)timeType) || StringTools.isEmpty((String)numValue) || StringTools.isEmpty((String)priceNo) || StringTools.isEmpty((String)cookieprefix) || StringTools.isEmpty((String)money)) {
                return this.getReturn(cookieprefix, 2, "\u53c2\u6570\u4e3a\u7a7a", chargeType, response);
            }
            String openId = StringUtils.filterInputWeak(request.getParameter("openId"));
            if ("W3".equals(chargeType) && StringTools.isEmpty((String)openId)) {
                return this.getReturn(cookieprefix, 2, "\u53c2\u6570\u4e3a\u7a7a", chargeType, response);
            }
            PayOrder porder = new PayOrder();
            porder.setIp(ip);
            if (StringTools.isEmpty((String)actNo)) {
                porder.setActNo("niuxpaycenter");
            } else {
                porder.setActNo(actNo);
            }
            if (!this.checkUnionAct(actNo)) {
                return this.getReturn(cookieprefix, 17, "\u8be5\u6d3b\u52a8\u7f16\u53f7\u65e0\u6cd5\u4f7f\u7528\u7ec4\u5408\u5957\u9910", chargeType, response);
            }
            if (!ChargeTypeProxy.getInstance().checkChargeType(chargeType)) {
                return this.getReturn(cookieprefix, 3, "\u652f\u4ed8\u7c7b\u578b\u9519\u8bef", chargeType, response);
            }
            userAccount = UserUtil.getUserNameByUserId(uid + "");
            if (StringTools.isEmpty((String)userAccount)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)4, (Object)"\u8be5\u8d26\u53f7\u975e\u8fc5\u96f7\u8d26\u53f7");
            }
            if (StringTools.isNotEmpty((String)bankNo) && bankNo.equals("-1")) {
                bankNo = "";
            }
            porder.setBankNo(bankNo);
            porder.setBizNo("000001075");
            porder.setChargeType(chargeType);
            porder.setPayBizNo(payBizNo);
            porder.setAdvNo(advNo);
            porder.setOrderType(new Integer(1));
            porder.setMemberStatus(Integer.valueOf(1));
            porder.setTimeType(Integer.valueOf(Integer.parseInt(timeType)));
            porder.setNumValue(Long.valueOf(Long.parseLong(numValue)));
            Price price = PriceProxy.getInstance().getPrice(priceNo);
            if (price == null) {
                return this.getReturn(cookieprefix, 5, "\u8be5\u5355\u4ef7\u7c7b\u578b\u4e0d\u5b58\u5728", chargeType, response);
            }
            double basePrice = price.getPrice();
            double payPrice = price.getPayPrice();
            int timetype = price.getTimeType();
            if ((double)porder.getNumValue().longValue() * basePrice != Double.parseDouble(money)) {
                return this.getReturn(cookieprefix, 6, "\u91d1\u989d\u975e\u6cd5", chargeType, response);
            }
            porder.setOrderMoney(Double.valueOf((double)porder.getNumValue().longValue() * basePrice));
            porder.setPayMoney(Double.valueOf((double)porder.getNumValue().longValue() * payPrice));
            int mytimeType = porder.getTimeType();
            if (mytimeType != 1 && mytimeType != 2 && mytimeType != 3) {
                return this.getReturn(cookieprefix, 8, "\u65f6\u95f4\u7c7b\u578b\u9519\u8bef", chargeType, response);
            }
            if (timetype != mytimeType) {
                return this.getReturn(cookieprefix, 9, "\u65f6\u95f4\u7c7b\u578b\u4e0e\u89c4\u5b9a\u7684\u4e0d\u76f8\u7b26", chargeType, response);
            }
            String priceActNo = price.getActNo();
            if (!StringTools.isEmpty((String)priceActNo) && !actNo.equals(priceActNo)) {
                return this.getReturn(cookieprefix, 18, "\u8be5\u6d3b\u52a8\u7f16\u53f7\u548c\u8be5\u5355\u4ef7\u7c7b\u578b\u4e0d\u5bf9\u5e94", chargeType, response);
            }
            String startTime = price.getStartTime();
            String endTime = price.getEndTime();
            String nowtime = DateUtil.getNowTime();
            if (!StringTools.isEmpty((String)startTime) && DateUtil.compareTime(startTime, nowtime)) {
                return this.getReturn(cookieprefix, 16, "\u8be5\u7c7b\u578b\u7684\u5355\u4ef7\u8fd8\u672a\u5f00\u653e\u4f7f\u7528", chargeType, response);
            }
            if (!StringTools.isEmpty((String)endTime) && DateUtil.compareTime(nowtime, endTime)) {
                return this.getReturn(cookieprefix, 17, "\u8be5\u7c7b\u578b\u7684\u5355\u4ef7\u5df2\u7ecf\u8fc7\u671f", chargeType, response);
            }
            if ((userAccount.indexOf("@") > 0 || userAccount.indexOf(":") > 0) && UserClient.getInstance().checkChildrenAccount(uid + "")) {
                return this.getReturn(cookieprefix, 10, "\u5b50\u8d26\u53f7\u4e0d\u80fd\u5145\u503c", chargeType, response);
            }
            String paypwdType = null;
            String payPwd = null;
            if (porder.getChargeType().equals("A1")) {
                paypwdType = StringUtils.filterInputWeak(request.getParameter("paypwdtype"));
                payPwd = StringUtils.filterInputWeak(request.getParameter("payPwd"));
                if (StringTools.isEmpty((String)paypwdType) || StringTools.isEmpty((String)payPwd)) {
                    return this.getReturn(cookieprefix, 13, "\u652f\u4ed8\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", chargeType, response);
                }
            }
            porder.setUserId(Long.valueOf(uid));
            porder.setUserName(userAccount);
            porder.setNoticeActivity(Boolean.valueOf(false));
            porder.setExt1(ext1);
            porder.setOrderId(OrderIdUtil.getOrderId(request));
            porder.setOrderTime(sdf.format(new Date()));
            porder.setOrderStatus(new Integer(1));
            FacadeFactory.INSTANCE.getPayOrderBo().insert(porder);
            String chargeRequestUrl = this.getUnionPayUrl(porder, copartnerId, "\u725bX\u91d1\u94bb", paypwdType, payPwd, openId);
            logger.info("jinzuan unionpay.do addorder success uid=" + uid + ",userAccount=" + userAccount + ",order=" + porder.getOrderId() + " ,url=" + chargeRequestUrl);
            if (porder.getChargeType().equals("A1") || porder.getChargeType().equals("W3")) {
                ReturnData data = this.rechargeByAccount(porder.getChargeType(), porder.getOrderId(), chargeRequestUrl, request, response);
                if (data.getCode() == 0) {
                    HashMap<String, String> result = new HashMap<String, String>();
                    result.put("orderId", data.getMsg());
                    result.put("appId", data.getAppId());
                    result.put("nonceStr", data.getNonceStr());
                    result.put("package", data.getPackpage());
                    result.put("paySign", data.getPaySign());
                    result.put("signType", data.getSignType());
                    result.put("timeStamp", data.getTimeStamp());
                    return JsonObjectUtil.getRtnAndDataJsonObject((int)data.getCode(), result);
                }
                return JsonObjectUtil.getRtnAndDataJsonObject((int)data.getCode(), (Object)data.getMsg());
            }
            String orderIdCookieName = cookieprefix + "_orderId";
            CookieUtil.getInstance().addCookie(orderIdCookieName, porder.getOrderId(), response, null);
            response.redirect(chargeRequestUrl);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("orderId", porder.getOrderId());
            return JsonObjectUtil.getRtnAndDataJsonObject((int)0, result);
        }
        catch (SQLException e) {
            logger.info("jinzuan unionpay.do sqlerror uid=" + uid + ",userAccount=" + userAccount + ",reason=" + e.getMessage());
            e.printStackTrace();
            return this.getReturn(cookieprefix, 12, "\u8be5\u8ba2\u5355\u5df2\u5b58\u5728", chargeType, response);
        }
        catch (Exception e) {
            logger.info("jinzuan unionpay.do othererror uid=" + uid + ",userAccount=" + userAccount + ",reason=" + e.getMessage());
            e.printStackTrace();
            return this.getReturn(cookieprefix, 14, "\u7f51\u7edc\u5f02\u5e38", chargeType, response);
        }
    }

    private String getUnionPayUrl(PayOrder payOrder, String copartnerid, String productName, String paypwdType, String payPwd, String openId) throws Exception {
        String payerName = payOrder.getUserName();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("version", "v1.0");
        params.put("pageCharset", "1");
        if (StringTools.isEmpty((String)payOrder.getActNo()) || "niuxpaycenter".equals(payOrder.getActNo())) {
            params.put("bgUrl", callBackUrl);
        } else {
            params.put("bgUrl", unionCallBackUrl);
        }
        params.put("fgUrl", "http://vip.niu.xunlei.com");
        params.put("bizNo", unionbizno);
        params.put("orderId", payOrder.getOrderId());
        params.put("orderAmt", new Double(payOrder.getOrderMoney() * 100.0).intValue() + "");
        String uid = payOrder.getUserId() + "";
        TestAccountProxy.getInstance().checkTestAccount(params, uid);
        params.put("orderTime", orderTimeDf.format(sdf.parse(payOrder.getOrderTime())));
        params.put("payType", payOrder.getChargeType());
        params.put("xunleiId", payerName);
        params.put("xlnumId", payOrder.getUserId() + "");
        params.put("productName", productName);
        params.put("productDesc", productName);
        if (StringTools.isNotEmpty((String)payOrder.getBankNo())) {
            params.put("bankNo", payOrder.getBankNo());
        }
        params.put("payerName", payerName);
        params.put("ext1", "");
        params.put("ext2", payOrder.getPayBizNo());
        if (payOrder.getChargeType().equals("A1")) {
            params.put("other1", payPwd);
        }
        String signMsg = SignUtil.sign(params, unionchargekey.trim());
        String requestUrl = payUrl + "?" + SignUtil.getSignatureContent(params, "utf-8") + "&signMsg=" + signMsg;
        if (payOrder.getIp() != null) {
            requestUrl = requestUrl + "&clientIp=" + payOrder.getIp();
        }
        if (payOrder.getChargeType().equals("A1")) {
            requestUrl = requestUrl + "&paypwdType=" + paypwdType + "&payPwd=" + payPwd;
        }
        return requestUrl;
    }

    @CmdMapper(value={"/jinzuan/unionback.do"})
    public Object unionCallBack(XLHttpRequest request, XLHttpResponse response) {
        String version = this.getChargeParameter(request, "version");
        String orderId = this.getChargeParameter(request, "orderId");
        String orderAmt = this.getChargeParameter(request, "orderAmt");
        String orderTime = this.getChargeParameter(request, "orderTime");
        String xlpayId = this.getChargeParameter(request, "xlpayId");
        String xlpayTime = this.getChargeParameter(request, "xlpayTime");
        String gameid = this.getChargeParameter(request, "ext1");
        String paybizno = this.getChargeParameter(request, "ext2");
        String payResult = this.getChargeParameter(request, "payResult");
        String signMsg = this.getChargeParameter(request, "signMsg");
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        String result = "N";
        try {
            if (!"00".equals(payResult)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)1, (Object)"\u652f\u4ed8\u672a\u6210\u529f");
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", version);
            params.put("orderId", orderId);
            params.put("orderAmt", orderAmt);
            params.put("orderTime", orderTime);
            params.put("xlpayId", xlpayId);
            params.put("xlpayTime", xlpayTime);
            params.put("ext1", gameid);
            params.put("ext2", paybizno);
            params.put("payResult", payResult);
            params.put("signMsg", signMsg);
            logger.info("jinzuan unionback.do orderid=" + orderId + ", params=" + params);
            System.out.println("back params:" + params);
            if (!SignUtil.checkSign(params, unionchargekey)) {
                throw new Exception("\u6570\u636e\u6821\u9a8c\u4e0d\u6b63\u786e");
            }
            if (!StringTools.isEmpty((String)orderId)) {
                PayOrder order = new PayOrder();
                order.setOrderId(orderId);
                BaseSo baseSo = FacadeFactory.INSTANCE.getBaseSo();
                List polist = baseSo.findObjects((Object)order, new Page());
                if (polist != null && polist.size() > 0) {
                    PayOrder porder = (PayOrder)polist.get(0);
                    if (porder.getNoticeActivity().booleanValue()) {
                        throw new Exception("\u8be5\u5145\u503c\u8ba2\u5355\u5df2\u7ecf\u56de\u8c03\u8fc7");
                    }
                    if (BuQiProxy.getInstance().validBuQi(porder.getActNo())) {
                        FacadeFactory.INSTANCE.getPayOrderBo().addPayOrder(porder, true, true);
                    } else {
                        FacadeFactory.INSTANCE.getPayOrderBo().addPayOrder(porder, true, false);
                    }
                    result = "Y";
                    logger.info("ActivityProxy  start..............,orderid:" + orderId);
                    ActivityProxy.getInstance().notice(porder);
                    logger.info("ActivityProxy  end.............,orderid:" + orderId);
                }
            }
            logger.info("jinzuan unionback.do success orderId=" + orderId);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("jinzuan unionback.do error orderId=" + orderId + ",reason=" + e.getMessage());
            return "<xlresult>" + result + "</xlresult>";
        }
        return "<xlresult>" + result + "</xlresult>";
    }
}

