/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.pay.client;

import com.xunlei.util.Log;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;
import org.slf4j.Logger;

public class UserClient {
    private static final UserClient userClient = new UserClient();
    private static final Logger logger = Log.getLogger((String)"businessLogger");
    private final String queryURL = "http://interface.reg.vip.xunlei.com/service/usertype";

    public static UserClient getInstance() {
        return userClient;
    }

    private UserClient() {
    }

    public boolean checkChildrenAccount(String userid) {
        boolean result = false;
        try {
            String callurl = "http://interface.reg.vip.xunlei.com/service/usertype?request=checkChildren&userid=" + userid;
            String returnvalue = this.execute(callurl);
            logger.info("checkChildrenAccount userid" + userid + "result:" + returnvalue);
            JSONObject jsonObject = new JSONObject(returnvalue);
            String code = jsonObject.getString("result");
            if (code.equals("200")) {
                result = true;
            }
        }
        catch (Exception e) {
            logger.info("checkChildrenAccount exception userid" + userid, (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String execute(String callurl) {
        long start = System.currentTimeMillis();
        StringBuilder builder = new StringBuilder();
        URL url = null;
        HttpURLConnection httpURLConnection = null;
        BufferedReader rd = null;
        try {
            url = new URL(callurl);
            httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setRequestProperty("user-agent", "mozilla/4.0 (compatible;x11;Linux i686)");
            httpURLConnection.setRequestProperty("Connection", "close");
            httpURLConnection.setConnectTimeout(10000);
            httpURLConnection.setReadTimeout(10000);
            httpURLConnection.connect();
            InputStream in = httpURLConnection.getInputStream();
            rd = new BufferedReader(new InputStreamReader(in, "utf-8"));
            String line = null;
            while ((line = rd.readLine()) != null) {
                builder.append(line);
            }
        }
        catch (Exception e) {
            logger.info("execute GiftVipCart exception url=" + callurl, (Throwable)e);
        }
        finally {
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (Exception e) {}
            }
            url = null;
            httpURLConnection = null;
        }
        logger.info("GiftVipCartCost:" + (System.currentTimeMillis() - start) + ",url=" + callurl);
        return builder == null ? null : builder.toString();
    }
}

