/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.pay.activity;

import com.xunlei.util.Log;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;

public class ActivityConfig {
    private static final Logger logger = Log.getLogger(ActivityConfig.class);
    private Map<String, ConcurrentHashMap<String, String>> activityConfigMap = new ConcurrentHashMap<String, ConcurrentHashMap<String, String>>();
    private static final ActivityConfig activityConfig = new ActivityConfig();

    public static ActivityConfig getInstance() {
        return activityConfig;
    }

    public Map<String, ConcurrentHashMap<String, String>> getActivityConfigMap() {
        return this.activityConfigMap;
    }

    public void setActivityConfigMap(Map<String, ConcurrentHashMap<String, String>> activityConfigMap) {
        this.activityConfigMap = activityConfigMap;
    }

    private ActivityConfig() {
    }

    public synchronized void loadConfig() throws Exception {
        Document doc = null;
        try {
            SAXReader saxReader = new SAXReader();
            InputStream is = ActivityConfig.class.getResourceAsStream("/activityConfig.xml");
            doc = saxReader.read(is);
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("load activityConfig.xml exception", (Throwable)e);
            throw new Exception("load activityConfig.xml exception");
        }
        Element root = doc.getRootElement();
        if (!root.getName().equals("activitys")) {
            throw new Exception("activitys is not root element in activityConfig.xml");
        }
        List gameChildren = root.elements("activity");
        for (Object obj : gameChildren) {
            Element activity = (Element)obj;
            String actno = activity.attributeValue("actno");
            String actName = activity.attributeValue("name");
            List gameProperty = activity.elements("property");
            ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
            for (Object p : gameProperty) {
                Element property = (Element)p;
                map.put(property.attributeValue("name"), property.attributeValue("value"));
            }
            map.put("name", actName);
            this.activityConfigMap.put(actno, map);
            System.out.println("map:" + map);
        }
        logger.info("loadactivityConfig.xml:\u52a0\u8f7d\u5b8c\u6bd5\uff0cactivityConfigMap\uff1a" + this.activityConfigMap.toString());
    }

    public String getProperty(String actno, String key) {
        String value = null;
        if (this.activityConfigMap.get(actno) != null) {
            value = this.activityConfigMap.get(actno).get(key);
        }
        return value;
    }

    public static void main(String[] args) {
        try {
            ActivityConfig.getInstance().loadConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

