package com.xunlei.niux.pay.util;


import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import com.xunlei.common.util.XLRuntimeException;


public class Utility
{
	// private static Logger logger = Logger.getLogger(Utility.class);

	/**
	 * 生成固定长度的序列号，不足位数在前补0
	 */
	public static String createSerial(String src, int len)
	{
		String dest = "";
		if(src.length() >= len)
		{
			dest = src.substring(0, len);
		}
		else
		{
			dest = createSameChar("0", len - src.length()) + src;
		}
		return dest;
	}


	/**
	 * 返回�?��字符的串
	 */
	public static String createSameChar(String src, int len)
	{
		StringBuffer sb = new StringBuffer();
		for(int i = 0; i < len; i++)
		{
			sb.append(src);
		}
		return sb.toString();
	}


	/**
	 * 取固定长度字符串�?不足左补
	 */
	public static String getLeftFixedLengthString(String src, String c, int len)
	{
		if(src.length() >= len)
			return src.substring(0, len);
		StringBuffer ext = new StringBuffer();
		for(int i = src.length(); i < len; i++)
		{
			ext.append(c);
		}
		return ext.toString() + src;
	}




	/**
	 * 产生随机�? 参数为最大范�?
	 */
	public static int createRandomNum(int max)
	{
		Random random = new Random();
		return Math.abs(random.nextInt()) % max;
	}


	/**
	 * 将字符串中第s个字符和第e个字符对�?
	 */
	public static String moveChar(String pwd, int s, int e)
	{

		if(s > e)
		{
			int p = e;
			e = s;
			s = p;
		}
		if(s == e || s > 19)
			return pwd;

		String befor = pwd.substring(0, s);
		String s1 = pwd.substring(s, s + 1);
		String middle = pwd.substring(s + 1, e);
		String s2 = pwd.substring(e, e + 1);
		String after = pwd.substring(e + 1);
		return befor + s2 + middle + s1 + after;
	}


	/**
	 * 返回当前日期
	 */
	public static String dateofnow()
	{
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		return sdf.format(new java.util.Date());
	}


	/**
	 * 返回当前日期
	 */
	public static String otherdateofnow()
	{
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
		return sdf.format(new java.util.Date());
	}


	/**
	 * 返回当前时间
	 */
	public static String timeofnow()
	{
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Calendar curcal = Calendar.getInstance();
		return sdf.format(curcal.getTime());
	}


	/**
	 * 给指定时间加上一个数�?
	 * @param time1
	 *        要加上一数�?的时间，为null即为当前时间，格式为yyyy-MM-dd HH:mm:ss
	 * @param addpart
	 *        要加的部分：年月日时分秒分别为：YMDHFS
	 * @param num
	 *        要加的数�?
	 * @return 新时间，格式为yyyy-MM-dd HH:mm:ss
	 */
	public static String addTime(String time1, String addpart, int num)
	{
		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			String now = sdf.format(new Date());
			time1 = (time1 == null) ? now : time1;
			if(time1.length() < 19)
			{
				time1 += " 00:00:00";
			}
			GregorianCalendar cal = new GregorianCalendar();
			cal.setTime(sdf.parse(time1));
			if(addpart.equalsIgnoreCase("Y"))
			{
				cal.add(Calendar.YEAR, num);
			}
			else if(addpart.equalsIgnoreCase("M"))
			{
				cal.add(Calendar.MONTH, num);
			}
			else if(addpart.equalsIgnoreCase("D"))
			{
				cal.add(Calendar.DATE, num);
			}
			else if(addpart.equalsIgnoreCase("H"))
			{
				cal.add(Calendar.HOUR, num);
			}
			else if(addpart.equalsIgnoreCase("F"))
			{
				cal.add(Calendar.MINUTE, num);
			}
			else if(addpart.equalsIgnoreCase("S"))
			{
				cal.add(Calendar.SECOND, num);
			}
			return sdf.format(cal.getTime());
		}
		catch(Exception e)
		{
			throw new RuntimeException(e);
		}
	}


	/**
	 * 给指定日期加上一个数�?
	 * @param date1
	 *        要加上一数�?的日期，为null即为当前日期，格式为yyyy-MM-dd
	 * @param addpart
	 *        要加的部分：年月日分别为：YMD
	 * @param num
	 *        要加的数�?
	 * @return 新日期，格式为yyyy-MM-dd
	 */
	public static String addDate(String date1, String addpart, int num)
	{
		return addTime(date1, addpart, num).substring(0, 10);
	}


	/**
	 * 中文编码转换
	 */
	public static String ConvertCN2(String is)
	{
		// 异常判断
		if(is == null || is.compareTo("") == 0)
		{
			return "";
		}

		int l = is.length();
		// byte[] tmp = new byte[l];
		for(int q = 0; q < l; q++)
		{
			int t = (int)is.charAt(q);

			if(t > 255) // 已经是中�?
				return is;
		}

		String os;
		try
		{
			os = new String(is.getBytes("ISO-8859-1"), "GBK");
			return os;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			return "";
		}
	}


	

	/**
	 * 得到系统的时间戳
	 */
	public static String getTradeSn()
	{
		return "" + new java.util.Date().getTime();
	}


	public static String getTimeByTradeSn(long sn)
	{
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return sdf.format(new Date(sn));
	}


	public static String getUUID()
	{
		return UUID.randomUUID().toString();
	}


	/**
	 * 取固定长度字符串�?不足�?
	 */
	public static String getFixedLengthString(String src, String c, int len)
	{
		if(src.length() >= len)
			return src.substring(0, len);
		StringBuffer ext = new StringBuffer();
		for(int i = src.length(); i < len; i++)
		{
			ext.append(c);
		}
		return src + ext.toString();
	}


	/**
	 * 对迅雷ID进行计算，范�?0-99 flag = 0 : 根据1-2位计算库 flag = 1 : 根据3-4位计算表
	 */
	public static String getXunleiIdHash(String xunleiid, int flag) throws Exception
	{
		String src = null, rtn = null;
		String xunleiid2 = xunleiid.toLowerCase();
		int sum = 0;
		int mod = 0;
		if(flag == 0)
			src = xunleiid2.substring(0, 2);
		else if(flag == 1)
			src = xunleiid2.substring(2, 4);
		else
			throw new Exception("getXunleiIdHash error");
		// System.out.println("src=" + src);

		byte[] bytesrc = src.getBytes();
		for(int i = 0; i < bytesrc.length; i++)
		{
			// System.out.println(bytesrc[i]);
			sum += bytesrc[i];
		}
		mod = sum % 100;
		// System.out.println("sum=" + sum + ", mod=" + mod);
		if(mod < 10)
			rtn = "0" + mod;
		else
			rtn = "" + mod;
		return rtn;
	}


	

	public static void callshell(String path) throws Exception
	{
		long time = System.currentTimeMillis();
		try
		{
			Process process = Runtime.getRuntime().exec(path);
			InputStreamReader ir = new InputStreamReader(process.getInputStream());
			LineNumberReader input = new LineNumberReader(ir);
			String line;
			while((line = input.readLine()) != null)
				System.out.println(line);
		}
		catch(java.io.IOException e)
		{
			System.err.println("IOException " + e.getMessage());
			throw new Exception(e);
		}
		System.out.println("callshell:" + path + " and" + (System.currentTimeMillis() - time) / 1000 + "second");
	}


	public static DecimalFormat getNumberFormat()
	{
		DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance();
		df.setMinimumFractionDigits(2);
		df.setMaximumFractionDigits(2);
		df.setDecimalSeparatorAlwaysShown(true);
		String s = "###,##0.00";
		df.applyPattern(s);
		return df;
	}


	private static int se = 0;


	/**
	 * 生成新的申请�?
	 */
	public static synchronized String createApplyId()
	{
		String nextFrozeId = "";
		if(se > 99)
			se = 0;
		nextFrozeId = otherdateofnow().substring(2, 8) + getTradeSn().substring(3, 13) + createSerial("" + se, 2);
		se++;
		if(nextFrozeId.length() != 18)
			throw new XLRuntimeException("申请号长度错误[" + nextFrozeId + "]");
		return nextFrozeId;
	}


	/**
	 * 得到指定长度某byte数字
	 */
	public static byte[] getTheBytes(byte b, int len)
	{
		byte[] s = new byte[len];
		for(int i = 0; i < len; i++)
			s[i] = b;
		return s;
	}


	/**
	 * 返回源数据指定长度的byte数组 type: 0: 字符型，后面补空格， 1：数字型，前面补�?
	 */
	public static byte[] getGiveLengthBytes(int type, byte[] src, int len)
	{
		byte[] rtn = new byte[len];
		if(src.length > len)
		{
			System.arraycopy(src, 0, rtn, 0, len);
			return rtn;
		}
		if(type == 0)
		{
			// 后面补空�?
			byte[] s = getTheBytes((byte)0x20, len - src.length);
			rtn = addByteArray(src, s);
		}
		else
		{
			// 前面补零
			byte[] s = getTheBytes((byte)0x30, len - src.length);
			rtn = addByteArray(s, src);
		}
		return rtn;
	}


	/**
	 * 两个数组相加
	 */
	public static byte[] addByteArray(byte[] s1, byte[] s2)
	{
		byte[] rtn = new byte[s1.length + s2.length];
		System.arraycopy(s1, 0, rtn, 0, s1.length);
		System.arraycopy(s2, 0, rtn, s1.length, s2.length);
		return rtn;
	}


	/**
	 * 返回含中文字符的指定长度的字符串
	 */
	public static String getGBKGiveLengthBytes(String srcstr, int len) throws Exception
	{
		byte[] src = srcstr.getBytes("GBK");
		byte[] rtn = new byte[len];
		String result = null;
		if(src.length <= len)
		{
			result = srcstr;
			return result;
		}
		else
		{
			int lastbyte = 0;
			int lastbyteindex = 0;
			int i = 0;
			while(i < len)
			{
				if(src[i] < 256 && src[i] > 0)
				{
					lastbyte = src[i];
					lastbyteindex = i;
					i = i + 1;
				}
				else
				{
					lastbyte = src[i];
					lastbyteindex = i;
					i = i + 2;
				}
			}
			if(lastbyte < 256 && lastbyte > 0)
				rtn = getGiveLengthBytes(0, src, len);
			else if((lastbyte > 256 || lastbyte < 0) && lastbyteindex == (len - 2))
				rtn = getGiveLengthBytes(0, src, len);
			else if((lastbyte > 256 || lastbyte < 0) && lastbyteindex == (len - 1))
			{
				byte[] tempremarkBytes = new byte[len - 1];
				System.arraycopy(src, 0, tempremarkBytes, 0, len - 1);
				rtn = getGiveLengthBytes(0, tempremarkBytes, len);
			}
			result = new String(rtn, "GBK");
		}
		return result;
	}


	/**
	 * 判断IP地址是否范围�?
	 */
	// public static boolean isIpVerify(String reqip){
	// boolean flag = false;
	// // List<LibClassD> verifyips =
	// com.xunlei.pay.facade.IFacade.INSTANCE.getLibClassDByClassNo(PayFunctionConstant.LIBCLASS_MONITIP_SETS);
	// List<LibClassD> verifyips =
	// PayFunctionConstant.getMonitIpMap().get(PayFunctionConstant.LIBCLASS_MONITIP_SETS);
	// logger.debug("verifyips.size()="+verifyips.size());
	// for(LibClassD ip :verifyips )
	// {
	// if(reqip.equals(ip.getItemno().trim()))
	// flag =true;
	// }
	// return flag;
	// }
	public static void main(String[] args)
	{
		try
		{
			// String xunleiid = "zjgjyfs";
			// String hash_db = Utility.getXunleiIdHash(xunleiid, 0);
			// String hash_tb = Utility.getXunleiIdHash(xunleiid, 1);
			// System.out.println(xunleiid + ":" + hash_db + ", " + hash_tb);
			/*
			 * DecimalFormat df = getNumberFormat();
			 * System.out.println("1034.03883=" + df.format(1034.03883));
			 * System.out.println("0.08=" + df.format(0.08));
			 * System.out.println("23333034=" + df.format(23333034));
			 */
			// String reqip = "202.105.139.174";
			// System.out.println(isIpVerify(reqip));
			// String temp = "       ";

			/*
			 * String code2 =""; if(temp != null) code2 = temp.trim();
			 * System.out.println("16"+code2);
			 */

			// 中文转码
			/*
			 * String s = "迅雷龙与乡巴�?; System.out.println(s);
			 * System.out.println(java.net.URLEncoder.encode(s, "UTF8")); //写成
			 * utf-8 也可�?
			 * System.out.println(java.net.URLDecoder.decode("%E9%87%91%E5%B8%81"
			 * ,"UTF8"));
			 */

			for(int i = 0; i < 200; i++)
				System.out.println("" + createApplyId());

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}


	public static double percentToDouble(String percent)
	{
		NumberFormat nf = NumberFormat.getPercentInstance();
		double number = 0.0;
		try
		{
			number = nf.parse(percent).doubleValue();

		}
		catch(ParseException e)
		{
			e.printStackTrace();
		}
		return number;
	}


	private static final SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private static final SimpleDateFormat timeFormat2 = new SimpleDateFormat("yyyyMMddHHmmss");
	
	public static String formatToDateTime(String time){
		Date date;
		try
		{
			date = timeFormat2.parse(time);
			time=timeFormat.format(date);			
		}
		catch(ParseException e)
		{
			e.printStackTrace();
		}
		return time;
	}
	
	public static String formatToyyyyMMddHHmmss(String time){
		Date date;
		try
		{
			date = timeFormat.parse(time);
			time=timeFormat2.format(date);			
		}
		catch(ParseException e)
		{
			e.printStackTrace();
		}
		return time;
	}

	// 如果第一个日期在的第二个日期之后，返回true，否则返回false
	public static boolean after(String dateTimeFirst, String dateTimeSecond)
	{
		boolean flag = false;
		try
		{
			Date dateOne = timeFormat.parse(dateTimeFirst);
			Date dateTwo = timeFormat.parse(dateTimeSecond);
			flag = dateOne.after(dateTwo);
		}
		catch(ParseException e)
		{
			e.printStackTrace();
		}
		return flag;
	}


	// 如果第一个日期在的第二个日期之前，返回true，否则返回false
	public static boolean before(String dateTimeFirst, String dateTimeSecond)
	{
		boolean flag = false;
		try
		{
			Date dateOne = timeFormat.parse(dateTimeFirst);
			Date dateTwo = timeFormat.parse(dateTimeSecond);
			
			System.out.println(dateOne+"  "+dateTwo);
			flag = dateOne.before(dateTwo);
		}
		catch(ParseException e)
		{
			e.printStackTrace();
		}
		return flag;
	}
}
