package com.xunlei.niux.pay.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.xunlei.channel.util.Md5Encrypt;

public class SignUtil {
	 private static final Log log = LogFactory.getLog(SignUtil.class);
	 
	 public static boolean checkSign(Map param, String privateKey)
	    {
	        if(isEmpty(privateKey) || param == null)
	            return false;
	        String signMsg = (String)param.get("signMsg");
	        if(isEmpty(signMsg))
	        {
	            return false;
	        } else
	        {
	            String signed = sign(param, privateKey);
	            return signMsg.equals(signed);
	        }
	    }

	    public static String sign(Map param, String privateKey)
	    {
	        String content = getSignatureContent(param);
	        log.info((new StringBuilder()).append("\u9700\u8981\u7B7E\u540D\u5904\u7406\u7684URL\uFF1A").append(content).toString());
	        return sign(content, privateKey);
	    }

	    public static String sign(String content, String privateKey)
	    {
	        if(content == null)
	            return null;
	        else
	            return Md5Encrypt.md5((new StringBuilder()).append(content).append(privateKey).toString());
	    }

	    public static String getSignatureContent(Map param)
	    {
	        return getSignatureContent(param, null);
	    }

	    public static String getSignatureContent(Map param, String encodeCharset)
	    {
	        Properties prop = new Properties();
	        Iterator i$ = param.keySet().iterator();
	        do
	        {
	            if(!i$.hasNext())
	                break;
	            String key = (String)i$.next();
	            if(!key.equals("signMsg"))
	            {
	                String value = (String)param.get(key);
	                if(!isEmpty(value))
	                    prop.setProperty(key, value);
	            }
	        } while(true);
	        StringBuilder sb = new StringBuilder();
	        List keys = new ArrayList(prop.keySet());
	        Collections.sort(keys);
	        for(int i = 0; i < keys.size(); i++)
	        {
	            String key = (String)keys.get(i);
	            String value = prop.getProperty(key);
	            if(!isEmpty(encodeCharset))
	                try
	                {
	                    value = URLEncoder.encode(prop.getProperty(key), encodeCharset);
	                }
	                catch(Exception ex) { }
	            sb.append(i != 0 ? "&" : "");
	            sb.append(key).append("=").append(value);
	        }

	        return sb.toString();
	    }

	    public static boolean isEmpty(String value)
	    {
	        return value == null || value.length() == 0;
	    }

	 

	public static String sign(Map<String, String> param,String privateKey,String encodeCharset){
		return sign(getSignatureContent(param, encodeCharset),privateKey);
	}

	public static String urlEncode(String value,String charset){
		try {
			return URLEncoder.encode(value, charset);
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
	}
}
