package com.xunlei.niux.pay.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.log4j.Logger;


public class HttpUtil {
	
	private static final Logger logger = Logger.getLogger(HttpUtil.class);

	public static String execute(String path) {
		long start = System.currentTimeMillis();
		StringBuilder builder = new StringBuilder();
		URL url = null;
		HttpURLConnection httpURLConnection = null;
		BufferedReader rd = null;
		try {
			url = new URL(path);
			httpURLConnection = (HttpURLConnection) url.openConnection();
			int state = 0;
			httpURLConnection.setRequestProperty("user-agent",
					"mozilla/4.0 (compatible;x11;Linux i686)");
			httpURLConnection.setRequestProperty("Connection", "close");
			httpURLConnection.setConnectTimeout(10000);
			httpURLConnection.setReadTimeout(10000);
			httpURLConnection.connect();
			state = httpURLConnection.getResponseCode();
			InputStream in = httpURLConnection.getInputStream();

			rd = new BufferedReader(new InputStreamReader(in, "utf-8"));

			String line = null;
			while ((line = rd.readLine()) != null) {
				builder.append(line);
			}

		} catch (Exception e) {
			logger.info("execute  exception url=" + path, e);
		} finally {
			if (rd != null) {
				try {
					rd.close();
				} catch (Exception e) {

				}
			}
			url = null;
			httpURLConnection = null;
		}
		logger.info("executeVipCost:"
				+ (System.currentTimeMillis() - start + ",url=" + path));
		return builder == null ? null : builder.toString();
	}
}
