package com.xunlei.niux.pay.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import com.xunlei.util.StringTools;

public class DateUtil {

	private static final SimpleDateFormat daySDF = new SimpleDateFormat("yyyy-MM-dd");
	private static final SimpleDateFormat timeSDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyyMMddHHmmss");
	
	
	public static String getOrderTime(){
		return SDF.format(new Date());
	}
	/**
	 * 获得当前date
	 * @return
	 */
	public static Date getNowDate(){
		Calendar cal = Calendar.getInstance();
		return cal.getTime();
	}
	
	public static String getTime(Date date){
		return timeSDF.format(date);
	}
	
	/**
	 * 获得当前时间
	 * @return
	 */
	public static String getNowTime(){
		Calendar cal = Calendar.getInstance();
		Date date = cal.getTime();
		return timeSDF.format(date);
	}
	
	/**
	 * 获得当前日期
	 * @return
	 */
	public static String getNowDay(){
		Calendar cal = Calendar.getInstance();
		Date date = cal.getTime();
		return daySDF.format(date);
	}
	
	/**
	 * 判断前面的时间是否大于等于后面的时间
	 * @param time1
	 * @param time2
	 * @return
	 * @throws Exception
	 */
	public static boolean compareTime(String time1,String time2) throws Exception{
		if(StringTools.isEmpty(time1)) return false;
		if(StringTools.isEmpty(time2)) return true;
		DateFormat sdf = null;
		if(time1.length()==10){
			sdf = daySDF;
		}else{
			sdf = timeSDF;
		}
		Date date1 = sdf.parse(time1);
		Date date2 = sdf.parse(time2);
		return date1.getTime()-date2.getTime()>=0?true:false;
	}
}
