package com.xunlei.niux.pay.util;

import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.DefaultCookie;

import com.xunlei.common.util.StringTools;
import com.xunlei.netty.httpserver.component.XLHttpResponse;



public class CookieUtil {

	private static final CookieUtil instance = new CookieUtil();
	
	private CookieUtil(){
		
	}
	
	public static CookieUtil getInstance(){
		return instance;
	}
	
	 private  String domain = "niu.xunlei.com";
	
	  public void addCookie(String key, String value, XLHttpResponse response,String domain )
	    {
		   if(!StringTools.isEmpty(domain)){
			   addCookie(key, value, -1, response,domain);
		   }else{
			   addCookie(key, value, -1, response,this.domain);
		   }
	       
	    }

	    public void addCookie(String key, String value, int maxAge, XLHttpResponse response,String domain)
	    {
	        Cookie cookie = new DefaultCookie(key, value);
	        cookie.setDomain(domain);
	        cookie.setPath("/");
	        cookie.setMaxAge(maxAge);
	        response.addCookie(cookie);
	    }
	    
}
