package com.xunlei.niux.pay.task;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.Map.Entry;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.PayOrder;
import com.xunlei.niux.pay.activity.ActivityConfig;
import com.xunlei.niux.pay.util.DateUtil;
import com.xunlei.niux.pay.vo.Activity;


public class NoticeActivityTask extends TimerTask {

	private static final Logger logger = Logger.getLogger(NoticeActivityTask.class);

	@Override
	public void run() {
		try {
			logger.info("jinzuan NoticeActivityTask Start");
			Calendar calendar = Calendar.getInstance();
			String nowTime = DateUtil.getTime(calendar.getTime());
			calendar.add(Calendar.DATE, -1);
			String deadTime =  DateUtil.getTime(calendar.getTime());

			Map<String, ConcurrentHashMap<String, String>> activityConfigMap = ActivityConfig
					.getInstance().getActivityConfigMap();
			Set<Entry<String, ConcurrentHashMap<String, String>>> entryseSet = activityConfigMap
					.entrySet();
			for (Map.Entry<String, ConcurrentHashMap<String, String>> entry : entryseSet) {
				String actno = entry.getKey();
				Map<String, String> values = entry.getValue();
				String callbackURL = values.get("callbackURL");
				String startTime = values.get("startTime");
				String endTime = values.get("endTime");
				String vipRebates = values.get("vipRebates");
				String notice = values.get("notice");
				String key = values.get("key");
				String actName =  values.get("name");
				if (notice != null && notice.equals("true")
						&& (nowTime.compareTo(startTime) > 0)
						&& (deadTime.compareTo(endTime) < 0)) {
					PayOrder query = new PayOrder();
					query.setActNo(actno);
                    query.setNoticeActivity(false);
                    query.setOrderStatus(new Integer(3));
                    query.setOrderType(new Integer(1));
                    
                   // 补单忽略监控账号
					List<String> ignoreAccountList = new ArrayList<String>();		
					
                    Page page = new Page();
                    page.setPageNo(1);
                    page.setPageSize(100);
					List<PayOrder> needNotivityOrders = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
					
					logger.info("needNotivityActivityOrders Scan Orderid actno="+actno+",size="
							+ needNotivityOrders.size());
					for (final PayOrder payorder : needNotivityOrders) {
						Activity activity = new Activity();
						activity.setActName(actName);
						activity.setActno(actno);
						activity.setKey(key);
						activity.setCallbackURL(callbackURL);
						activity.setOrderid(payorder.getOrderId());
						activity.setTotalmoney(payorder.getOrderMoney()+"");
						activity.setPayMoney(payorder.getPayMoney()+"");
						activity.setUserid(payorder.getUserId()+"");
						activity.setUserName(payorder.getUserName());
						activity.setExtparam(payorder.getExt1());
						activity.setNumValue(payorder.getNumValue());
						activity.setTimeType(payorder.getTimeType());
						NoticeActivityWorker noticTask = new NoticeActivityWorker(
								activity);

						GamePayExecutor.getInstance().execute(noticTask);
						logger
								.info("NoticeActivityTask submit successfully !orderId="
										+ payorder.getOrderId());
					}
					Thread.sleep(5 * 1000);

				}

			}

			logger.info("NoticeActivityTask End Normally!");
		} catch (Exception e) {
			logger.error("NoticeActivityTask End Exception", e);
		}

	}
}
