package com.xunlei.niux.pay.task;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.apache.log4j.Logger;

public class GamePayExecutor {
	private static final Logger logger = Logger.getLogger(GamePayExecutor.class);
	private static final GamePayExecutor instance = new GamePayExecutor();
	private ExecutorService executor;

	public static GamePayExecutor getInstance() {
		return instance;
	}

	private GamePayExecutor() {
		executor = new ThreadPoolExecutor(5, 10, 10, TimeUnit.SECONDS,
				new ArrayBlockingQueue<Runnable>(10000),
				new ThreadPoolExecutor.DiscardOldestPolicy());
		Runtime.getRuntime().addShutdownHook(new Thread() {
			@Override
			public void run() {
				logger.info("GamePayExecutor().destroy()");
				GamePayExecutor.getInstance().destroy();
				logger.info("GamePayExecutor.getInstance().destroy()");
			}

		});

	}

	public void execute(Runnable task) {
		try {
			executor.submit(task);
		} catch (Exception e) {
			logger.info("Executor 添加任务异常", e);
		}
	}

	public void destroy() {

		executor.shutdown();
	}
}
