package com.xunlei.niux.pay.proxy;

import java.text.ParseException;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.util.DateUtil;
import com.xunlei.niux.data.jinzuan.vo.OrderStatus;
import com.xunlei.niux.data.jinzuan.vo.PayOrder;
import com.xunlei.niux.pay.util.HttpUtil;
import com.xunlei.util.Log;

public class JiFenShopProxy {
	 private static Logger logger = Log.getLogger(JiFenShopProxy.class);
	 private static final String BIZTYPE = "niux";
	 private static final String ACTNO = "jifen";
     private static final JiFenShopProxy instance = new JiFenShopProxy();
     private  String callback = null;
     
     private JiFenShopProxy(){
    	 callback = ActProxy.getInstance().getCallBackUrl(ACTNO);
     }
     
     public static JiFenShopProxy getInstance(){
    	 return instance;
     }
     
     /**
      * 查询用户在积分商城活动是否首次充值
      * @param userid
      * @return
      */
     private boolean isFirstPay(long userid){
    	 PayOrder query = new PayOrder();
    	 query.setUserId(userid);
    	 query.setActNo(ACTNO);
    	 query.setOrderStatus(3);
    	 Page page = new Page();
    	 page.setPageNo(1);
    	 page.setPageSize(3);
    	 List<PayOrder> polist = FacadeFactory.INSTANCE.getBaseSo().findObjects(query,page );
    	 if(polist == null||polist.size()<=1)return true;//首次充值
    	 return false;
     }
     
     private boolean jiFen(PayOrder payOrder){
    	 System.out.println("jiFen  .............");
    	 long userid = payOrder.getUserId();
    	 String orderid = payOrder.getOrderId();
    	 long num = payOrder.getPayMoney()==null?0:payOrder.getPayMoney().longValue();    	 
    	 System.out.println("jiFen  start  uid="+userid);
    	 boolean firstFlag = isFirstPay(userid);
    	 String url = getUrl(userid,orderid,num,firstFlag);
    	 logger.info("JiFenShopProxy userid:"+userid+",orderid:"+orderid+",url:"+url);    	 
    	 OrderStatus query = new OrderStatus();
    	 query.setUserId(userid);
    	 query.setOrderId(orderid);
    	 OrderStatus status = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
    	 if(status != null&&status.getNoticeJinFenShop()){
    		 return true;
    	 }    	     	 
    	 OrderStatus orderstatus = new OrderStatus();
		 orderstatus.setUserId(userid);
		 orderstatus.setOrderId(orderid);
		 orderstatus.setNoticeJinFenShop(false);
		 int code = -1;
    	 try{
        	 String responseText = HttpUtil.execute(url);	
        	 JSONObject jsonObject = new JSONObject(responseText);
     		 code = jsonObject.getInt("result");     		
     		 if(code==1){
     			 logger.info("JiFenShopProxy success userid:"+userid+",orderid:"+orderid+",responseText:"+responseText);     			
     			 orderstatus.setNoticeJinFenShop(true);
     			 orderstatus.setJinFenShopTime(DateUtil.getNowDay());     
     			 return true;
     		 }else{
     			  logger.info("JiFenShopProxy failure userid:"+userid+",orderid:"+orderid+",responseText:"+responseText);     		
     			  orderstatus.setReason("code:"+code);
     			return false;
     		 }
    	 }catch(Exception e){
    		 logger.error("JiFenShopProxy failure userid:"+userid+",orderid:"+orderid+",reason:"+e.getMessage());
    		 orderstatus.setReason(e.getMessage());
    	 }finally{    		 
    		 if(status !=null){//如果之前已经通知过
    			 if(!status.getNoticeJinFenShop()){//如果之前通知失败
    				 if(code == 1){
    					 status.setNoticeJinFenShop(true);
    					 try {
							status.setJinFenShopTime(DateUtil.getNowDay());
						} catch (ParseException e) {
							e.printStackTrace();
						}     
    					 FacadeFactory.INSTANCE.getBaseSo().updateObjectById(status);
    				 }    				
    			 }
    		 }else{//如果之前没有通知下过
    			 FacadeFactory.INSTANCE.getBaseSo().addObject(orderstatus);
    		 }			
    	 }
    	 return false;
     }
     
     public boolean addJiFen(PayOrder payOrder){
    	 if(!payOrder.getActNo().equals(ACTNO))return false;
    	 return jiFen(payOrder);
     }

     
     private String getUrl(long userid,String orderid,long num,boolean firstFlag){    	 
    	 System.out.println("jifen callback:"+callback);
    	 StringBuffer sb = new StringBuffer(callback);
    	 sb.append("&userid=").append(userid).append("&orderid=").append(orderid)
    	 .append("&num=").append(num).append("&onenum=").append(firstFlag?2*num:0)
    	 .append("&biztype=").append(BIZTYPE);    	     	 
    	 return sb.toString();
     }
}
