package com.xunlei.niux.pay.proxy;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import com.xunlei.niux.pay.activity.ActivityConfig;

public class ActProxy {

	private static final ActProxy instance = new ActProxy();
	
	private ActProxy(){
		
	}
	
	public static ActProxy getInstance(){
		return instance;
	}
	
	public boolean isValidAct(String actNo){
		Map<String, ConcurrentHashMap<String, String>> activityConfigMap = ActivityConfig
				.getInstance().getActivityConfigMap();
		ConcurrentHashMap<String, String> map = activityConfigMap.get(actNo);
		return map==null?false:true;
	}
	
	
	public String getCallBackUrl(String actNo){
		Map<String, ConcurrentHashMap<String, String>> activityConfigMap = ActivityConfig
				.getInstance().getActivityConfigMap();
		ConcurrentHashMap<String, String> map = activityConfigMap.get(actNo);
		if(map == null)return null;
		return map.get("callbackURL");
	}
	
}
