package com.xunlei.niux.pay.cmd;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.channel.util.Md5Encrypt;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.CodeCode;
import com.xunlei.niux.data.jinzuan.vo.MemberShip;
import com.xunlei.niux.data.jinzuan.vo.PayOrder;
import com.xunlei.niux.data.jinzuan.vo.Price;
import com.xunlei.niux.data.jinzuan.vo.PrivateKey;
import com.xunlei.niux.pay.DefaultCmd;
import com.xunlei.niux.pay.activity.ActivityProxy;
import com.xunlei.niux.pay.client.PayResponse;
import com.xunlei.niux.pay.client.UserClient;
import com.xunlei.niux.pay.proxy.GoodsInfoUtil;
import com.xunlei.niux.pay.proxy.JiFenShopProxy;
import com.xunlei.niux.pay.proxy.ValidIPProxy;
import com.xunlei.niux.pay.util.Constant;
import com.xunlei.niux.pay.util.CookieUtil;
import com.xunlei.niux.pay.util.DateUtil;
import com.xunlei.niux.pay.util.RBundleUtil;
import com.xunlei.niux.pay.util.SignUtil;
import com.xunlei.niux.pay.util.StringUtil;
import com.xunlei.niux.pay.util.Utility;
import com.xunlei.niux.pay.util.VerifyCodeUtil;
import com.xunlei.niux.pay.vo.OrderData;
import com.xunlei.niux.pay.vo.ReturnData;
import com.xunlei.proxy.ProxyFactory;
import com.xunlei.proxy.socket.UserInfoProxy;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_base;
import com.xunlei.util.Log;



@Service
public class PayCmd extends DefaultCmd{
	private static Logger logger = Log.getLogger(PayCmd.class);
	private static final SimpleDateFormat orderTimeDf = new SimpleDateFormat("yyyyMMddHHmmss");
	private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private static final String machineName = RBundleUtil.getString("pay", "machineName");//机器名
	private static final String callBackUrl = RBundleUtil.getString("pay", "callBackUrl");//支付网关回调地址
	private static final String actCallBackUrl = RBundleUtil.getString("pay", "actCallBackUrl");//活动页支付网关回调地址
	private static final String unionCallBackUrl = RBundleUtil.getString("pay", "unionCallBackUrl");//活动页支付网关回调地址
	private static final String payUrl = RBundleUtil.getString("pay", "payUrl");//支付网关接口地址
	private static final String noticeWeiXiUrl = RBundleUtil.getString("pay", "noticeWeiXiUrl");//微信通知发货接口地址
	private static final String chargekey = RBundleUtil.getString("pay", "chargekey");//支付网关充值和回调的密钥
	private static final String unionbizno = RBundleUtil.getString("pay", "unionbizno");//白金和金钻组合支付业务编号	
	private static final String unionchargekey = RBundleUtil.getString("pay", "unionchargekey");//白金和金钻组合支付密钥	
    private static final String MAXNUM = RBundleUtil.getString("pay", "maxnum");//赠送支持的最大天数
    private static final String testAccount = RBundleUtil.getString("pay", "testAccount");//测试账号
    private static final String presentKeyIp = RBundleUtil.getString("pay", "presentKeyIp");//生成赠送密钥的ip
    private static final String APPID = RBundleUtil.getString("pay", "appId");//微信支付时的应用id
    private static final String regEx="[A-Z,a-z,0-9,-]*";
    private static final String cancelkey = RBundleUtil.getString("pay", "cancelkey");//退订密钥
    private static final String bizNo = "110001";
    private static final String buQiActNos = RBundleUtil.getString("pay", "buQiActNos");//补齐活动
    private static final String testchargekey = RBundleUtil.getString("pay", "testchargekey");//支付网关充值和回调的密钥
    
    
    /**
     * 赠送接口生成业务编号和密钥
     * @param request
     * @param response
     * @return
     */
    @CmdMapper({"/jinzuan/getpresentkey.do"})
  	public Object getPresentKey(XLHttpRequest request,XLHttpResponse response){
    	String ip = request.getRemoteIP();
    	try{
    		response.setInnerContentType(XLHttpResponse.ContentType.plain);
    		String ptype = request.getParameter("type");
    		String account = request.getParameter("account");
    		if(StringTools.isEmpty(ptype)||StringTools.isEmpty(account)){
    			return  JsonObjectUtil.getRtnAndDataJsonObject(1,"参数为空");	
    		}
    		logger.info("getpresentkey.do ip="+ip+",type="+ptype+",account="+account);
    		if(!StringTools.isEmpty(presentKeyIp)){
    			if(presentKeyIp.indexOf(",")==-1){
    				if(!presentKeyIp.trim().equals(ip)){
    					return  JsonObjectUtil.getRtnAndDataJsonObject(2,"无效ip");	  
    				}
    			}else{
    				String keyips [] = presentKeyIp.split(",");
    				boolean flag = false;
    				for(String keyip:keyips){
    					if(StringTools.isEmpty(keyip))continue;
    					if(keyip.trim().equals(ip)){
    						flag = true;
    						break;
    					}
    				}
    				if(!flag){
    					return  JsonObjectUtil.getRtnAndDataJsonObject(2,"无效ip");	  
    				}
    			}
    		}
    		PrivateKey query = new PrivateKey();
    		Page page = new Page();
    		page.setPageNo(1);
    		page.setPageSize(1);
    		page.addOrder("seqId", OrderType.DESC);
    		List<PrivateKey> pklist = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
    		PrivateKey mykey = new PrivateKey();
    		if(pklist == null||pklist.size()==0){
    			mykey.setBizNo("100001");
    			mykey.setKeyType(Integer.parseInt(ptype));
    			mykey.setPrivateKey(UUID.randomUUID().toString());
    			mykey.setInputTime(now());
    			mykey.setInputBy(account);
    		}else{
    			PrivateKey pkey = pklist.get(0);   			
    			mykey.setBizNo((Long.parseLong(pkey.getBizNo())+1)+"");
    			mykey.setKeyType(Integer.parseInt(ptype));
    			mykey.setPrivateKey(UUID.randomUUID().toString());
    			mykey.setInputTime(now());
    			mykey.setInputBy(account);
    		}
    		FacadeFactory.INSTANCE.getBaseSo().addObject(mykey);
    		Map<String,Object> result = new HashMap<String,Object>();
    		result.put("bizno", mykey.getBizNo());
    		result.put("privatekey", mykey.getPrivateKey());
    		logger.info("getpresentkey.do success ip="+ip+",type="+ptype+",account="+account+",bizno="+mykey.getBizNo()+",privatekey="+mykey.getPrivateKey());
    		return  JsonObjectUtil.getRtnAndDataJsonObject(0,result);	  
    	}catch(Exception e){
    		return  JsonObjectUtil.getRtnAndDataJsonObject(3,"未知错误");	  
    	}
    }
    
    /**
     * 查询是否首次充值成为金钻会员
     * @param request
     * @param response
     * @return
     */
    @CmdMapper({"/jinzuan/queryFirstPay.do"})
	public Object queryFirstPay(XLHttpRequest request,XLHttpResponse response){
		try{
			 response.setInnerContentType(XLHttpResponse.ContentType.plain);
			 String userid = request.getParameter("userid");
			 if(StringTools.isEmpty(userid)){
				 return  JsonObjectUtil.getRtnAndDataJsonObject(1,"参数为空");	  
			 }
			 String ip = request.getRemoteIP();
			 if(!ValidIPProxy.getInstance().isValidIp(ip,1)){
				 return  JsonObjectUtil.getRtnAndDataJsonObject(2,"无效ip");	  
			 }
			 Map<String,Object> result = new HashMap<String,Object>();
			 PayOrder query = new PayOrder();
			 query.setOrderStatus(3);//成功的订单
			 query.setUserId(Long.parseLong(userid));//用户
			 String orderType = request.getParameter("orderType");
			 if(!StringTools.isEmpty(orderType)){
				 int type = Integer.parseInt(orderType);
				 query.setOrderType(type);//充值
			 }			 
			 String actNo = request.getParameter("actNo");
			 if(!StringTools.isEmpty(actNo)){
				 query.setActNo(actNo);
			 }
			 Page page = new Page();
			 page.setPageNo(1);
			 page.setPageSize(1);
			 List<PayOrder> polist = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
			 if(polist == null||polist.size()==0){
				 result.put("flag", 0);
			 }else{
				 result.put("flag", 1);
			 }
			 return  JsonObjectUtil.getRtnAndDataJsonObject(0, result);
		}catch(Exception e){
			e.printStackTrace();
			return  JsonObjectUtil.getRtnAndDataJsonObject(3,"查询失败");	  
		}
    }
    
    
    /**
     * 查询玩家充值过的所有订单
     * @param request
     * @param response
     * @return
     */
    @CmdMapper({"/jinzuan/queryOrder.do"})
	public Object queryOrder(XLHttpRequest request,XLHttpResponse response){
    	//验证session
		MainParam mainParam=null;
		long uid = 0;		
		try{
			 mainParam=this.getMainParam(request, response, true);
			 uid = mainParam.getUserid();
//			String userid = request.getParameter("uid");
//			uid = Long.parseLong(userid);
//			 long uid = 111389930L; 
			 String pagesize = request.getParameter("pagesize");
			 String pageno = request.getParameter("pageno");
			 String actNo = request.getParameter("actNo");//活动编号
			 int pageSize = 20;
			 int pageNo = 1;
			 if(!StringTools.isEmpty(pagesize)){
				 pageSize = Integer.parseInt(pagesize);
			 }
			 if(!StringTools.isEmpty(pageno)){
				 pageNo = Integer.parseInt(pageno);
			 }
			 List<String> params = new ArrayList<String>();
			 if(StringTools.isEmpty(actNo)){
				 params.add("1");
				 params.add("1");
			 }else{
				 params.add(actNo);
				 params.add(actNo); 
			 }
			 StringBuffer sql = new StringBuffer("SELECT s1.finishTime,s1.timeType,s1.numValue,s1.orderType,s1.payMoney,s2.orderEndDate ,s2.dayNum payDays  FROM (select * from jinzuan_payorder where userid='"+uid+"') s1 INNER JOIN (select * from jinzuan_memberdetail where userid='"+uid+"') s2");
			 sql.append(" ON s1.orderid = s2.orderid  ")
			 .append(" where  s1.orderStatus=3   and ( 1=? or s1.actNo=? )");
			
			 sql.append(" ORDER BY s1.finishTime DESC ")
			 .append(" limit ").append((pageNo-1)*pageSize).append(",").append(pageSize);
			 List<OrderData> list = FacadeFactory.INSTANCE.getBaseSo().executeQuery(OrderData.class, sql.toString(), params);		
			 logger.info("orderquerysql:"+sql);
			 StringBuffer countsql = new StringBuffer("SELECT count(*) FROM (select * from jinzuan_payorder where userid='"+uid+"') s1 INNER JOIN (select * from jinzuan_memberdetail where userid='"+uid+"') s2");
			 countsql.append(" ON s1.orderid = s2.orderid  ")
			 .append(" where  s1.orderStatus=3");
			 logger.info("ordercountsql:"+countsql);
			 int count = FacadeFactory.INSTANCE.getBaseSo().count(countsql.toString(), new Object[]{});
			 Map<String,Object> result = new HashMap<String,Object>();
			 System.out.println("count:"+count);
			 result.put("totalCount", count);
			 for(OrderData data:list){
				String time = data.getFinishTime();
				if(StringTools.isNotEmpty(time)){
					if(time.length()>19){
						time = time.substring(0,19);
					}
				}
				data.setFinishTime(time);
			 }
			 result.put("orderList", list);
			 logger.info("jinzuan queryOrder.do  uid="+uid+",list="+list);
			return  JsonObjectUtil.getRtnAndDataJsonObject(0,result);	  
		}catch(Exception e){
			e.printStackTrace();
			return  JsonObjectUtil.getRtnAndDataJsonObject(1,"查询失败");	  
		}

    }
    
	
	/**
	 * 查询订单状态接口
	 * @param request
	 * @param response
	 * @return
	 */
	@CmdMapper({"/jinzuan/queryOrderStatus.do"})
	public Object queryOrderStatus(XLHttpRequest request,XLHttpResponse response){
		String orderid = StringUtil.filterInputWeak(request.getParameter("orderid"));
		try{
			//response.setInnerContentType(XLHttpResponse.ContentType.plain);
			if(StringTools.isEmpty(orderid)){
				return JsonObjectUtil.getRtnAndDataJsonObject(2,"参数非法");
			}else{
				PayOrder payOrderQuery = new PayOrder();
				payOrderQuery.setOrderId(orderid);
				PayOrder payOrder = FacadeFactory.INSTANCE.getBaseSo().findObject(payOrderQuery);
				if(payOrder == null){
					return JsonObjectUtil.getRtnAndDataJsonObject(3,"支付暂未成功,请稍后查询");
				}
				int orderStatus = payOrder.getOrderStatus();
				logger.info("queryOrderStatus.do orderid="+orderid+",orderStatus="+orderStatus);
				switch(orderStatus){
				      case 1:
				    	     return JsonObjectUtil.getRtnAndDataJsonObject(4,"订单已生成但未支付");
				      case 2:
				    	     return JsonObjectUtil.getRtnAndDataJsonObject(5,"订单支付成功但未增加会员时间");
				      default:
				    		 return JsonObjectUtil.getRtnAndDataJsonObject(0,"充值成功");	  
				}
			}
		}catch(Exception e){
			logger.info("jinzuan/queryOrderStatus.do orderid="+orderid+",reason="+e.getMessage());
			return JsonObjectUtil.getRtnAndDataJsonObject(6,"未知错误");
		}
	}
	
	/**
	 * 查询激活码状态
	 * @param request
	 * @param response
	 * @return
	 */
	@CmdMapper({"/jinzuan/codestatus.do"})
	public Object codeStatus(XLHttpRequest request,XLHttpResponse response){
		long uid = 0L;
		String userAccount = null;		
		MainParam mainParam=null;
		String ip =  getIp(request);
		try{
			 mainParam=this.getMainParam(request, response, true);
			 uid = mainParam.getUserid();
			 userAccount = mainParam.getUserAccount();
		}catch(Exception e){
			logger.error("ip["+ip+"]请求/jinzuan/pay.do的session验证失败", e);		
		}
		if(mainParam==null){
			 return JsonObjectUtil.getRtnAndDataJsonObject(11,"session验证失败");
		}
	    if(uid==0||StringTools.isEmpty(userAccount)){
	    	return JsonObjectUtil.getRtnAndDataJsonObject(11,"session验证失败");
	    }	 
	    String userid = request.getCookieValue("userid");
	    if(!userid.equals(uid+"")){
		   return JsonObjectUtil.getRtnAndDataJsonObject(12,"账号非法");
	    }
	    String acode = request.getParameter("acode");
	    if(StringTools.isEmpty(acode)){
	    	 return JsonObjectUtil.getRtnAndDataJsonObject(3,"参数为空");
	    }
	    acode = acode.toUpperCase();
	    int len = acode.length();
	    if(len <16||len>20){
	    	return JsonObjectUtil.getRtnAndDataJsonObject(6,"非法激活码");
	    }
	    if(!checkCode(acode)){
	    	return JsonObjectUtil.getRtnAndDataJsonObject(6,"非法激活码");
	    }
	    CodeCode query = new CodeCode();
	    query.setAcode(acode);
	    CodeCode code = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
	    if(code == null){
	    	return JsonObjectUtil.getRtnAndDataJsonObject(4,"该激活码不存在");
	    }
	    int type = code.getFlag().intValue();
	    switch(type){
	    case 1:
	    	return JsonObjectUtil.getRtnAndDataJsonObject(0,"未使用");
	    case 2:
	    	return JsonObjectUtil.getRtnAndDataJsonObject(1,"已使用");
	    case 3:
	    	return JsonObjectUtil.getRtnAndDataJsonObject(2,"冻结");
	    default:
	    	return JsonObjectUtil.getRtnAndDataJsonObject(5,"该激活码状态不正确");
	    }
	}
	
	/**
	 * 获得ip地址
	 * @param request
	 * @return
	 */
	private String getIp(XLHttpRequest request){
		String ip = request.getHeader("x-forwarded-for");
		if (ip == null || ip.length() == 0
				|| "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0
				|| "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("WL-Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0
				|| "unknown".equalsIgnoreCase(ip)) {
			ip = request.getRemoteHost();
		}
		return ip;
	}
	
	/**
	 * 激活码支付
	 * @param request
	 * @param response
	 * @return
	 */
	@CmdMapper({"/jinzuan/codepay.do"})
	public Object codePay(XLHttpRequest request,XLHttpResponse response){
		long uid = 0L;
		String userAccount = null;		
		String ip = getIp(request);
		String acode = StringUtil.filterInputWeak(request.getParameter("acode"));	//激活码
		//验证session
		MainParam mainParam=null;
		try{
			 mainParam=this.getMainParam(request, response, true);
			 uid = mainParam.getUserid();
			 userAccount = mainParam.getUserAccount();
		}catch(Exception e){
			logger.error("ip["+ip+"]请求/jinzuan/codepay.do的session验证失败", e);		
		}
		if(mainParam==null){
			 return JsonObjectUtil.getRtnAndDataJsonObject(11,"session验证失败");
		}
	    if(uid==0||StringTools.isEmpty(userAccount)){
	    	return JsonObjectUtil.getRtnAndDataJsonObject(11,"session验证失败");
	    }	 
	    
	    //判断验证码是否有效
		String verifycode=request.getParameter("verifycode", "");
		String verifykey=request.getCookieValue("VERIFY_KEY");
		if(StringTools.isEmpty(verifycode)){
			return JsonObjectUtil.getRtnAndDataJsonObject(14,"验证码不能为空");
		}
		String verifytype="MVA";
		if(!VerifyCodeUtil.isVerify(verifykey, verifytype, verifycode)){
			 return JsonObjectUtil.getRtnAndDataJsonObject(13,"您输入的验证码错误，请重新输入！");
		}
	    
	    String userid = request.getCookieValue("userid");
	    if(!userid.equals(uid+"")){
		   return JsonObjectUtil.getRtnAndDataJsonObject(12,"账号非法");
	    }
	    logger.info("jinzuan codepay.do  uid="+userid+"&userAccount="+userAccount+"&code="+acode);
	    if(StringTools.isEmpty(acode)){
	    	 return JsonObjectUtil.getRtnAndDataJsonObject(1,"参数为空");
	    }
	    acode = acode.toUpperCase();//激活码转化为大写
	    if(!checkCode(acode)){
	    	return JsonObjectUtil.getRtnAndDataJsonObject(8,"非法激活码");
	    }
		userAccount = getUserNameByUserId(uid+"");
        if(StringTools.isEmpty(userAccount)){
  			return JsonObjectUtil.getRtnAndDataJsonObject(2,"该账号非迅雷账号");
        }
        if(userAccount.indexOf("@")>0||userAccount.indexOf(":")>0){
			 if(UserClient.getInstance().checkChildrenAccount(uid+"")){
				 return JsonObjectUtil.getRtnAndDataJsonObject(3,"子账号不能使用激活码");
			 }
	    }
        
        try{        	
        	String orderid = getOrderId();//订单号
        	String actno = StringUtil.filterInputWeak(request.getParameter("actno"));	
        	  if(StringTools.isEmpty(actno)){
        		  actno="niuxpaycenter";//默认的活动编号
               }  
        	  FacadeFactory.INSTANCE.getCodeCodeBo().use(acode, orderid, userAccount, uid,ip, Constant.CHARGE_BIZI_NO);
        	return JsonObjectUtil.getRtnAndDataJsonObject(0, "激活成功");
        }catch(XLRuntimeException ee){
        	 logger.info("jinzuan codepay.do error uid="+uid+",userAccount="+userAccount+",acode="+acode+",reason="+ee.getMessage());
			 ee.printStackTrace();
        	return JsonObjectUtil.getRtnAndDataJsonObject(6, ee.getMessage());
        }catch(Exception e){
        	 logger.info("jinzuan codepay.do othererror uid="+uid+",userAccount="+userAccount+",acode="+acode+",reason="+e.getMessage());
			 e.printStackTrace();
        	return JsonObjectUtil.getRtnAndDataJsonObject(7, "网络异常");
        }           
	}
	
	
	public int  getLeaveMonths(MemberShip ship){
		String memberExpireDate = ship.getMemberExpireDate();
		return getMonths(memberExpireDate);		
	}
	
	private int getMonths(String time){
		try{
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			Date date1 = sdf.parse(sdf.format(new Date()));
			Date date2 = sdf.parse(time);
			long data = (date2.getTime()-date1.getTime())/(1000*60*60*24);
			if(data%31==0){
				return (int)(data/31);
			}else{
				return (int)(data/31+1);
			}
		}catch(Exception e){
			e.printStackTrace();
		}
		return 0;
		
	}
	
	/**
	 * 金钻充值接口
	 * @param request
	 * @param response
	 * @return
	 */
	@CmdMapper({"/jinzuan/pay.do"})
	public Object pay(XLHttpRequest request,XLHttpResponse response){
			long uid = 0L;
			String userAccount = null;		
			String ip = getIp(request);
 		 
//			//验证session
			MainParam mainParam=null;
			String chargeType = StringUtil.filterInputWeak(request.getParameter("chargeType"));	
			String cookieprefix = StringUtil.filterInputWeak(request.getParameter("cookieprefix"));
			try{
				 mainParam=this.getMainParam(request, response, true);
				 uid = mainParam.getUserid();
				 userAccount = mainParam.getUserAccount();
			}catch(Exception e){
				logger.error("ip["+ip+"]请求/jinzuan/pay.do的session验证失败", e);		
			}
			if(mainParam==null){
				return getReturn(cookieprefix,11,"session验证失败",chargeType,response);
			}
		    if(uid==0||StringTools.isEmpty(userAccount)){
		    	return getReturn(cookieprefix,11,"session验证失败",chargeType,response);
		    }
		 
		 String userid = request.getCookieValue("userid");
		 if(!userid.equals(uid+"")){
			 return getReturn(cookieprefix,15,"账号非法",chargeType,response);
		 }
		 try{			
			  //String userid =  StringUtil.filterInputWeak(request.getParameter("userid"));	 
			  //userAccount =  StringUtil.filterInputWeak(request.getParameter("userAccount"));	 
		      String copartnerId =  StringUtil.filterInputWeak(request.getParameter("copartnerId"));	            
	          String bankNo = StringUtil.filterInputWeak(request.getParameter("bankNo"));	         
	          String payBizNo = StringUtil.filterInputWeak(request.getParameter("payBizNo"));	                  
	          String timeType = StringUtil.filterInputWeak(request.getParameter("timeType"));	          
	          String numValue = StringUtil.filterInputWeak(request.getParameter("numValue"));	//购买的月数或年数          
	          String money = StringUtil.filterInputWeak(request.getParameter("money"));
	          String priceNo = StringUtil.filterInputWeak(request.getParameter("priceNo"));
	          String advNo = StringUtil.filterInputWeak(request.getParameter("advNo"));//渠道编号
	          
	          if(StringTools.isEmpty(copartnerId)){
	        	  copartnerId = Constant.COPARTNER_XUNLEI;
	          }
	          String actNo = StringUtil.filterInputWeak(request.getParameter("actNo"));
	          String ext1 = StringUtil.filterInputWeak(request.getParameter("ext1"));
	          logger.info("jinzuan pay.do  uid="+userid+"&userAccount="+userAccount+"&copartnerId="+copartnerId+"&bankNo="+bankNo+"&payBizNo="+payBizNo+"&timeType="+timeType+"&numValue="+numValue+"&money="+money+"&priceNo="+priceNo+"&cookieprefix="+cookieprefix+"&actNo="+actNo+"&ext1="+ext1);
	          if( StringTools.isEmpty(userAccount)||
	        		  StringTools.isEmpty(copartnerId)||
	        		  StringTools.isEmpty(chargeType)||
	        		  StringTools.isEmpty(payBizNo)||
	        		  StringTools.isEmpty(timeType)||
	        		  StringTools.isEmpty(numValue)||
	        		  StringTools.isEmpty(priceNo)||
	        		  StringTools.isEmpty(cookieprefix)||
	        		  StringTools.isEmpty(money)){
	        	  return getReturn(cookieprefix,2,"参数为空",chargeType,response);
	         }
	        //uid = Long.parseLong(userid);
	        String openId = StringUtil.filterInputWeak(request.getParameter("openId"));
	        if(Constant.CHARGE_BY_WEIXIN_GZZH.equals(chargeType)){
	        	if(StringTools.isEmpty(openId)){
	        		 return getReturn(cookieprefix,2,"参数为空",chargeType,response);
	        	}
	        }
            PayOrder porder = new PayOrder();				
	        porder.setIp(ip);
	       
	        if(StringTools.isEmpty(actNo)){
	        	 porder.setActNo("niuxpaycenter");//默认的活动编号
	        }else{
	        	 porder.setActNo(actNo);
	        }
	        if("vipyy".equals(porder.getActNo().trim())){//vipyy活动有bug，特殊处理
	        	if("001".equals(priceNo)||"002".equals(priceNo)){
	        		return getReturn(cookieprefix,2,"参数错误",chargeType,response);
	        	}
	        }
	    
	        
			if(!checkChargeType(chargeType)){
				return getReturn(cookieprefix,3,"支付类型错误",chargeType,response);
			 }
			userAccount = getUserNameByUserId(uid+"");
            if(StringTools.isEmpty(userAccount)){
	  			return JsonObjectUtil.getRtnAndDataJsonObject(4,"该账号非迅雷账号");
            }
	      	if (StringTools.isNotEmpty(bankNo) && bankNo.equals("-1"))
				bankNo = "";
	          porder.setBankNo(bankNo);
	          porder.setBizNo(Constant.CHARGE_BIZI_NO);  
	          porder.setChargeType(chargeType);
	          porder.setPayBizNo(payBizNo);
	          porder.setAdvNo(advNo);
	          porder.setOrderType(new Integer(1));//默认订单类型为充值
	          porder.setTimeType(Integer.parseInt(timeType));
	          porder.setNumValue(Long.parseLong(numValue));
	          porder.setPayMoney(Double.parseDouble(money));
	          
			  Price price = getPrice(priceNo);
			  if(price == null){
				  return getReturn(cookieprefix,5,"该单价类型不存在",chargeType,response);
			  }
			 double basePrice = price.getPrice();//订单原有的单价
			 double payPrice = price.getPayPrice();//实际支付的单价
			 double paymoney = porder.getPayMoney();
			 int timetype = price.getTimeType();
			 if(porder.getNumValue()*payPrice != paymoney){//如果金额不满足条件
				 return getReturn(cookieprefix,6,"金额非法",chargeType,response);
			 }
			 porder.setOrderMoney(porder.getNumValue()*basePrice);

			 int mytimeType = porder.getTimeType().intValue();
			 if(mytimeType != 1&&mytimeType != 2&&mytimeType != 3){ //时间类型 1：日 2：月 3：年
				 return getReturn(cookieprefix,8,"时间类型错误",chargeType,response);
			 }
             if(timetype != mytimeType){
            	 return getReturn(cookieprefix,9,"时间类型与规定的不相符",chargeType,response);
             }
             String priceActNo = price.getActNo();
             if(!StringTools.isEmpty(priceActNo)){
            	 if(!actNo.equals(priceActNo)){
            		 return getReturn(cookieprefix,18,"该活动编号和该单价类型不对应",chargeType,response);
            	 }
             }
             String startTime = price.getStartTime();
             String endTime = price.getEndTime();
             String nowtime = DateUtil.getNowTime();
             if(!StringTools.isEmpty(startTime)){
            	 if( DateUtil.compareTime(startTime, nowtime)){
            		 return getReturn(cookieprefix,16,"该类型的单价还未开放使用",chargeType,response);
            	 }
             }
             if(!StringTools.isEmpty(endTime)){
            	 if( DateUtil.compareTime(nowtime, endTime)){
            		 return getReturn(cookieprefix,17,"该类型的单价已经过期",chargeType,response);
            	 }
             }
             if(price.getAmountFlag()){//如果限制了数量
            	 String amounts = price.getAmounts();
            	 if(amounts.indexOf(",")==-1){//如果只配置了一个数量
            		 long myamount = Long.parseLong(amounts.trim());
            		 if(porder.getNumValue().longValue()!=myamount){
            			 return getReturn(cookieprefix,19,"数量不对",chargeType,response);
            		 }
            	 }else{//如果配置了多个数量
            		 String myamounts[] = amounts.split(",");
            		 boolean limitFlag = true;
            		 for(String myamount :myamounts){
            			 if(StringTools.isEmpty(myamount))continue;
            			 if(porder.getNumValue().longValue()==Long.parseLong(myamount)){
            				 limitFlag = false;
            				 break;
            			 }
            		 }
            		 if(limitFlag){
            			 return getReturn(cookieprefix,19,"数量不对",chargeType,response);
            		 }
            	 }
             }
//             if("vippay".equals(porder.getActNo().trim())){
//            	 if(porder.getNumValue()!=1){
//            		 return getReturn(cookieprefix,6,"金额非法",chargeType,response);
//            	 }
//             }
             
             if(validBuQi(actNo)){//如果是补齐
 	        	//检查用户的过期时间
 	        	MemberShip query = new MemberShip();
 	        	query.setUserId(uid);
 	        	MemberShip ship = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
 	        	if(ship==null){
 	        		return getReturn(cookieprefix,2,"参数错误",chargeType,response);	        		
 	        	} 	        	
 	        	int months = getLeaveMonths(ship);//获得当前用户还有多少个月的会员
 	        	System.out.println("months:"+months+",paymoney/payPrice:"+paymoney/payPrice);
 	        	if(paymoney/payPrice!=12-months){//如果充值的月数跟实际需要的月数不相符
 	        		return getReturn(cookieprefix,12,"月数不对",chargeType,response);	       
 	        	}
 	        }
             
			 if(userAccount.indexOf("@")>0||userAccount.indexOf(":")>0){
					if(UserClient.getInstance().checkChildrenAccount(uid+"")){
						 return getReturn(cookieprefix,10,"子账号不能充值",chargeType,response);
					}
			  }
			 
			 //如果是雷点支付
			 String paypwdType = null;
			 String payPwd = null;
			 if (porder.getChargeType().equals(
					Constant.CHARGE_BY_ACCOUNT_PASSWD)) {
				paypwdType = StringUtil.filterInputWeak(request.getParameter("paypwdtype"));
				payPwd = StringUtil.filterInputWeak(request.getParameter("payPwd"));
				if (StringTools.isEmpty(paypwdType)
						|| StringTools.isEmpty(payPwd)) {
					return getReturn(cookieprefix,13,"支付密码不能为空",chargeType,response);
				}
			 }
			
			 
		    porder.setUserId(uid);
		    porder.setUserName(userAccount);
		    porder.setNoticeActivity(false);
		    porder.setExt1(ext1);
			// 保存订单信息，生成支付请求url
		    porder.setOrderId(getOrderId());//订单号
		    porder.setOrderTime(sdf.format(new Date()));//订单时间
		    porder.setOrderStatus(new Integer(1));//订单生成未支付 			  
		    FacadeFactory.INSTANCE.getPayOrderBo().insert(porder);
			   			  
			  //拼接请求链接
			  String chargeRequestUrl = getPayUrl(porder,copartnerId,Constant.PRODUCT_NAME,paypwdType,payPwd,openId);
			  logger.info("jinzuan pay.do addorder success uid="+uid+",userAccount="+userAccount+",order="+porder.getOrderId()+" ,url="+chargeRequestUrl);
			  
			   if(porder.getChargeType().equals(Constant.CHARGE_BY_ACCOUNT_PASSWD)
					  ||porder.getChargeType().equals(Constant.CHARGE_BY_WEIXIN_GZZH)){//如果是雷点支付 或 微信公众账号支付
				   ReturnData data = rechargeByAccount(porder.getChargeType(),porder.getOrderId(),chargeRequestUrl,request,response);
				   if(data.getCode()==0){
					   Map<String,Object> result = new HashMap<String,Object>();
					   result.put("orderId", data.getMsg());
					   result.put("appId", data.getAppId());
					   result.put("nonceStr", data.getNonceStr());
					   result.put("package", data.getPackpage());
					   result.put("paySign", data.getPaySign());
					   result.put("signType", data.getSignType());
					   result.put("timeStamp", data.getTimeStamp());
					   return JsonObjectUtil.getRtnAndDataJsonObject(data.getCode(),result);
				   }else{
					   return JsonObjectUtil.getRtnAndDataJsonObject(data.getCode(),data.getMsg());
				   }				 
			   }else{
				   //调用支付网关接口					
					 String orderIdCookieName = cookieprefix + "_orderId";// 订单号cookie前缀
					 CookieUtil.getInstance().addCookie(orderIdCookieName, porder.getOrderId(), response, null);
					  response.redirect(chargeRequestUrl);
					  Map<String,Object> result = new HashMap<String,Object>();
					  result.put("orderId", porder.getOrderId());
					  return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
			   }				 
		 }catch(SQLException e){
			 logger.info("jinzuan pay.do sqlerror uid="+uid+",userAccount="+userAccount+",reason="+e.getMessage());
             e.printStackTrace();
			 return getReturn(cookieprefix,12,"该订单已存在",chargeType,response);
		 }catch(Exception e){			
			 logger.info("jinzuan pay.do othererror uid="+uid+",userAccount="+userAccount+",reason="+e.getMessage());
			 e.printStackTrace();
			 return getReturn(cookieprefix,14,"网络异常",chargeType,response);
		 }				 		  
	}
	
	
	
	
	
	/**
	 * 金钻联合充值接口
	 * 比如 1个月金钻 + 1个月白金 会员捆绑
	 * @param request
	 * @param response
	 * @return
	 */
	@CmdMapper({"/jinzuan/unionpay.do"})
	public Object unionpay(XLHttpRequest request,XLHttpResponse response){
			long uid = 0L;
			String userAccount = null;		
			String ip = getIp(request);
 		 
//			//验证session
			MainParam mainParam=null;
			String chargeType = StringUtil.filterInputWeak(request.getParameter("chargeType"));	
			String cookieprefix = StringUtil.filterInputWeak(request.getParameter("cookieprefix"));
			try{
				 mainParam=this.getMainParam(request, response, true);
				 uid = mainParam.getUserid();
				 userAccount = mainParam.getUserAccount();
			}catch(Exception e){
				logger.error("ip["+ip+"]请求/jinzuan/pay.do的session验证失败", e);		
			}
			if(mainParam==null){
				return getReturn(cookieprefix,11,"session验证失败",chargeType,response);
			}
		    if(uid==0||StringTools.isEmpty(userAccount)){
		    	return getReturn(cookieprefix,11,"session验证失败",chargeType,response);
		    }
		 
		 String userid = request.getCookieValue("userid");
		 if(!userid.equals(uid+"")){
			 return getReturn(cookieprefix,15,"账号非法",chargeType,response);
		 }
		 try{			
		      String copartnerId =  StringUtil.filterInputWeak(request.getParameter("copartnerId"));	            
	          String bankNo = StringUtil.filterInputWeak(request.getParameter("bankNo"));	         
	          String payBizNo = StringUtil.filterInputWeak(request.getParameter("payBizNo"));	                  
	          String timeType = StringUtil.filterInputWeak(request.getParameter("timeType"));	          
	          String numValue = StringUtil.filterInputWeak(request.getParameter("numValue"));	//购买的月数或年数          
	          String money = StringUtil.filterInputWeak(request.getParameter("money"));
	          String priceNo = StringUtil.filterInputWeak(request.getParameter("priceNo"));
	          String advNo = StringUtil.filterInputWeak(request.getParameter("advNo"));//渠道编号
	          
	          if(StringTools.isEmpty(copartnerId)){
	        	  copartnerId = Constant.COPARTNER_XUNLEI;
	          }
	          String actNo = StringUtil.filterInputWeak(request.getParameter("actNo"));
	          String ext1 = StringUtil.filterInputWeak(request.getParameter("ext1"));
	          logger.info("jinzuan unionpay.do  uid="+userid+"&userAccount="+userAccount+"&copartnerId="+copartnerId+"&bankNo="+bankNo+"&payBizNo="+payBizNo+"&timeType="+timeType+"&numValue="+numValue+"&money="+money+"&priceNo="+priceNo+"&cookieprefix="+cookieprefix+"&actNo="+actNo+"&ext1="+ext1);
	          if( StringTools.isEmpty(userAccount)||
	        		  StringTools.isEmpty(copartnerId)||
	        		  StringTools.isEmpty(chargeType)||
	        		  StringTools.isEmpty(payBizNo)||
	        		  StringTools.isEmpty(timeType)||
	        		  StringTools.isEmpty(numValue)||
	        		  StringTools.isEmpty(priceNo)||
	        		  StringTools.isEmpty(cookieprefix)||
	        		  StringTools.isEmpty(money)){
	        	  return getReturn(cookieprefix,2,"参数为空",chargeType,response);
	         }
	        String openId = StringUtil.filterInputWeak(request.getParameter("openId"));
	        if(Constant.CHARGE_BY_WEIXIN_GZZH.equals(chargeType)){
	        	if(StringTools.isEmpty(openId)){
	        		 return getReturn(cookieprefix,2,"参数为空",chargeType,response);
	        	}
	        }
            PayOrder porder = new PayOrder();				
	        porder.setIp(ip);
	       
	        if(StringTools.isEmpty(actNo)){
	        	 porder.setActNo("niuxpaycenter");//默认的活动编号
	        }else{
	        	 porder.setActNo(actNo);
	        }
	        
			if(!checkChargeType(chargeType)){
				return getReturn(cookieprefix,3,"支付类型错误",chargeType,response);
			 }
			userAccount = getUserNameByUserId(uid+"");
            if(StringTools.isEmpty(userAccount)){
	  			return JsonObjectUtil.getRtnAndDataJsonObject(4,"该账号非迅雷账号");
            }
	      	if (StringTools.isNotEmpty(bankNo) && bankNo.equals("-1"))
				bankNo = "";
	          porder.setBankNo(bankNo);
	          porder.setBizNo(Constant.CHARGE_BIZI_NO);  
	          porder.setChargeType(chargeType);
	          porder.setPayBizNo(payBizNo);
	          porder.setAdvNo(advNo);
	          porder.setOrderType(new Integer(1));//默认订单类型为充值
	          porder.setTimeType(Integer.parseInt(timeType));
	          porder.setNumValue(Long.parseLong(numValue));
          
			  Price price = getPrice(priceNo);
			  if(price == null){
				  return getReturn(cookieprefix,5,"该单价类型不存在",chargeType,response);
			  }
			 double basePrice = price.getPrice();//订单应付金额
			 double payPrice = price.getPayPrice();//订单实收金额
			 int timetype = price.getTimeType();
			 if(porder.getNumValue()*basePrice != Double.parseDouble(money)){//如果金额不满足条件
				 return getReturn(cookieprefix,6,"金额非法",chargeType,response);
			 }
			 porder.setOrderMoney(porder.getNumValue()*basePrice);
			 porder.setPayMoney(porder.getNumValue()*payPrice);
			 
			 int mytimeType = porder.getTimeType().intValue();
			 if(mytimeType != 1&&mytimeType != 2&&mytimeType != 3){ //时间类型 1：日 2：月 3：年
				 return getReturn(cookieprefix,8,"时间类型错误",chargeType,response);
			 }
             if(timetype != mytimeType){
            	 return getReturn(cookieprefix,9,"时间类型与规定的不相符",chargeType,response);
             }
             String priceActNo = price.getActNo();
             if(!StringTools.isEmpty(priceActNo)){
            	 if(!actNo.equals(priceActNo)){
            		 return getReturn(cookieprefix,18,"该活动编号和该单价类型不对应",chargeType,response);
            	 }
             }
             String startTime = price.getStartTime();
             String endTime = price.getEndTime();
             String nowtime = DateUtil.getNowTime();
             if(!StringTools.isEmpty(startTime)){
            	 if( DateUtil.compareTime(startTime, nowtime)){
            		 return getReturn(cookieprefix,16,"该类型的单价还未开放使用",chargeType,response);
            	 }
             }
             if(!StringTools.isEmpty(endTime)){
            	 if( DateUtil.compareTime(nowtime, endTime)){
            		 return getReturn(cookieprefix,17,"该类型的单价已经过期",chargeType,response);
            	 }
             }
			 if(userAccount.indexOf("@")>0||userAccount.indexOf(":")>0){
					if(UserClient.getInstance().checkChildrenAccount(uid+"")){
						 return getReturn(cookieprefix,10,"子账号不能充值",chargeType,response);
					}
			  }
			 
			 //如果是雷点支付
			 String paypwdType = null;
			 String payPwd = null;
			 if (porder.getChargeType().equals(
					Constant.CHARGE_BY_ACCOUNT_PASSWD)) {
				paypwdType = StringUtil.filterInputWeak(request.getParameter("paypwdtype"));
				payPwd = StringUtil.filterInputWeak(request.getParameter("payPwd"));
				if (StringTools.isEmpty(paypwdType)
						|| StringTools.isEmpty(payPwd)) {
					return getReturn(cookieprefix,13,"支付密码不能为空",chargeType,response);
				}
			 }
			
			 
		    porder.setUserId(uid);
		    porder.setUserName(userAccount);
		    porder.setNoticeActivity(false);
		    porder.setExt1(ext1);
			// 保存订单信息，生成支付请求url
		    porder.setOrderId(getOrderId());//订单号
		    porder.setOrderTime(sdf.format(new Date()));//订单时间
		    porder.setOrderStatus(new Integer(1));//订单生成未支付 			  
		    FacadeFactory.INSTANCE.getPayOrderBo().insert(porder);
			   			  
			  //拼接请求链接
			  String chargeRequestUrl = getUnionPayUrl(porder,copartnerId,Constant.PRODUCT_NAME,paypwdType,payPwd,openId);
			  logger.info("jinzuan unionpay.do addorder success uid="+uid+",userAccount="+userAccount+",order="+porder.getOrderId()+" ,url="+chargeRequestUrl);
			  
			   if(porder.getChargeType().equals(Constant.CHARGE_BY_ACCOUNT_PASSWD)
					  ||porder.getChargeType().equals(Constant.CHARGE_BY_WEIXIN_GZZH)){//如果是雷点支付 或 微信公众账号支付
				   ReturnData data = rechargeByAccount(porder.getChargeType(),porder.getOrderId(),chargeRequestUrl,request,response);
				   if(data.getCode()==0){
					   Map<String,Object> result = new HashMap<String,Object>();
					   result.put("orderId", data.getMsg());
					   result.put("appId", data.getAppId());
					   result.put("nonceStr", data.getNonceStr());
					   result.put("package", data.getPackpage());
					   result.put("paySign", data.getPaySign());
					   result.put("signType", data.getSignType());
					   result.put("timeStamp", data.getTimeStamp());
					   return JsonObjectUtil.getRtnAndDataJsonObject(data.getCode(),result);
				   }else{
					   return JsonObjectUtil.getRtnAndDataJsonObject(data.getCode(),data.getMsg());
				   }				 
			   }else{
				   //调用支付网关接口					
					 String orderIdCookieName = cookieprefix + "_orderId";// 订单号cookie前缀
					 CookieUtil.getInstance().addCookie(orderIdCookieName, porder.getOrderId(), response, null);
					  response.redirect(chargeRequestUrl);
					  Map<String,Object> result = new HashMap<String,Object>();
					  result.put("orderId", porder.getOrderId());
					  return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
			   }				 
		 }catch(SQLException e){
			 logger.info("jinzuan unionpay.do sqlerror uid="+uid+",userAccount="+userAccount+",reason="+e.getMessage());
             e.printStackTrace();
			 return getReturn(cookieprefix,12,"该订单已存在",chargeType,response);
		 }catch(Exception e){			
			 logger.info("jinzuan unionpay.do othererror uid="+uid+",userAccount="+userAccount+",reason="+e.getMessage());
			 e.printStackTrace();
			 return getReturn(cookieprefix,14,"网络异常",chargeType,response);
		 }				 		  
	}
	
	
	private String getDocNodeText(Document doc,String nodeName){
		try{
			String nodeText="";
			Iterator it3 = doc.selectNodes(nodeName).iterator();
			if (it3.hasNext()) {
				Element element = (Element) it3.next();
				nodeText = element.getText();
			}
			return nodeText;
		}catch(Exception e){
			return "";
		}
	}
	
	
	private boolean rechargeNoticeWeiXi(String orderId,String payRequestUrl) {
		String errcode = "";
		boolean isSuccess = false;
		try {
			String chargeCode = "";
			SAXReader reader = new SAXReader();
			Document doc = reader.read(new URL(payRequestUrl).openStream());
			Iterator it = doc.selectNodes("/pay/payresult").iterator();
			if (it.hasNext()) {
				Element element = (Element) it.next();
				chargeCode = element.getText();
			}
			logger.info("notice weixi orderid=" + orderId + " ,chargeCode=" + chargeCode);		
			if (chargeCode.equals("00")){// 成功
				isSuccess = true;
				errcode = Constant.SUCCESS;
			} else if (chargeCode.equals("10"))// 错误
			{
				Iterator it2 = doc.selectNodes("/pay/errcode").iterator();
				if (it2.hasNext()) {
					Element element = (Element) it2.next();
					errcode = element.getText();
				}
				logger.error("notice weixi orderid=" + orderId + " ,errcode=" + errcode);			
			}
		} catch (Exception e) {		
			logger.error("notice weixi error,orderid="+orderId+",reason=" + e);
		}
		return isSuccess;
	}
	
	
	
	
	private ReturnData rechargeByAccount(String chargeType,String orderId,
			String payRequestUrl, XLHttpRequest request,
			XLHttpResponse response) {
		String errcode = "";
		ReturnData data = new ReturnData();
		try {
			String chargeCode = "";
			SAXReader reader = new SAXReader();
			Document doc = reader.read(new URL(payRequestUrl).openStream());
			Iterator it = doc.selectNodes("/pay/payresult").iterator();
			if (it.hasNext()) {
				Element element = (Element) it.next();
				chargeCode = element.getText();
			}
			logger.info("orderid=" + orderId + " ,chargeCode=" + chargeCode);		
			if (chargeCode.equals("00")){// 成功
				data.setCode(0);
				if(chargeType.equals(Constant.CHARGE_BY_WEIXIN_GZZH)){//如果是微信公众账号支付
					String appId=getDocNodeText(doc,"/pay/appId");
					String timeStamp=getDocNodeText(doc,"/pay/timeStamp");
					String nonceStr=getDocNodeText(doc,"/pay/nonceStr");
					String packpage=getDocNodeText(doc,"/pay/package");
					String signType=getDocNodeText(doc,"/pay/signType");
					String paySign=getDocNodeText(doc,"/pay/paySign");
					data.setMsg(orderId);
					data.setAppId(appId);
					data.setTimeStamp(timeStamp);
					data.setNonceStr(nonceStr);
					data.setSignType(signType);
					data.setPaySign(paySign);
					data.setPackpage(packpage);
				}else{
					data.setMsg(orderId);
				}				
				String ext=getDocNodeText(doc,"/pay/ext");
				errcode = Constant.SUCCESS;
			} else if (chargeCode.equals("10"))// 错误
			{
				Iterator it2 = doc.selectNodes("/pay/errcode").iterator();
				if (it2.hasNext()) {
					Element element = (Element) it2.next();
					errcode = element.getText();
				}
				logger.error("orderid=" + orderId + " ,errcode=" + errcode);
				// 返回json对象
				if (errcode.equals(Constant.ERROR_SIGN)) {
					data.setCode(-10);
					data.setMsg("签名错误");				
				} else if (errcode.equals(Constant.ERROR_EXIST_ORDERID)) {
					data.setCode(-11);
					data.setMsg("订单已经存在");						
				} else if (errcode.equals(Constant.ERROR_PARAM)) {
					data.setCode(-12);
					data.setMsg("订单参数值不符合");			
				} else if (errcode.equals(Constant.ERROR_COPBIZ)) {
					data.setCode(-13);
					data.setMsg("无效商户号");	
				} else if (errcode.equals(Constant.ERROR_CONSUME_LEIDIAN)
						|| errcode.equals(Constant.ERROR_NOT_POINT_USER)) {
					data.setCode(-14);
					data.setMsg("帐户余额不足");	
				} else if (errcode.equals(Constant.ERROR_USERID)) {
					data.setCode(-15);
					data.setMsg("迅雷帐户不存在");	
				}else if ("1001".equals(errcode)) {
					data.setCode(-21);
					data.setMsg("支付密码错误");		
				} else {
					data.setCode(-16);
					data.setMsg("帐户支付发生错误");		
				}
			}
		} catch (Exception e) {
			data.setCode(-16);
			data.setMsg("帐户支付发生错误");		
			logger.error("account pay error,orderid="+orderId+",reason=" + e);
		}
		return data;
	}
	
	
	/**
	 * 获得返回值
	 * @param chargeType
	 * @param code
	 * @param msg
	 * @return
	 */
	private Object getReturn(String chargeType,String code,String msg){
		    PayResponse payResponse=new PayResponse();
			payResponse.setCode(code);
			payResponse.setMsg(msg);
			return getReturn(payResponse,chargeType);
	}
	
	private  Object getReturn( PayResponse payResponse ,String chargeType){		
   	    if(Constant.CHARGE_BY_WANGYIN.equals(chargeType)){//如果是网银支付
   	    	return "<script type='text/javascript'>alert(\""+payResponse.getMsg()+"\");window.close();</script>";
		}else if(Constant.CHARGE_BY_ACCOUNT_PASSWD.equals(chargeType)){//如果是雷点支付
           return JsonObjectUtil.getRtnAndDataJsonObject(Integer.parseInt(payResponse.getCode()),payResponse.getMsg());
		}else {//如果是支付宝支付
			return "<script type='text/javascript'>alert(\""+payResponse.getMsg()+"\");window.close();</script>";
		}	
	}
	
	
   	 private  Object getReturn(String cookieprefix,int code,String msg ,String chargeType,XLHttpResponse response){		
   		if(StringTools.isEmpty(chargeType)){
   			return JsonObjectUtil.getRtnAndDataJsonObject(2,"参数为空");
   		}
    	if(Constant.CHARGE_BY_WANGYIN.equals(chargeType)){//如果是网银支付
    		addCookie(cookieprefix,code,msg,response);
    		response.setInnerContentType(XLHttpResponse.ContentType.html);
    	    return "<script type='text/javascript'>alert(\""+msg+"\");window.close();</script>";
 		}else if(Constant.CHARGE_BY_ACCOUNT_PASSWD.equals(chargeType)||Constant.CHARGE_BY_WEIXIN_GZZH.equals(chargeType)){//如果是雷点支付或微信公众账号支付
            return JsonObjectUtil.getRtnAndDataJsonObject(code,msg);
 		}else {//如果是支付宝支付 、百度钱包
 			addCookie(cookieprefix,code,msg,response);
 			response.setInnerContentType(XLHttpResponse.ContentType.html);
 			return "<script type='text/javascript'>alert(\""+msg+"\");window.close();</script>";
 		}	
    }
   	 
   	 private void addCookie(String cookieprefix,int code,String msg,XLHttpResponse response){  		
   		String orderIdCookieName = cookieprefix + "_orderId";// 订单号cookie前缀
		try {
			CookieUtil.getInstance().addCookie(orderIdCookieName, "error_"+code+"_"+(URLEncoder.encode(msg, "utf8")), response, null);
		} catch (UnsupportedEncodingException e) {
			logger.info("add cookie error,code:"+code+",msg:"+msg);
		}  
   	 }
	
	/**
	 * 判断价格编号是否存在
	 * @param priceNo
	 * @return
	 */
	private Price getPrice(String priceNo){
		Price query = new Price();
		query.setPriceNo(priceNo);
		query.setFlag(true);//有效的
		return FacadeFactory.INSTANCE.getBaseSo().findObject(query);
	}
	
	
	/**
	 * 判断支付类型是否满足条件
	 * @param chargeType
	 * @return
	 */
	private boolean checkChargeType(String chargeType){		
		List<String> chargeList = GoodsInfoUtil.getInstance().getChargeList();
		for(String charge:chargeList){
		    if(chargeType.trim().equals(charge)){
		    	return true;
		    }
		}
		return false;
	}
	
	
	/**
	 * 拼接请求地址，请求支付网关
	 * @param payOrder
	 * @return
	 */
	private String getPayUrl(PayOrder payOrder,String copartnerid,String productName,String paypwdType,String payPwd,String openId) throws Exception{
		String payerName = payOrder.getUserName();
		Map<String, String> params = new HashMap<String, String>();
		params.put("version", "v1.0");
		params.put("pageCharset", "1");
		if(StringTools.isEmpty(payOrder.getActNo())||"niuxpaycenter".equals(payOrder.getActNo())){//如果是支付中心
			params.put("bgUrl",callBackUrl);
		}else{
			params.put("bgUrl",actCallBackUrl);//如果是活动页
		}		
		params.put("fgUrl", "http://vip.niu.xunlei.com");
		params.put("bizNo", Constant.CHARGE_BIZI_NO);// 
		params.put("orderId", payOrder.getOrderId());
		params.put("orderAmt", new Double(payOrder.getPayMoney()*100).intValue()+"");
		String uid = payOrder.getUserId()+"";
		
		//如果是测试账号只扣一分钱
		checkTestAccount(params,uid);
		
		params.put("orderTime",orderTimeDf.format(sdf.parse(payOrder.getOrderTime())));
		params.put("payType", payOrder.getChargeType());
		params.put("xunleiId", payerName);
		params.put("xlnumId", payOrder.getUserId()+"");
		params.put("productName", productName);
		params.put("productDesc", productName);
		if (StringTools.isNotEmpty(payOrder.getBankNo()))
			params.put("bankNo", payOrder.getBankNo());
		params.put("payerName", payerName);
		params.put("ext1", "");
		params.put("ext2", payOrder.getPayBizNo());
		if (payOrder.getChargeType().equals(
				Constant.CHARGE_BY_ACCOUNT_PASSWD)) {//雷点支付
			params.put("other1", payPwd);
		}
		if (payOrder.getChargeType().equals(
				Constant.CHARGE_BY_WEIXIN_GZZH)) {//微信公众账号支付
			params.put("other2", openId);
			params.put("other3", APPID);
		}
		if(payOrder.getChargeType().equals(
				Constant.CHARGE_BY_BAIDU_QB)
				&&payOrder.getActNo().equals("vippay")){//百度钱包1分钱支付
			params.put("other2", "activity");
		}
		String signMsg = SignUtil.sign(params, chargekey.trim());
		String requestUrl = payUrl + "?"
				+ SignUtil.getSignatureContent(params, "utf-8")
				+ "&signMsg=" + signMsg;
		if(payOrder.getIp()!=null){
			requestUrl=requestUrl+"&clientIp="+payOrder.getIp();
		}
//		if (payOrder.getChargeType().equals(
//				Constant.CHARGE_BY_WEIXIN_GZZH)) {//微信公众账号支付
//			requestUrl=requestUrl+"&other3="+APPID;
//		}
		if (payOrder.getChargeType().equals(
				Constant.CHARGE_BY_ACCOUNT_PASSWD)) {//雷点支付
			requestUrl = requestUrl + "&paypwdType=" + paypwdType + "&payPwd="
					+ payPwd;
		}
		return requestUrl;
	}
	
	
	private String getUnionPayUrl(PayOrder payOrder,String copartnerid,String productName,String paypwdType,String payPwd,String openId) throws Exception{
		String payerName = payOrder.getUserName();
		Map<String, String> params = new HashMap<String, String>();
		params.put("version", "v1.0");
		params.put("pageCharset", "1");
		if(StringTools.isEmpty(payOrder.getActNo())||"niuxpaycenter".equals(payOrder.getActNo())){//如果是支付中心
			params.put("bgUrl",callBackUrl);
		}else{
			params.put("bgUrl",unionCallBackUrl);//如果是活动页
		}		
		params.put("fgUrl", "http://vip.niu.xunlei.com");
		params.put("bizNo",unionbizno);//组合支付业务编号 
		params.put("orderId", payOrder.getOrderId());
		params.put("orderAmt", new Double(payOrder.getOrderMoney()*100).intValue()+"");
		String uid = payOrder.getUserId()+"";
		
		//如果是测试账号只扣一分钱
		checkTestAccount(params,uid);
		
		params.put("orderTime",orderTimeDf.format(sdf.parse(payOrder.getOrderTime())));
		params.put("payType", payOrder.getChargeType());
		params.put("xunleiId", payerName);
		params.put("xlnumId", payOrder.getUserId()+"");
		params.put("productName", productName);
		params.put("productDesc", productName);
		if (StringTools.isNotEmpty(payOrder.getBankNo()))
			params.put("bankNo", payOrder.getBankNo());
		params.put("payerName", payerName);
		params.put("ext1", "");
		params.put("ext2", payOrder.getPayBizNo());
		if (payOrder.getChargeType().equals(
				Constant.CHARGE_BY_ACCOUNT_PASSWD)) {//雷点支付
			params.put("other1", payPwd);
		}
		String signMsg = SignUtil.sign(params, unionchargekey.trim());
		String requestUrl = payUrl + "?"
				+ SignUtil.getSignatureContent(params, "utf-8")
				+ "&signMsg=" + signMsg;
		if(payOrder.getIp()!=null){
			requestUrl=requestUrl+"&clientIp="+payOrder.getIp();
		}
		if (payOrder.getChargeType().equals(
				Constant.CHARGE_BY_ACCOUNT_PASSWD)) {//雷点支付
			requestUrl = requestUrl + "&paypwdType=" + paypwdType + "&payPwd="
					+ payPwd;
		}
		return requestUrl;
	}
	
	
	private String getNoticeWeiXiUrl(PayOrder payOrder) throws Exception{
		Map<String, String> params = new HashMap<String, String>();
		params.put("orderId", payOrder.getOrderId());
		params.put("deliverStatus", "1");
		params.put("deliverMsg", "");
		params.put("bizNo",Constant.CHARGE_BIZI_NO);//业务编号 
		String signMsg = SignUtil.sign(params, testchargekey.trim());
		String requestUrl = noticeWeiXiUrl + "?"
				+ SignUtil.getSignatureContent(params, "utf-8")
				+ "&signMsg=" + signMsg;
		return requestUrl;
	}
	
	
	private void checkTestAccount(Map<String, String> params,String uid){
		if(testAccount.indexOf(",")==-1){
			if(testAccount.trim().equals(uid)){
				params.put("orderAmt", "1");
			}
		}else{
			String accounts [] = testAccount.split(",");
			for(String account:accounts){
				if(StringTools.isEmpty(account))continue;
				if(account.trim().equals(uid)){
					params.put("orderAmt", "1");
					break;
				}
			}
		}
	}
	
	public String getChargeParameter(XLHttpRequest req, String name) {
		String val = req.getParameter(name);
		if (val != null) {
			try {
				String valchs = new String(val.getBytes("latin1"), "utf-8");
				return StringUtil.filterInputWeak(valchs);
			} catch (Exception ex) {
				return "";
			}
		}
		return "";
	}
	
	/**
	 * 充值之后回调此接口，更新订单状态
	 * @param request
	 * @param response
	 * @return
	 */
	@CmdMapper({"/jinzuan/back.do"})
	public Object callBack(XLHttpRequest request, XLHttpResponse response){		
		String version = getChargeParameter(request,"version");
		String orderId = getChargeParameter(request,"orderId");
		String orderAmt = getChargeParameter(request,"orderAmt");
		String orderTime = getChargeParameter(request,"orderTime");
		String xlpayId = getChargeParameter(request,"xlpayId");
		String xlpayTime = getChargeParameter(request,"xlpayTime");
		String gameid = getChargeParameter(request,"ext1");
		String paybizno = getChargeParameter(request,"ext2");
		String payResult = getChargeParameter(request,"payResult");
		String signMsg = getChargeParameter(request,"signMsg");
		response.setInnerContentType(XLHttpResponse.ContentType.plain);
		String result = "N";
		try {
			if (!"00".equals(payResult)) {
				return JsonObjectUtil.getRtnAndDataJsonObject(1, "支付未成功");
			}
			Map<String, String> params = new HashMap<String, String>();
			params.put("version", version);
			params.put("orderId", orderId);
			params.put("orderAmt", orderAmt);
			params.put("orderTime", orderTime);
			params.put("xlpayId", xlpayId);
			params.put("xlpayTime", xlpayTime);
			params.put("ext1", gameid);
			params.put("ext2", paybizno);
			params.put("payResult", payResult);
			params.put("signMsg", signMsg);
			
			logger.info("jinzuan payback.do orderid="+orderId+", params="+params);
			System.out.println("back params:"+params);
			if (!SignUtil.checkSign(params, chargekey)) {
				throw new Exception("数据校验不正确");
			}
        	 	 
    	     if(!StringTools.isEmpty(orderId)){
    	    	 PayOrder order = new PayOrder();
    	    	 order.setOrderId(orderId);
    	    	 BaseSo baseSo = FacadeFactory.INSTANCE.getBaseSo();
    	    	 List<PayOrder> polist =baseSo .findObjects(order, new Page());
    	    	 if(polist != null&&polist.size()>0){
    	    		 PayOrder porder = polist.get(0);
    	    		 if(porder.getOrderStatus().intValue()==3){//如果该订单已经成功
    	    			 throw new Exception("该充值订单已经回调过");
    	    		 }
    	    		  if(validBuQi(porder.getActNo())){
    	        		  FacadeFactory.INSTANCE.getPayOrderBo().addPayOrder(porder,true,true);  
    	    		  }else{
    	        		  FacadeFactory.INSTANCE.getPayOrderBo().addPayOrder(porder,true,false);  
    	    		  }  			        	    		     	    		 
    	    		  
    	    		  if(porder.getChargeType().equals(Constant.CHARGE_BY_WEIXIN_GZZH)){
    	    			  //如果是微信支付，调用发货接口
        	    		 boolean flag =  noticeWeiXi(porder);
        	    		 if(flag){
        	    			 result = "Y";
        	    		 }
    	    		  }else{
    	    			  result = "Y";
    	    		  }    	    		    	    		  
    	    		  
    	    	 }        	    	 
    	     }    	    
    	     logger.info("jinzuan payback.do success orderId="+orderId);
        }catch(Exception e){
        	logger.info("jinzuan back.do error orderId="+orderId+",reason="+e.getMessage());       
        	return "<xlresult>" + result + "</xlresult>";
        }
        return "<xlresult>" + result + "</xlresult>";
	}
	
	
	public boolean validBuQi(String actno){
		if(StringTools.isEmpty(buQiActNos)) return true;
		 if(buQiActNos.indexOf(",") ==-1){
        	if(buQiActNos.trim().equals(actno))return true;
         }else{
        	 String strs[] = buQiActNos.split(",");
        	 for(String str:strs){
        		 System.out.println(str);
        		 if(str.trim().equals(actno))return true;
        	 }
         }
		 return false;
	}
	
	
	/**
	 * 活动页充值之后回调此接口，更新订单状态
	 * @param request
	 * @param response
	 * @return
	 */
	@CmdMapper({"/jinzuan/actback.do"})
	public Object actCallBack(XLHttpRequest request, XLHttpResponse response){		
		String version = getChargeParameter(request,"version");
		String orderId = getChargeParameter(request,"orderId");
		String orderAmt = getChargeParameter(request,"orderAmt");
		String orderTime = getChargeParameter(request,"orderTime");
		String xlpayId = getChargeParameter(request,"xlpayId");
		String xlpayTime = getChargeParameter(request,"xlpayTime");
		String gameid = getChargeParameter(request,"ext1");
		String paybizno = getChargeParameter(request,"ext2");
		String payResult = getChargeParameter(request,"payResult");
		String signMsg = getChargeParameter(request,"signMsg");
		response.setInnerContentType(XLHttpResponse.ContentType.plain);
		String result = "N";
		try {
			if (!"00".equals(payResult)) {
				return JsonObjectUtil.getRtnAndDataJsonObject(1, "支付未成功");
			}
			Map<String, String> params = new HashMap<String, String>();
			params.put("version", version);
			params.put("orderId", orderId);
			params.put("orderAmt", orderAmt);
			params.put("orderTime", orderTime);
			params.put("xlpayId", xlpayId);
			params.put("xlpayTime", xlpayTime);
			params.put("ext1", gameid);
			params.put("ext2", paybizno);
			params.put("payResult", payResult);
			params.put("signMsg", signMsg);
			
			logger.info("jinzuan payback.do orderid="+orderId+", params="+params);
			System.out.println("back params:"+params);
			if (!SignUtil.checkSign(params, chargekey)) {
				throw new Exception("数据校验不正确");
			}
        	 	 
    	     if(!StringTools.isEmpty(orderId)){
    	    	 PayOrder order = new PayOrder();
    	    	 order.setOrderId(orderId);
    	    	 BaseSo baseSo = FacadeFactory.INSTANCE.getBaseSo();
    	    	 List<PayOrder> polist =baseSo .findObjects(order, new Page());
    	    	 if(polist != null&&polist.size()>0){
    	    		 PayOrder porder = polist.get(0);
    	    		 if(porder.getNoticeActivity()){//如果该订单已经成功
    	    			 throw new Exception("该充值订单已经回调过");
    	    		 }
    	    		  if(validBuQi(porder.getActNo())){
    	    			  FacadeFactory.INSTANCE.getPayOrderBo().addPayOrder(porder,true,true);  	
    	    		  }else{
    	    			  FacadeFactory.INSTANCE.getPayOrderBo().addPayOrder(porder,true,false);  	
    	    		  }    	    	        	    		 
    	    		  result = "Y";
    	    		  logger.info("ActivityProxy  start..............,orderid:"+orderId);
    	    		  //处理活动页的逻辑
    	    		  ActivityProxy.getInstance().notice(porder);
    	    		  logger.info("ActivityProxy  end.............,orderid:"+orderId);
    	    		  //通知积分商城增加积分
    	    		  JiFenShopProxy.getInstance().addJiFen(porder);
    	    		  logger.info("JiFenShopProxy  end..............,orderid:"+orderId);
    	    		  
    	    		  if(porder.getChargeType().equals(Constant.CHARGE_BY_WEIXIN_GZZH)){
    	    			  //如果是微信支付，调用发货接口
        	    		 boolean flag =  noticeWeiXi(porder);
        	    		 if(flag){
        	    			 result = "Y";
        	    		 }
    	    		  }else{
    	    			  result = "Y";
    	    		  }   
    	    	 }        	    	 
    	     }    	    
    	     logger.info("jinzuan actback.do success orderId="+orderId);
        }catch(Exception e){
        	e.printStackTrace();
        	logger.info("jinzuan actback.do error orderId="+orderId+",reason="+e.getMessage());       
        	return "<xlresult>" + result + "</xlresult>";
        }
        return "<xlresult>" + result + "</xlresult>";
	}
	
	
	private boolean noticeWeiXi(PayOrder porder) throws Exception{
			String url = getNoticeWeiXiUrl(porder);
			logger.info("notice weixi orderid=" + porder.getOrderId() + " ,url=" + url);
		   return rechargeNoticeWeiXi(porder.getOrderId(),url);
	}
	
	
	/**
	 * 活动页充值之后回调此接口，更新订单状态
	 * @param request
	 * @param response
	 * @return
	 */
	@CmdMapper({"/jinzuan/unionback.do"})
	public Object unionCallBack(XLHttpRequest request, XLHttpResponse response){		
		String version = getChargeParameter(request,"version");
		String orderId = getChargeParameter(request,"orderId");
		String orderAmt = getChargeParameter(request,"orderAmt");
		String orderTime = getChargeParameter(request,"orderTime");
		String xlpayId = getChargeParameter(request,"xlpayId");
		String xlpayTime = getChargeParameter(request,"xlpayTime");
		String gameid = getChargeParameter(request,"ext1");
		String paybizno = getChargeParameter(request,"ext2");
		String payResult = getChargeParameter(request,"payResult");
		String signMsg = getChargeParameter(request,"signMsg");
		response.setInnerContentType(XLHttpResponse.ContentType.plain);
		String result = "N";
		try {
			if (!"00".equals(payResult)) {
				return JsonObjectUtil.getRtnAndDataJsonObject(1, "支付未成功");
			}
			Map<String, String> params = new HashMap<String, String>();
			params.put("version", version);
			params.put("orderId", orderId);
			params.put("orderAmt", orderAmt);
			params.put("orderTime", orderTime);
			params.put("xlpayId", xlpayId);
			params.put("xlpayTime", xlpayTime);
			params.put("ext1", gameid);
			params.put("ext2", paybizno);
			params.put("payResult", payResult);
			params.put("signMsg", signMsg);
			
			logger.info("jinzuan unionback.do orderid="+orderId+", params="+params);
			System.out.println("back params:"+params);
			if (!SignUtil.checkSign(params, unionchargekey)) {
				throw new Exception("数据校验不正确");
			}
        	 	 
    	     if(!StringTools.isEmpty(orderId)){
    	    	 PayOrder order = new PayOrder();
    	    	 order.setOrderId(orderId);
    	    	 BaseSo baseSo = FacadeFactory.INSTANCE.getBaseSo();
    	    	 List<PayOrder> polist =baseSo .findObjects(order, new Page());
    	    	 if(polist != null&&polist.size()>0){
    	    		 PayOrder porder = polist.get(0);
    	    		 if(porder.getNoticeActivity()){//如果该订单已经成功
    	    			 throw new Exception("该充值订单已经回调过");
    	    		 }
    	    		  if(validBuQi(porder.getActNo())){
    	    			  FacadeFactory.INSTANCE.getPayOrderBo().addPayOrder(porder,true,true);  	
    	    		  }else{
    	    			  FacadeFactory.INSTANCE.getPayOrderBo().addPayOrder(porder,true,false);  	
    	    		  }
    	    			        	    		 
    	    		  result = "Y";
    	    		  logger.info("ActivityProxy  start..............,orderid:"+orderId);
    	    		  //处理活动页的逻辑
    	    		  ActivityProxy.getInstance().notice(porder);
    	    		  logger.info("ActivityProxy  end.............,orderid:"+orderId);
    	    	 }        	    	 
    	     }    	    
    	     logger.info("jinzuan unionback.do success orderId="+orderId);
        }catch(Exception e){
        	e.printStackTrace();
        	logger.info("jinzuan unionback.do error orderId="+orderId+",reason="+e.getMessage());       
        	return "<xlresult>" + result + "</xlresult>";
        }
        return "<xlresult>" + result + "</xlresult>";
	}
	
	
	/**
	 * 金钻退订接口
	 * @param request
	 * @param response
	 * @return
	 */
	@CmdMapper({"/jinzuan/cancel.do"})
	public Object doCancel(XLHttpRequest request, XLHttpResponse response){	
		 response.setInnerContentType(XLHttpResponse.ContentType.plain);
		 String orderid = request.getParameter("orderid");//订单号
		 String uid = request.getParameter("uid");//
		 String timestamp = request.getParameter("timestamp");
		 String sign = request.getParameter("sign");
		 try{
			 String ip = request.getRemoteIP();
			 if(!ValidIPProxy.getInstance().isValidIp(ip,2)){
				 return JsonObjectUtil.getRtnAndDataJsonObject(8, "无效ip");
			 }
			 if(StringTools.isEmpty(orderid)||
					 StringTools.isEmpty(uid)||
					 StringTools.isEmpty(timestamp)||
					 StringTools.isEmpty(sign)){
				 return JsonObjectUtil.getRtnAndDataJsonObject(1, "参数为空");
			 }
			 long time = Long.parseLong(timestamp);
			 long mytime = System.currentTimeMillis()/1000;
			 if(mytime - time > 15*60){
				 return JsonObjectUtil.getRtnAndDataJsonObject(4, "请求超时");
			 }
			 String mysgin = Md5Encrypt.md5(uid+orderid+time+cancelkey);
			 if(!sign.trim().equals(mysgin)){
				 return JsonObjectUtil.getRtnAndDataJsonObject(5, "签名错误");
			 }
			 logger.info("jinzuan cancel.do uid="+uid+",orderid="+orderid+",timestamp="+timestamp+",sign="+sign);
			 FacadeFactory.INSTANCE.getPayOrderBo().cancelOrder(orderid, Long.parseLong(uid));
			 logger.info("jinzuan cancel.do success uid="+uid+",orderid="+orderid+",timestamp="+timestamp+",sign="+sign);
			 return JsonObjectUtil.getOnlyOkJson();
		 } catch(XLRuntimeException ee){
			 ee.printStackTrace();
			 return JsonObjectUtil.getRtnAndDataJsonObject(2, ee.getMessage());
		 }catch(Exception e){
			 e.printStackTrace();
			 return JsonObjectUtil.getRtnAndDataJsonObject(3, "服务器异常");
		 }
	}
	
	
	/**
	 * 金钻会员赠送接口
	 * @param request
	 * @param response
	 * @return
	 */
	@CmdMapper({"/jinzuan/present.do"})
	public Object doPresent(XLHttpRequest request, XLHttpResponse response){	
		String uid = request.getParameter("uid");
		String timeType = request.getParameter("timeType");//时间类型
		String numValue = request.getParameter("numValue");//对应时间的数量
		String orderid = request.getParameter("orderid");//订单号
		String bizNo = request.getParameter("bizNo");//业务编号
		String actno = request.getParameter("actno");//活动编号
		String timestamp = request.getParameter("timestamp");
		String sign = request.getParameter("sign");
		try{
			 String ip = request.getRemoteIP();
			 response.setInnerContentType(XLHttpResponse.ContentType.plain);
			 if(!ValidIPProxy.getInstance().isValidIp(ip,2)){
				 return JsonObjectUtil.getRtnAndDataJsonObject(8, "无效ip");
			 }
			 logger.info("jinzuan present.do uid="+uid+",orderid="+orderid+",timeType="+timeType+",numValue="+numValue+",timestamp="+timestamp+",bizNo="+bizNo+",sign="+sign);
			 if(StringTools.isEmpty(uid)||
				StringTools.isEmpty(orderid)||
				StringTools.isEmpty(timeType)||
				StringTools.isEmpty(numValue)||
				StringTools.isEmpty(actno)||
				StringTools.isEmpty(timestamp)||
				StringTools.isEmpty(sign)||
				StringTools.isEmpty(bizNo)){
				 return JsonObjectUtil.getRtnAndDataJsonObject(1, "参数错误");
			 }			 
			 if(orderid.length()>30){
				 return JsonObjectUtil.getRtnAndDataJsonObject(10, "订单号过长");
			 }
			 logger.info("jinzuan present.do uid="+uid+",orderid="+orderid+",timeType="+timeType+",numValue="+numValue+",timestamp="+timestamp+",bizNo="+bizNo+",sign="+sign);
			 long time = Long.parseLong(timestamp);
			 long mytime = System.currentTimeMillis()/1000;
			 if(mytime - time > 15*60){
				 return JsonObjectUtil.getRtnAndDataJsonObject(4, "请求超时");
			 }
			 PrivateKey privateKeyquery = new PrivateKey();
			 privateKeyquery.setBizNo(bizNo.trim());
			 PrivateKey privateKey = FacadeFactory.INSTANCE.getBaseSo().findObject(privateKeyquery);
			 if(privateKey == null){
				 return JsonObjectUtil.getRtnAndDataJsonObject(9, "业务编号不存在");
			 }
				 
			 String mysgin = Md5Encrypt.md5(uid+orderid+timeType+numValue+bizNo+time+privateKey.getPrivateKey());
			 if(!sign.trim().equals(mysgin)){
				 return JsonObjectUtil.getRtnAndDataJsonObject(5, "签名错误");
			 }
//			 int timetype = Integer.parseInt(timeType);
//			 if(timetype!=1){
//				 return JsonObjectUtil.getRtnAndDataJsonObject(2, "时间类型错误，目前只支持按天赠送会员");
//			 }
			 long num = Long.parseLong(numValue);
			 if(num <= 0){
				 return JsonObjectUtil.getRtnAndDataJsonObject(3, "开通天数必须大于零");
			 }
//			 if(num> Long.parseLong(MAXNUM)){
//				 return JsonObjectUtil.getRtnAndDataJsonObject(7, "赠送会员最多支持一次赠送"+MAXNUM+"天");
//			 }
		   String nowtime = DateUtil.getNowTime();
		   if(DateUtil.compareTime(privateKey.getStartTime(), nowtime)){//如果还没有开始
			   return JsonObjectUtil.getRtnAndDataJsonObject(11, "该赠送接口密钥未开放使用");
		   }
		   if(DateUtil.compareTime(nowtime,privateKey.getEndTime())){//如果已经过期了
			   return JsonObjectUtil.getRtnAndDataJsonObject(12, "该赠送接口密钥已经过期");
		   }
		 	
		   PayOrder query = new PayOrder(); 
		   query.setOrderId(orderid);
		   PayOrder myPayOrder =  FacadeFactory.INSTANCE.getBaseSo().findObject(query);
		   if(myPayOrder != null){
			   return JsonObjectUtil.getRtnAndDataJsonObject(8, "该订单号已存在");
		   }
		   PayOrder porder = new PayOrder();
		   porder.setBankNo("");
           porder.setBizNo(bizNo);  
           porder.setChargeType("A1");
           porder.setPayBizNo("0");
           if(!StringTools.isEmpty(actno)){
        	   porder.setActNo(actno);
           }else{
        	   porder.setActNo("present");
           }          
           porder.setOrderType(new Integer(2));//默认订单类型为赠送
           porder.setTimeType(Integer.parseInt(timeType));
           porder.setNumValue(Long.parseLong(numValue));
           porder.setPayMoney(new Double(0));
           porder.setOrderMoney(new Double(0));
		   porder.setUserId(Long.parseLong(uid));
		   porder.setNoticeActivity(false);//是否通知活动订单
		   String username = getUserNameByUserId(uid+"");
		   porder.setUserName(StringTools.isEmpty(username)?"":username);			  	
		   porder.setOrderId(orderid);//订单号
		   Date date = new Date();
		   porder.setOrderTime(sdf.format(date));//订单时间
		   porder.setFinishTime(sdf.format(date));
		   porder.setOrderStatus(new Integer(3));//订单生成未支付 
		   FacadeFactory.INSTANCE.getPayOrderBo().presentPayOrder(porder,privateKey.getSeqId()+""); 
		   logger.info("jinzuan present.do success uid="+uid+",orderid="+orderid+",timeType="+timeType+",numValue="+numValue+",timestamp="+timestamp+",bizNo="+bizNo);
		   return JsonObjectUtil.getOnlyOkJson();
		}catch(XLRuntimeException e){
			 logger.info("jinzuan present.do limit  uid="+uid+",orderid="+orderid+",timeType="+timeType+",numValue="+numValue+",timestamp="+timestamp+",bizNo="+bizNo+",reason="+e.getMessage());
			 return JsonObjectUtil.getRtnAndDataJsonObject(13, e.getMessage());
		}catch(Exception e){
			e.printStackTrace();
			 logger.info("jinzuan present.do error uid="+uid+",orderid="+orderid+",timeType="+timeType+",numValue="+numValue+",timestamp="+timestamp+",bizNo="+bizNo+",reason="+e.getMessage());
			 return JsonObjectUtil.getRtnAndDataJsonObject(6, "未知错误");
		}
	}
	
	
	/**
	 * 体验会员赠送接口
	 * @param request
	 * @param response
	 * @return
	 */
	@CmdMapper({"/jinzuan/experience.do"})
	public Object doExperience(XLHttpRequest request, XLHttpResponse response){	
		String uid = request.getParameter("uid");
		String numValue = request.getParameter("numValue");//对应时间的数量
		String orderid = request.getParameter("orderid");//订单号
		String bizNo = request.getParameter("bizNo");//业务编号
		String actno = request.getParameter("actno");//活动编号
		String timestamp = request.getParameter("timestamp");
		String sign = request.getParameter("sign");
		try{
			 String ip = request.getRemoteIP();
			 response.setInnerContentType(XLHttpResponse.ContentType.plain);
			 if(!ValidIPProxy.getInstance().isValidIp(ip,2)){
				 return JsonObjectUtil.getRtnAndDataJsonObject(8, "无效ip");
			 }
			 logger.info("jinzuan experience.do uid="+uid+",orderid="+orderid+",numValue="+numValue+",timestamp="+timestamp+",bizNo="+bizNo+",sign="+sign);
			 if(StringTools.isEmpty(uid)||
				StringTools.isEmpty(orderid)||
				StringTools.isEmpty(numValue)||
				StringTools.isEmpty(actno)||
				StringTools.isEmpty(timestamp)||
				StringTools.isEmpty(sign)||
				StringTools.isEmpty(bizNo)){
				 return JsonObjectUtil.getRtnAndDataJsonObject(1, "参数错误");
			 }			 
			 if(orderid.length()>30){
				 return JsonObjectUtil.getRtnAndDataJsonObject(10, "订单号过长");
			 }
			 logger.info("jinzuan experience.do uid="+uid+",orderid="+orderid+",numValue="+numValue+",timestamp="+timestamp+",bizNo="+bizNo+",sign="+sign);
			 long time = Long.parseLong(timestamp);
			 long mytime = System.currentTimeMillis()/1000;
			 if(mytime - time > 15*60){
				 return JsonObjectUtil.getRtnAndDataJsonObject(4, "请求超时");
			 }
			 PrivateKey privateKeyquery = new PrivateKey();
			 privateKeyquery.setBizNo(bizNo.trim());
			 PrivateKey privateKey = FacadeFactory.INSTANCE.getBaseSo().findObject(privateKeyquery);
			 if(privateKey == null){
				 return JsonObjectUtil.getRtnAndDataJsonObject(9, "业务编号不存在");
			 }
				 
			 String mysgin = Md5Encrypt.md5(uid+orderid+numValue+bizNo+time+privateKey.getPrivateKey());
			 if(!sign.trim().equals(mysgin)){
				 return JsonObjectUtil.getRtnAndDataJsonObject(5, "签名错误");
			 }
			 long num = Long.parseLong(numValue);
			 if(num <= 0){
				 return JsonObjectUtil.getRtnAndDataJsonObject(3, "开通天数必须大于零");
			 }
		   String nowtime = DateUtil.getNowTime();
		   if(DateUtil.compareTime(privateKey.getStartTime(), nowtime)){//如果还没有开始
			   return JsonObjectUtil.getRtnAndDataJsonObject(11, "该体验会员开通接口密钥未开放使用");
		   }
		   if(DateUtil.compareTime(nowtime,privateKey.getEndTime())){//如果已经过期了
			   return JsonObjectUtil.getRtnAndDataJsonObject(12, "该体验会员开通接口密钥已经过期");
		   }
		 	
		   PayOrder query = new PayOrder(); 
		   query.setOrderId(orderid);
		   PayOrder myPayOrder =  FacadeFactory.INSTANCE.getBaseSo().findObject(query);
		   if(myPayOrder != null){
			   return JsonObjectUtil.getRtnAndDataJsonObject(8, "该订单号已存在");
		   }
		   PayOrder porder = new PayOrder();
		   porder.setBankNo("");
           porder.setBizNo(bizNo);  
           porder.setChargeType("A1");
           porder.setPayBizNo("0");
           if(!StringTools.isEmpty(actno)){
        	   porder.setActNo(actno);
           }else{
        	   porder.setActNo("present");
           }          
           porder.setOrderType(new Integer(2));//默认订单类型为赠送
           porder.setTimeType(1);//日
           porder.setNumValue(Long.parseLong(numValue));
           porder.setPayMoney(new Double(0));
           porder.setOrderMoney(new Double(0));
		   porder.setUserId(Long.parseLong(uid));
		   porder.setNoticeActivity(false);//是否通知活动订单
		   String username = getUserNameByUserId(uid+"");
		   porder.setUserName(StringTools.isEmpty(username)?"":username);			  	
		   porder.setOrderId(orderid);//订单号
		   Date date = new Date();
		   porder.setOrderTime(sdf.format(date));//订单时间
		   porder.setFinishTime(sdf.format(date));
		   porder.setOrderStatus(new Integer(3));//订单生成未支付 
		   FacadeFactory.INSTANCE.getPayOrderBo().experiencePayOrder(porder,privateKey.getSeqId()+""); 
		   logger.info("jinzuan experience.do success uid="+uid+",orderid="+orderid+",numValue="+numValue+",timestamp="+timestamp+",bizNo="+bizNo);
		   return JsonObjectUtil.getOnlyOkJson();
		}catch(XLRuntimeException e){
			 logger.info("jinzuan experience.do limit  uid="+uid+",orderid="+orderid+",numValue="+numValue+",timestamp="+timestamp+",bizNo="+bizNo+",reason="+e.getMessage());
			 return JsonObjectUtil.getRtnAndDataJsonObject(13, e.getMessage());
		}catch(Exception e){
			e.printStackTrace();
			 logger.info("jinzuan experience.do error uid="+uid+",orderid="+orderid+",numValue="+numValue+",timestamp="+timestamp+",bizNo="+bizNo+",reason="+e.getMessage());
			 return JsonObjectUtil.getRtnAndDataJsonObject(6, "未知错误");
		}
	}
	
	
	
	
	private String getOrderId(){
		   String orderId = "20" + Utility.createApplyId();
		   if(!StringTools.isEmpty(machineName)){
			   orderId = orderId+machineName;
		   }
		   return orderId;
	}
	
	 public  String getUserNameByUserId(String userId) {
	        String userName = null;
	        try{UserInfoProxy userInfoProxy = ProxyFactory.getInstance().getUserInfoProxy();	
	            Resp_getuserinfo_base userInfo = userInfoProxy.getuserinfo_base(userId, (byte)2);
	            if(userInfo.isOk())
	            {
	                String oldUserName = userInfo.getUsrname();
	                String newUserName = userInfo.getUsernewno()+"";
	                String accountType = String.valueOf(userInfo.getUsertype());
	                userName = accountType.equals("1") ? newUserName : oldUserName;
	            }
	        }catch(Exception e) {
	            logger.error((new StringBuilder()).append("getUserNameByUserId Exception:").append(e).toString());
	            throw new XLRuntimeException(e);
	        }
	        return userName;
	    }
	 
	 
	   private boolean checkCode(String acode){	
		     int len = acode.length();
		     if(len <16||len>20)return false;
		     return acode.matches(regEx);	  
	    }
	 
	    
	   /**
	    * 冻结或解冻激活码
	    * @param request
	    * @param response
	    * @return
	    */
		@CmdMapper({"/jinzuan/freezecode.do"})
		public Object freezeCode(XLHttpRequest request, XLHttpResponse response){	
			String acode = request.getParameter("acode");		
			String type = request.getParameter("type");//状态  1：冻结  2：解冻
			String timestamp = request.getParameter("timestamp");
			String sign = request.getParameter("sign");
			try{
				 String ip = request.getRemoteIP();
				 response.setInnerContentType(XLHttpResponse.ContentType.plain);
				 if(!ValidIPProxy.getInstance().isValidIp(ip,2)){
					 return JsonObjectUtil.getRtnAndDataJsonObject(8, "无效ip");
				 }
				 logger.info("jinzuan freezecode.do acode="+acode+",type="+type+",timestamp="+timestamp+",sign="+sign);
				 if(StringTools.isEmpty(acode)||
					StringTools.isEmpty(type)||
					StringTools.isEmpty(timestamp)||
					StringTools.isEmpty(sign)){
					 return JsonObjectUtil.getRtnAndDataJsonObject(1, "参数错误");
				 }	
				 acode = acode.toUpperCase();
			     if(!checkCode(acode)){
			    	return JsonObjectUtil.getRtnAndDataJsonObject(2,"非法激活码");
			     }				
			     int mytype = Integer.parseInt(type);
				 long time = Long.parseLong(timestamp);
				 long mytime = System.currentTimeMillis()/1000;
				 if(mytime - time > 15*60){
					 return JsonObjectUtil.getRtnAndDataJsonObject(4, "请求超时");
				 }
				 PrivateKey privateKeyquery = new PrivateKey();
				 privateKeyquery.setBizNo(bizNo.trim());
				 PrivateKey privateKey = FacadeFactory.INSTANCE.getBaseSo().findObject(privateKeyquery);
				 if(privateKey == null){
					 return JsonObjectUtil.getRtnAndDataJsonObject(9, "业务编号不存在");
				 }
					 
				String mysgin = Md5Encrypt.md5(acode+type+timestamp+privateKey.getPrivateKey());
				if(!sign.trim().equals(mysgin)){
					 return JsonObjectUtil.getRtnAndDataJsonObject(5, "签名错误");
				}
                
			   FacadeFactory.INSTANCE.getCodeCodeBo().freeze(acode, mytype);
			   logger.info("jinzuan freezecode.do success acode="+acode+",type="+type+",timestamp="+timestamp+",sign="+sign+",bizNo="+bizNo);
			   return JsonObjectUtil.getOnlyOkJson();
			}catch(XLRuntimeException e){
				 logger.info("jinzuan freezecode.do limit  acode="+acode+",type="+type+",timestamp="+timestamp+",sign="+sign+",bizNo="+bizNo+",reason="+e.getMessage());
				 return JsonObjectUtil.getRtnAndDataJsonObject(7, e.getMessage());
			}catch(Exception e){
				e.printStackTrace();
				 logger.info("jinzuan freezecode.do error acode="+acode+",type="+type+",timestamp="+timestamp+",sign="+sign+",bizNo="+bizNo+",reason="+e.getMessage());
				 return JsonObjectUtil.getRtnAndDataJsonObject(6, "网络异常");
			}
		}
}
