package com.xunlei.niux.pay.client;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.log4j.Logger;
import org.json.JSONObject;


public class UserClient {

	private final static UserClient userClient = new UserClient();
	private static final Logger logger = Logger.getLogger("businessLogger");
    private final String queryURL="http://interface.reg.vip.xunlei.com/service/usertype";
    
	public static UserClient getInstance() {
		return userClient;
	}

	private UserClient() {
	}

	public boolean checkChildrenAccount(String userid) {
		boolean result = false;

		try {
		
			String callurl = queryURL + "?request=checkChildren&userid="+userid;
			String returnvalue = this.execute(callurl);
			logger.info("checkChildrenAccount userid"
					+userid + "result:" + returnvalue);
			JSONObject jsonObject = new JSONObject(returnvalue);
			String code = jsonObject.getString("result");
			if(code.equals("200")){
				result=true;
			}
			

		} catch (Exception e) {
			logger.info("checkChildrenAccount exception userid"
					+userid ,e);
		}
		return result;

	}

	private String execute(String callurl) {
		long start = System.currentTimeMillis();
		StringBuilder builder = new StringBuilder();
		URL url = null;
		HttpURLConnection httpURLConnection = null;
		BufferedReader rd = null;
		try {
			url = new URL(callurl);
			httpURLConnection = (HttpURLConnection) url.openConnection();
			httpURLConnection.setRequestProperty("user-agent",
					"mozilla/4.0 (compatible;x11;Linux i686)");
			httpURLConnection.setRequestProperty("Connection", "close");
			httpURLConnection.setConnectTimeout(10000);
			httpURLConnection.setReadTimeout(10000);
			httpURLConnection.connect();
			InputStream in = httpURLConnection.getInputStream();

			rd = new BufferedReader(new InputStreamReader(in, "utf-8"));

			String line = null;
			while ((line = rd.readLine()) != null) {
				builder.append(line);
			}
		} catch (Exception e) {
			logger.info("execute GiftVipCart exception url=" + callurl, e);
		} finally {
			if (rd != null) {
				try {
					rd.close();
				} catch (Exception e) {

				}
			}
			url = null;
			httpURLConnection = null;
		}
		logger.info("GiftVipCartCost:"
				+ (System.currentTimeMillis() - start + ",url=" + callurl));
		return builder == null ? null : builder.toString();
	}

}
