package com.xunlei.niux.pay.activity;

import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;
import java.util.concurrent.ConcurrentHashMap;
import com.xunlei.niux.data.jinzuan.vo.PayOrder;
import com.xunlei.niux.pay.util.DateUtil;
import com.xunlei.niux.pay.vo.Activity;

public class ActivityProxy {

	private static final ActivityProxy instance = new ActivityProxy();
	private ActivityProxy(){
		
	}
	
	public static ActivityProxy getInstance(){
		return instance;
	}
	
	
	public void notice(PayOrder payorder) throws Exception{
		Calendar calendar = Calendar.getInstance();
		String nowTime = DateUtil.getTime(calendar.getTime());
		calendar.add(Calendar.DATE, -1);
		String deadTime =  DateUtil.getTime(calendar.getTime());
		Map<String, ConcurrentHashMap<String, String>> activityConfigMap = ActivityConfig
				.getInstance().getActivityConfigMap();
		Set<Entry<String, ConcurrentHashMap<String, String>>> entryseSet = activityConfigMap
				.entrySet();
		for (Map.Entry<String, ConcurrentHashMap<String, String>> entry : entryseSet) {
			String actno = entry.getKey();
			Map<String, String> values = entry.getValue();
			String callbackURL = values.get("callbackURL");
			String startTime = values.get("startTime");
			String endTime = values.get("endTime");
			String vipRebates = values.get("vipRebates");
			String notice = values.get("notice");
			String key = values.get("key");
			String actName =  values.get("name");
			if (notice != null && notice.equals("true")
					&& (nowTime.compareTo(startTime) > 0)
					&& (deadTime.compareTo(endTime) < 0)&&actno.equals(payorder.getActNo())) {
				Activity activity = new Activity();
				activity.setActName(actName);
				activity.setActno(actno);
				activity.setKey(key);
				activity.setCallbackURL(callbackURL);
				activity.setOrderid(payorder.getOrderId());
				activity.setTotalmoney(payorder.getOrderMoney()+"");
				activity.setPayMoney(payorder.getPayMoney()+"");
				activity.setUserid(payorder.getUserId()+"");
				activity.setUserName(payorder.getUserName());
				activity.setExtparam(payorder.getExt1());
				activity.setNumValue(payorder.getNumValue());
				activity.setTimeType(payorder.getTimeType());
				ActivityRequest.getInstance().noticeActivity(activity);
			}
		}
	}
}
