package com.xunlei.niux.pay.activity;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ActivityConfig {
	private static Logger logger = Logger.getLogger(ActivityConfig.class);

	private Map<String, ConcurrentHashMap<String, String>> activityConfigMap = new ConcurrentHashMap<String, ConcurrentHashMap<String, String>>();
	private static final ActivityConfig activityConfig = new ActivityConfig();

	public static ActivityConfig getInstance() {
		return activityConfig;
	}

	public Map<String, ConcurrentHashMap<String, String>> getActivityConfigMap() {
		return activityConfigMap;
	}

	public void setActivityConfigMap(
			Map<String, ConcurrentHashMap<String, String>> activityConfigMap) {
		this.activityConfigMap = activityConfigMap;
	}

	private ActivityConfig() {
	}

	@SuppressWarnings("static-access")
	public synchronized void loadConfig() {

		String path = ActivityConfig.class.getResource("/activityConfig.xml")
				.getFile();
		try {
			this.activityConfig.loadActivityConfig(path);
		} catch (Exception e) {
			logger.info("loadConfig  load activityConfig.xml  error", e);
		}
	}

	@SuppressWarnings("unchecked")
	public synchronized void loadActivityConfig(String path) throws Exception {
		Document doc = null;
		try {
			SAXReader saxReader = new SAXReader();
			InputStream is = new FileInputStream(path);
			doc = saxReader.read(is);
			is.close();
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("load " + "activityConfig.xml" + " exception", e);
			throw new Exception("load " + "activityConfig.xml" + " exception");
		}

		Element root = doc.getRootElement();
		if (!root.getName().equals("activitys")) {
			throw new Exception(
					"activitys is not root element in activityConfig.xml");
		}

		List gameChildren = root.elements("activity");
		for (Object obj : gameChildren) {
			Element activity = (Element) obj;
			String actno = activity.attributeValue("actno");
			String actName = activity.attributeValue("name");
			List gameProperty = activity.elements("property");

			ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
			for (Object p : gameProperty) {
				Element property = (Element) p;
				map.put(property.attributeValue("name"), property
						.attributeValue("value"));
			}
			map.put("name", actName);
			activityConfigMap.put(actno, map);
			System.out.println("map:"+map);

		}
		logger.info("loadactivityConfig.xml:加载完毕，activityConfigMap："
				+ activityConfigMap.toString());
	}

	public String getProperty(String actno, String key) {
		String value = null;
		if (activityConfigMap.get(actno) != null) {
			value =activityConfigMap.get(actno).get(key);
		}

		return value;

	}
	
	public  static void main(String [] args){
		ActivityConfig.getInstance().loadConfig();
	}

}
