package com.xunlei.niux.pay;


import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import com.xunlei.netty.httpserver.Bootstrap;
import com.xunlei.netty.httpserver.util.HttpServerConfig;
import com.xunlei.niux.pay.activity.ActivityConfig;
import com.xunlei.niux.pay.task.NoticeActivityTask;
import com.xunlei.niux.pay.util.RBundleUtil;

/**
 * 启动jinzuan平台
 * @author lisu
 * @date 2012-8-13
 * @Descripter:
 */
public class Launch {
	private static final String machineName = RBundleUtil.getString("pay", "machineName");//机器名
	
	public static void main(String [] args)throws IOException{
		Bootstrap.main(args, new Runnable(){
			public void run(){
				//初始化数据库
				try {
					System.out.println("开始初始化数据库");
					JndiCommonProvider.init();
					System.out.println("成功初始化数据库");
				} catch (Exception e) {
					System.out.println("初始化数据库出现异常");
					e.printStackTrace();
				}
				
		
				//加载配置文件程序
				try{
					System.out.println("开始加载配置文件");
					ActivityConfig.getInstance().loadConfig();
					System.out.println("成功加载配置文件");
				}catch(Exception e){
					System.out.println("加载配置文件出现异常");
					e.printStackTrace();
				}
				if("N1".equals(machineName)){//
					//启动多线程程序
					ScheduledExecutorService executor = Executors.newScheduledThreadPool(5);
					executor.scheduleAtFixedRate(new NoticeActivityTask(), 10, 60,TimeUnit.MINUTES);
				}
			}
		}, new Runnable(){
			public void run(){
				//在关闭httpSever时,走安全关闭的步骤时,须关闭内部的boss线程跟worker线程
				//可能关闭会很慢
				HttpServerConfig.releaseExternalResources();
			}
		}, "classpath:applicationContext_main.xml");
	}
}
