package com.xunlei.niux.pay;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.SessionInvalidError;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.component.XLHttpResponse.ContentType;
import com.xunlei.niux.pay.util.SignUtil;




public class DefaultCmd extends com.xunlei.httptool.login.DefaultCmd{
	protected static SimpleDateFormat sdf_time=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	/**
	 * 获取cookie中的用户名
	 */
	public String getUserName(XLHttpRequest request){
		String userName=request.getCookieValue("usernewno","");
		if("".equals(userName)||"0".equals(userName)){
			userName=request.getCookieValue("usrname","");
		}
		return urldecode(userName);
	}
	public static String urldecode(String value){
		if(value==null){
			return null;
		}
		try {
			return URLDecoder.decode(value, "UTF-8");
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
	}
	
	/**
	 * 获得系统当前时间
	 * @return
	 */
	public static String now(){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return sdf.format(new Date());
	}
	public MainParam getMainParamSafe(XLHttpRequest request,XLHttpResponse response,boolean isSeccode){
		try {
			MainParam mainParam= this.getMainParam(request, response, isSeccode);
			String userId=request.getCookieValue("userid", "");//request.getParameter("userid", "");
			if(userId.equals(String.valueOf(mainParam.getUserid()))==false){
				throw SessionInvalidError.INSTANCE;
			}
			return mainParam;
		} catch (Exception e) {
			throw new RuntimeException();
		}
	}
	protected  void setInnerContentType(XLHttpRequest request,XLHttpResponse response){
		String resptype=request.getParameter("resptype","json");
		if("plain".equals(resptype)){
			response.setInnerContentType(ContentType.plain);
		}
	}
	protected boolean isValidSign(XLHttpRequest request,String privateKey,String oldSign,String[] signParamNames){
		Map<String,String> paramMap=new HashMap<String,String>();
		if(signParamNames==null||signParamNames.length==0){
			throw new NullPointerException("验证签名参数为空");
		}
		for(String paramName:signParamNames){
			paramMap.put(paramName, request.getParameter(paramName,""));
		}
		String sign=SignUtil.sign(paramMap, privateKey);
		return sign.equals(oldSign);
	}
	
	 public MainParam checkMainParam(XLHttpRequest request, XLHttpResponse response,boolean isSeccode){
			try {
				return this.getMainParam(request, response, isSeccode);
			} catch (Exception e) {
				throw new RuntimeException(e.getMessage(), e);
			}
		}
}
