/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.mobilegame.sdk.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xunlei.niux.mobilegame.sdk.common.ui.SimpleTitleBar;
import com.xunlei.niux.mobilegame.sdk.platform.NiuxMobileGame;
import com.xunlei.niux.mobilegame.sdk.services.LoginService;
import com.xunlei.niux.mobilegame.sdk.vo.User;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;

public class UserCenterActivity
extends Activity {
    private static final String a = UserCenterActivity.class.getSimpleName();
    private SimpleTitleBar b;
    private ImageView c;
    private TextView d;
    private LinearLayout e;
    private RefreshHandler f;

    protected void onCreate(Bundle bundle) {
        Log.d((String)a, (String)"onCreate()");
        super.onCreate(bundle);
        int n = this.getResources().getIdentifier("userinfo", "layout", this.getPackageName());
        this.setContentView(n);
        if (LoginService.getInstance().getIsLogin()) {
            this.b();
            this.f = new RefreshHandler(this);
        } else {
            Log.d((String)a, (String)"Didn't Login, finish()");
            this.finish();
        }
    }

    protected void onStart() {
        Log.d((String)a, (String)"onStart()");
        super.onStart();
    }

    protected void onResume() {
        Log.d((String)a, (String)"onResume()");
        super.onResume();
        if (LoginService.getInstance().getIsLogin()) {
            this.c();
        } else {
            Log.d((String)a, (String)"Didn't Login, finish()");
            this.finish();
        }
    }

    protected void onPause() {
        Log.d((String)a, (String)"onPause()");
        super.onPause();
    }

    protected void onStop() {
        Log.d((String)a, (String)"onStop()");
        super.onStop();
    }

    protected void onDestroy() {
        Log.d((String)a, (String)"onDestroy()");
        NiuxMobileGame.getInstance().getListener().onAcitvityFinish();
        super.onDestroy();
    }

    protected void onActivityResult(int n, int n2, Intent intent) {
        Log.d((String)a, (String)("onActivityResult(" + n2 + ", " + n + ")"));
        super.onActivityResult(n, n2, intent);
    }

    private void b() {
        Log.d((String)a, (String)"initUI() -> find views");
        int n = this.getResources().getIdentifier("st_title", "id", this.getPackageName());
        this.b = (SimpleTitleBar)this.findViewById(n);
        int n2 = this.getResources().getIdentifier("image_view_avatar", "id", this.getPackageName());
        this.c = (ImageView)this.findViewById(n2);
        int n3 = this.getResources().getIdentifier("text_view_nickname", "id", this.getPackageName());
        this.d = (TextView)this.findViewById(n3);
        int n4 = this.getResources().getIdentifier("ll_logout", "id", this.getPackageName());
        this.e = (LinearLayout)this.findViewById(n4);
        Log.d((String)a, (String)"initUI() -> attach event listener");
        this.e.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                NiuxMobileGame.getInstance().changeUser((Context)UserCenterActivity.this);
                UserCenterActivity.this.finish();
            }
        });
        int n5 = this.getResources().getIdentifier("user_center", "string", this.getPackageName());
        this.b.setTitleText(n5);
        this.b.setBtnLeftListener(new View.OnClickListener(){

            public void onClick(View view) {
                UserCenterActivity.this.finish();
            }
        });
    }

    private void c() {
        User user = LoginService.getInstance().getUser();
        String string = "nil".equals(user.getName()) ? user.getNickname() : user.getName();
        this.d.setText((CharSequence)string);
        new LoadAvatarThread((Context)this, this.f).start();
    }

    private static class LoadAvatarThread
    extends Thread {
        RefreshHandler a = null;
        Context b = null;

        public LoadAvatarThread(Context context, RefreshHandler refreshHandler) {
            this.a = refreshHandler;
            this.b = context;
        }

        @Override
        public void run() {
            Bitmap bitmap = null;
            User user = LoginService.getInstance().getUser();
            String string = "http://img.ucenter.xunlei.com/usrimg/{userid}/50x50".replace("{userid}", String.valueOf(user.getUid())).concat("?ct=" + System.currentTimeMillis());
            try {
                bitmap = BitmapFactory.decodeStream((InputStream)((InputStream)new URL(string).getContent()));
            }
            catch (MalformedURLException malformedURLException) {
                Log.e((String)a, (String)("MalformedURLException : " + malformedURLException.getMessage()));
            }
            catch (IOException iOException) {
                Log.e((String)a, (String)("IOException : " + iOException.getMessage()));
            }
            if (bitmap == null) {
                int n = this.b.getResources().getIdentifier("avatar", "drawable", this.b.getPackageName());
                bitmap = BitmapFactory.decodeResource((Resources)this.b.getResources(), (int)n);
            }
            Message message = Message.obtain((Handler)this.a);
            message.obj = bitmap;
            message.what = 3;
            message.sendToTarget();
        }
    }

    private static class RefreshHandler
    extends Handler {
        WeakReference<UserCenterActivity> a;

        RefreshHandler(UserCenterActivity userCenterActivity) {
            this.a = new WeakReference<UserCenterActivity>(userCenterActivity);
        }

        public void handleMessage(Message message) {
            UserCenterActivity userCenterActivity = (UserCenterActivity)((Object)this.a.get());
            switch (message.what) {
                case 0: {
                    break;
                }
                case 3: {
                    Bitmap bitmap = (Bitmap)message.obj;
                    userCenterActivity.c.setImageBitmap(bitmap);
                }
            }
        }
    }
}

