package com.xunlei.niux.data.usergame.dao;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import com.xunlei.niux.data.usergame.util.Md5Util;
import com.xunlei.niux.data.usergame.vo.User_game_history;

public class UserGameHistoryDaoImpl extends BaseDaoImpl implements
		UserGameHistoryDao {
	private static final Logger logger=Logger.getLogger(UserGameHistoryDaoImpl.class.getName());
	public List<User_game_history> queryUserPlayGame(long uid, String gamename,int limitnum ){
		StringBuilder sb=new StringBuilder();
		sb.append(" select * from ").append(getTableName(uid))
		  .append(" where userid=").append(uid);
		if(gamename!=null&&!"".equals(gamename)){
			sb.append(" and game='").append(gamename).append("'");
		}
		sb.append(" order by time desc ");
		if(limitnum>0){
			sb.append(" limit 0,").append(limitnum);
		}
		logger.debug("sql: "+sb.toString());
		return this.query(User_game_history.class, sb.toString());
	}
	public List<User_game_history> queryUserPlayGameDisticnt(long uid, String gamename,int limitnum ){
		StringBuilder sb=new StringBuilder();
		sb.append(" select userid,usernick,game,fenqu,max(time) time,'' ip from ").append(getTableName(uid))
		  .append(" where userid=").append(uid);
		if(gamename!=null&&!"".equals(gamename)){
			sb.append(" and game='").append(gamename).append("'");
		}
		sb.append(" GROUP BY userid,game,fenqu ");
		sb.append(" order by time desc ");
		if(limitnum>0){
			sb.append(" limit 0,").append(limitnum);
		}
		logger.debug("sql: "+sb.toString());
		return this.query(User_game_history.class, sb.toString());
	}
	/**
	 * 查询最近玩家
	 * @param limitnum
	 * @return
	 */
	public List<User_game_history> queryLatestUser(int limitnum){
		List<User_game_history> list=new ArrayList<User_game_history>();
		String sql="";
		int num=limitnum/16;
		int num1=limitnum%16;
		char[] cArr=new char[]{'0','1','2','3','4','5','6','7','8','9','a','b','c','d','e'};
		for(int i=0;i<cArr.length;i++){
			int tempnum=num;
			if(i==0){
				tempnum=tempnum+num1;
			}
			if(tempnum<0){
				continue;
			}
			sql="select * from user_game_history_"+cArr[i]+" order by time desc limit 0,"+tempnum;
			List<User_game_history> tempList=this.query(User_game_history.class,sql);
			list.addAll(tempList);
			sql="";
		}
		return list;
	}
	/**
	 * 获取表名
	 * @param userid
	 * @return
	 */
	private String getTableName(long userid){
		String temp=Md5Util.toMD5(String.valueOf(userid));
		return "user_game_history_"+temp.charAt(0);
	}
}
