package com.xunlei.niux.data.usergame.dao;

import java.util.List;

import com.xunlei.niux.data.usergame.vo.User_game_history;
/**
 * 用户游戏关系数据访问
 * @author lin
 * @date 2012-8-14
 * @Descripter:
 */
public interface UserGameHistoryDao extends BaseDao {
	/**
	 * 查询用户最新玩过的某游戏分区信息
	 * @param uid 用户UID
	 * @param gamename 游戏名
	 * @param limitnum 返回条数；如果小于或等于零，全部返回
	 * @return 
	 */
	List<User_game_history> queryUserPlayGame(long uid,String gamename,int limitnum );
	/**
	 * 查询最近玩家
	 * @param limitnum
	 * @return
	 */
	List<User_game_history> queryLatestUser(int limitnum);
	/**
	 * 查询用户最新玩过的某游戏分区信息(去重)
	 * @param uid
	 * @param gamename
	 * @param limitnum
	 * @return
	 */
	List<User_game_history> queryUserPlayGameDisticnt(long uid, String gamename,int limitnum );
}
