/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import com.google.common.base.Throwables;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.HeartbeatThread;
import tachyon.LeaderInquireClient;
import tachyon.Version;
import tachyon.conf.TachyonConf;
import tachyon.master.MasterClientHeartbeatExecutor;
import tachyon.org.apache.thrift.TException;
import tachyon.org.apache.thrift.protocol.TBinaryProtocol;
import tachyon.org.apache.thrift.protocol.TProtocol;
import tachyon.org.apache.thrift.transport.TFramedTransport;
import tachyon.org.apache.thrift.transport.TSocket;
import tachyon.org.apache.thrift.transport.TTransportException;
import tachyon.retry.ExponentialBackoffRetry;
import tachyon.thrift.BlockInfoException;
import tachyon.thrift.ClientBlockInfo;
import tachyon.thrift.ClientDependencyInfo;
import tachyon.thrift.ClientFileInfo;
import tachyon.thrift.ClientRawTableInfo;
import tachyon.thrift.ClientWorkerInfo;
import tachyon.thrift.Command;
import tachyon.thrift.DependencyDoesNotExistException;
import tachyon.thrift.FileAlreadyExistException;
import tachyon.thrift.FileDoesNotExistException;
import tachyon.thrift.InvalidPathException;
import tachyon.thrift.MasterService;
import tachyon.thrift.NetAddress;
import tachyon.thrift.NoWorkerException;
import tachyon.thrift.SuspectedFileSizeException;
import tachyon.thrift.TableColumnException;
import tachyon.thrift.TableDoesNotExistException;
import tachyon.thrift.TachyonException;
import tachyon.util.CommonUtils;
import tachyon.util.NetworkUtils;

public final class MasterClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final boolean mUseZookeeper;
    private MasterService.Client mClient = null;
    private InetSocketAddress mMasterAddress = null;
    private TProtocol mProtocol = null;
    private volatile boolean mConnected;
    private volatile boolean mIsClosed;
    private volatile long mUserId = -1L;
    private final ExecutorService mExecutorService;
    private Future<?> mHeartbeat;
    private final TachyonConf mTachyonConf;

    public MasterClient(InetSocketAddress masterAddress, ExecutorService executorService, TachyonConf tachyonConf) {
        this.mTachyonConf = tachyonConf;
        this.mUseZookeeper = this.mTachyonConf.getBoolean("tachyon.usezookeeper", false);
        if (!this.mUseZookeeper) {
            this.mMasterAddress = masterAddress;
        }
        this.mConnected = false;
        this.mIsClosed = false;
        this.mExecutorService = executorService;
    }

    public synchronized boolean addCheckpoint(long workerId, int fileId, long length, String checkpointPath) throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.addCheckpoint(workerId, fileId, length, checkpointPath);
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (SuspectedFileSizeException e) {
                throw new IOException(e);
            }
            catch (BlockInfoException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect() {
        if (this.mConnected) {
            LOG.debug("Disconnecting from the master {}", (Object)this.mMasterAddress);
            this.mConnected = false;
        }
        try {
            if (this.mProtocol != null) {
                this.mProtocol.getTransport().close();
            }
        }
        finally {
            if (this.mHeartbeat != null) {
                this.mHeartbeat.cancel(true);
            }
        }
    }

    public synchronized void connect() throws IOException {
        if (this.mConnected) {
            return;
        }
        this.disconnect();
        if (this.mIsClosed) {
            throw new IOException("Client is closed, will not try to connect");
        }
        TException lastException = null;
        int maxConnectsTry = this.mTachyonConf.getInt("tachyon.master.retry", 29);
        ExponentialBackoffRetry retry = new ExponentialBackoffRetry(50, 1000, maxConnectsTry);
        do {
            this.mMasterAddress = this.getMasterAddress();
            LOG.info("Tachyon client (version " + Version.VERSION + ") is trying to connect with master" + " @ " + this.mMasterAddress);
            this.mProtocol = new TBinaryProtocol(new TFramedTransport(new TSocket(NetworkUtils.getFqdnHost(this.mMasterAddress), this.mMasterAddress.getPort())));
            this.mClient = new MasterService.Client(this.mProtocol);
            try {
                this.mProtocol.getTransport().open();
                MasterClientHeartbeatExecutor heartBeater = new MasterClientHeartbeatExecutor(this);
                String threadName = "master-heartbeat-" + this.mMasterAddress;
                int interval = this.mTachyonConf.getInt("tachyon.user.heartbeat.interval.ms", 1000);
                this.mHeartbeat = this.mExecutorService.submit(new HeartbeatThread(threadName, heartBeater, interval / 2));
            }
            catch (TTransportException e) {
                lastException = e;
                LOG.error("Failed to connect (" + retry.getRetryCount() + ") with master @ " + this.mMasterAddress + " : " + e.getMessage());
                if (this.mHeartbeat == null) continue;
                this.mHeartbeat.cancel(true);
                continue;
            }
            try {
                this.mUserId = this.mClient.user_getUserId();
            }
            catch (TException e) {
                lastException = e;
                LOG.error(e.getMessage(), (Throwable)e);
                continue;
            }
            LOG.info("User registered with the master @ " + this.mMasterAddress + "; got UserId " + this.mUserId);
            this.mConnected = true;
            return;
        } while (retry.attemptRetry() && !this.mIsClosed);
        throw new IOException("Failed to connect with master @ " + this.mMasterAddress + " after " + retry.getRetryCount() + " attempts", lastException);
    }

    public synchronized ClientDependencyInfo getClientDependencyInfo(int did) throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.user_getClientDependencyInfo(did);
            }
            catch (DependencyDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return null;
    }

    public synchronized ClientFileInfo getFileStatus(int fileId, String path) throws IOException {
        if (path == null) {
            path = "";
        }
        if (fileId == -1 && !path.startsWith("/")) {
            throw new IOException("Illegal path parameter: " + path);
        }
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.getFileStatus(fileId, path);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return null;
    }

    private synchronized InetSocketAddress getMasterAddress() {
        if (!this.mUseZookeeper) {
            return this.mMasterAddress;
        }
        LeaderInquireClient leaderInquireClient = LeaderInquireClient.getClient(this.mTachyonConf.get("tachyon.zookeeper.address", null), this.mTachyonConf.get("tachyon.zookeeper.leader.path", null));
        try {
            String temp = leaderInquireClient.getMasterAddress();
            return CommonUtils.parseInetSocketAddress(temp);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public synchronized long getUserId() throws IOException {
        if (!this.mIsClosed) {
            this.connect();
            return this.mUserId;
        }
        return -1L;
    }

    public synchronized List<ClientWorkerInfo> getWorkersInfo() throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.getWorkersInfo();
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return null;
    }

    public synchronized long getCapacityBytes() throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.user_getCapacityBytes();
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return -1L;
    }

    public synchronized long getUsedBytes() throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.user_getUsedBytes();
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return -1L;
    }

    public synchronized boolean isConnected() {
        return this.mConnected;
    }

    public synchronized List<ClientFileInfo> listStatus(String path) throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.liststatus(path);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return null;
    }

    private synchronized void parameterCheck(int id, String path) throws IOException {
        if (path == null) {
            throw new NullPointerException("Paths may not be null; empty is the null state");
        }
        if (id == -1 && !path.startsWith("/")) {
            throw new IOException("Illegal path parameter: " + path);
        }
    }

    @Override
    public synchronized void close() {
        this.disconnect();
        this.mIsClosed = true;
    }

    public synchronized void user_completeFile(int fId) throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                this.mClient.user_completeFile(fId);
                return;
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
    }

    public synchronized int user_createDependency(List<String> parents, List<String> children, String commandPrefix, List<ByteBuffer> data, String comment, String framework, String frameworkVersion, int dependencyType, long childrenBlockSizeByte) throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.user_createDependency(parents, children, commandPrefix, data, comment, framework, frameworkVersion, dependencyType, childrenBlockSizeByte);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (FileAlreadyExistException e) {
                throw new IOException(e);
            }
            catch (BlockInfoException e) {
                throw new IOException(e);
            }
            catch (TachyonException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return -1;
    }

    public synchronized int user_createFile(String path, String ufsPath, long blockSizeByte, boolean recursive) throws IOException {
        if (path == null || !path.startsWith("/")) {
            throw new IOException("Illegal path parameter: " + path);
        }
        if (ufsPath == null) {
            ufsPath = "";
        }
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.user_createFile(path, ufsPath, blockSizeByte, recursive);
            }
            catch (FileAlreadyExistException e) {
                throw new IOException(e);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (BlockInfoException e) {
                throw new IOException(e);
            }
            catch (SuspectedFileSizeException e) {
                throw new IOException(e);
            }
            catch (TachyonException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return -1;
    }

    public synchronized long user_createNewBlock(int fId) throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.user_createNewBlock(fId);
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return -1L;
    }

    public synchronized int user_createRawTable(String path, int columns, ByteBuffer metadata) throws IOException {
        if (metadata == null) {
            metadata = ByteBuffer.allocate(0);
        }
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.user_createRawTable(path, columns, metadata);
            }
            catch (FileAlreadyExistException e) {
                throw new IOException(e);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (TableColumnException e) {
                throw new IOException(e);
            }
            catch (TachyonException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return -1;
    }

    public synchronized boolean user_delete(int fileId, String path, boolean recursive) throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.user_delete(fileId, path, recursive);
            }
            catch (TachyonException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return false;
    }

    public synchronized long user_getBlockId(int fId, int index) throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.user_getBlockId(fId, index);
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return -1L;
    }

    public synchronized ClientBlockInfo user_getClientBlockInfo(long blockId) throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.user_getClientBlockInfo(blockId);
            }
            catch (FileDoesNotExistException e) {
                throw new FileNotFoundException(e.getMessage());
            }
            catch (BlockInfoException e) {
                throw new IOException(e.getMessage(), e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return null;
    }

    public synchronized ClientRawTableInfo user_getClientRawTableInfo(int id, String path) throws IOException {
        this.parameterCheck(id, path);
        while (!this.mIsClosed) {
            this.connect();
            try {
                ClientRawTableInfo ret = this.mClient.user_getClientRawTableInfo(id, path);
                ret.setMetadata(CommonUtils.generateNewByteBufferFromThriftRPCResults(ret.metadata));
                return ret;
            }
            catch (TableDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return null;
    }

    public synchronized List<ClientBlockInfo> user_getFileBlocks(int fileId, String path) throws IOException {
        this.parameterCheck(fileId, path);
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.user_getFileBlocks(fileId, path);
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return null;
    }

    public synchronized int user_getRawTableId(String path) throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.user_getRawTableId(path);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return -1;
    }

    public synchronized String user_getUfsAddress() throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.user_getUfsAddress();
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return null;
    }

    public synchronized NetAddress user_getWorker(boolean random, String hostname) throws NoWorkerException, IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.user_getWorker(random, hostname);
            }
            catch (NoWorkerException e) {
                throw e;
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return null;
    }

    public synchronized void user_heartbeat() throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                this.mClient.user_heartbeat();
                return;
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
    }

    public synchronized boolean user_mkdirs(String path, boolean recursive) throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.user_mkdirs(path, recursive);
            }
            catch (FileAlreadyExistException e) {
                throw new IOException(e);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (TachyonException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return false;
    }

    public synchronized boolean user_rename(int fileId, String srcPath, String dstPath) throws IOException {
        this.parameterCheck(fileId, srcPath);
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.user_rename(fileId, srcPath, dstPath);
            }
            catch (FileAlreadyExistException e) {
                throw new IOException(e);
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return false;
    }

    public synchronized void user_reportLostFile(int fileId) throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                this.mClient.user_reportLostFile(fileId);
                return;
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
    }

    public synchronized void user_requestFilesInDependency(int depId) throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                this.mClient.user_requestFilesInDependency(depId);
                return;
            }
            catch (DependencyDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
    }

    public synchronized void user_setPinned(int id, boolean pinned) throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                this.mClient.user_setPinned(id, pinned);
                return;
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
    }

    public synchronized void user_updateRawTableMetadata(int id, ByteBuffer metadata) throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                this.mClient.user_updateRawTableMetadata(id, metadata);
                return;
            }
            catch (TableDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (TachyonException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
    }

    public synchronized boolean user_freepath(int fileId, String path, boolean recursive) throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.user_freepath(fileId, path, recursive);
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return false;
    }

    public synchronized void worker_cacheBlock(long workerId, long usedBytesOnTier, long storageDirId, long blockId, long length) throws IOException, FileDoesNotExistException, BlockInfoException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                this.mClient.worker_cacheBlock(workerId, usedBytesOnTier, storageDirId, blockId, length);
                return;
            }
            catch (FileDoesNotExistException e) {
                throw e;
            }
            catch (BlockInfoException e) {
                throw e;
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
    }

    public synchronized Set<Integer> worker_getPinIdList() throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.worker_getPinIdList();
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return null;
    }

    public synchronized List<Integer> worker_getPriorityDependencyList() throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.worker_getPriorityDependencyList();
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return new ArrayList<Integer>();
    }

    public synchronized Command worker_heartbeat(long workerId, List<Long> usedBytesOnTiers, List<Long> removedBlockIds, Map<Long, List<Long>> addedBlockIds) throws IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                return this.mClient.worker_heartbeat(workerId, usedBytesOnTiers, removedBlockIds, addedBlockIds);
            }
            catch (BlockInfoException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return null;
    }

    public synchronized long worker_register(NetAddress workerNetAddress, List<Long> totalBytesOnTiers, List<Long> usedBytesOnTiers, Map<Long, List<Long>> currentBlockList) throws BlockInfoException, IOException {
        while (!this.mIsClosed) {
            this.connect();
            try {
                long ret = this.mClient.worker_register(workerNetAddress, totalBytesOnTiers, usedBytesOnTiers, currentBlockList);
                LOG.info("Registered at the master " + this.mMasterAddress + " from worker " + workerNetAddress + " , got WorkerId " + ret);
                return ret;
            }
            catch (BlockInfoException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        return -1L;
    }
}

