/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.xmlbeans;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.util.XMLEventConsumer;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlSaxHandler;
import org.apache.xmlbeans.XmlValidationError;
import org.springframework.oxm.AbstractMarshaller;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.xmlbeans.XmlBeansUtils;
import org.springframework.oxm.xmlbeans.XmlBeansValidationFailureException;
import org.springframework.xml.stream.StaxEventContentHandler;
import org.springframework.xml.stream.StaxEventXmlReader;
import org.springframework.xml.stream.StaxStreamContentHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class XmlBeansMarshaller
extends AbstractMarshaller {
    private XmlOptions xmlOptions;
    static /* synthetic */ Class class$org$apache$xmlbeans$XmlObject;

    public void setXmlOptions(XmlOptions xmlOptions) {
        this.xmlOptions = xmlOptions;
    }

    public boolean supports(Class clazz) {
        return (class$org$apache$xmlbeans$XmlObject == null ? (class$org$apache$xmlbeans$XmlObject = XmlBeansMarshaller.class$("org.apache.xmlbeans.XmlObject")) : class$org$apache$xmlbeans$XmlObject).isAssignableFrom(clazz);
    }

    public XmlMappingException convertXmlBeansException(Exception ex, boolean marshalling) {
        return XmlBeansUtils.convertXmlBeansException(ex, marshalling);
    }

    protected void marshalDomNode(Object graph, Node node) throws XmlMappingException {
        Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        Node xmlBeansNode = ((XmlObject)graph).newDomNode(this.xmlOptions);
        NodeList xmlBeansChildNodes = xmlBeansNode.getChildNodes();
        for (int i = 0; i < xmlBeansChildNodes.getLength(); ++i) {
            Node xmlBeansChildNode = xmlBeansChildNodes.item(i);
            Node importedNode = document.importNode(xmlBeansChildNode, true);
            node.appendChild(importedNode);
        }
    }

    protected void marshalOutputStream(Object graph, OutputStream outputStream) throws XmlMappingException, IOException {
        ((XmlObject)graph).save(outputStream, this.xmlOptions);
    }

    protected void marshalSaxHandlers(Object graph, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws XmlMappingException {
        try {
            ((XmlObject)graph).save(contentHandler, lexicalHandler, this.xmlOptions);
        }
        catch (SAXException ex) {
            throw this.convertXmlBeansException(ex, true);
        }
    }

    protected void marshalWriter(Object graph, Writer writer) throws XmlMappingException, IOException {
        ((XmlObject)graph).save(writer, this.xmlOptions);
    }

    protected void marshalXmlEventWriter(Object graph, XMLEventWriter eventWriter) {
        StaxEventContentHandler contentHandler = new StaxEventContentHandler((XMLEventConsumer)eventWriter);
        this.marshalSaxHandlers(graph, (ContentHandler)contentHandler, null);
    }

    protected void marshalXmlStreamWriter(Object graph, XMLStreamWriter streamWriter) throws XmlMappingException {
        StaxStreamContentHandler contentHandler = new StaxStreamContentHandler(streamWriter);
        this.marshalSaxHandlers(graph, (ContentHandler)contentHandler, null);
    }

    protected Object unmarshalDomNode(Node node) throws XmlMappingException {
        try {
            XmlObject object = XmlObject.Factory.parse((Node)node, (XmlOptions)this.xmlOptions);
            this.validate(object);
            return object;
        }
        catch (XmlException ex) {
            throw this.convertXmlBeansException((Exception)((Object)ex), false);
        }
    }

    protected Object unmarshalInputStream(InputStream inputStream) throws XmlMappingException, IOException {
        try {
            XmlObject object = XmlObject.Factory.parse((InputStream)inputStream, (XmlOptions)this.xmlOptions);
            this.validate(object);
            return object;
        }
        catch (XmlException ex) {
            throw this.convertXmlBeansException((Exception)((Object)ex), false);
        }
    }

    protected Object unmarshalReader(Reader reader) throws XmlMappingException, IOException {
        try {
            XmlObject object = XmlObject.Factory.parse((Reader)reader, (XmlOptions)this.xmlOptions);
            this.validate(object);
            return object;
        }
        catch (XmlException ex) {
            throw this.convertXmlBeansException((Exception)((Object)ex), false);
        }
    }

    protected Object unmarshalSaxReader(XMLReader xmlReader, InputSource inputSource) throws XmlMappingException, IOException {
        XmlSaxHandler saxHandler = XmlObject.Factory.newXmlSaxHandler((XmlOptions)this.xmlOptions);
        xmlReader.setContentHandler(saxHandler.getContentHandler());
        try {
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", saxHandler.getLexicalHandler());
        }
        catch (SAXNotRecognizedException e) {
        }
        catch (SAXNotSupportedException e) {
            // empty catch block
        }
        try {
            xmlReader.parse(inputSource);
            XmlObject object = saxHandler.getObject();
            this.validate(object);
            return object;
        }
        catch (SAXException ex) {
            throw this.convertXmlBeansException(ex, false);
        }
        catch (XmlException ex) {
            throw this.convertXmlBeansException((Exception)((Object)ex), false);
        }
    }

    protected Object unmarshalXmlEventReader(XMLEventReader eventReader) throws XmlMappingException {
        StaxEventXmlReader reader = new StaxEventXmlReader(eventReader);
        try {
            return this.unmarshalSaxReader((XMLReader)reader, new InputSource());
        }
        catch (IOException ex) {
            throw this.convertXmlBeansException(ex, false);
        }
    }

    protected Object unmarshalXmlStreamReader(XMLStreamReader streamReader) throws XmlMappingException {
        try {
            XmlObject object = XmlObject.Factory.parse((XMLStreamReader)streamReader, (XmlOptions)this.xmlOptions);
            this.validate(object);
            return object;
        }
        catch (XmlException ex) {
            throw this.convertXmlBeansException((Exception)((Object)ex), false);
        }
    }

    public void validate(XmlObject object) throws XmlBeansValidationFailureException {
        if (this.isValidating() && object != null) {
            XmlOptions validateOptions = this.xmlOptions != null ? this.xmlOptions : new XmlOptions();
            ArrayList errorsList = new ArrayList();
            validateOptions.setErrorListener(errorsList);
            if (!object.validate(validateOptions)) {
                StringBuffer buffer = new StringBuffer("Could not validate XmlObject :");
                Iterator iterator = errorsList.iterator();
                while (iterator.hasNext()) {
                    XmlError xmlError = (XmlError)iterator.next();
                    if (!(xmlError instanceof XmlValidationError)) continue;
                    buffer.append(xmlError.toString());
                }
                XmlException ex = new XmlException(buffer.toString(), null, errorsList);
                throw new XmlBeansValidationFailureException(ex);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

