/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.castor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.util.XMLEventConsumer;
import org.castor.mapping.BindingType;
import org.castor.mapping.MappingUnmarshaller;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingLoader;
import org.exolab.castor.xml.ClassDescriptorResolverFactory;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.UnmarshalHandler;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.XMLClassDescriptorResolver;
import org.exolab.castor.xml.XMLException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.oxm.AbstractMarshaller;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.castor.CastorSystemException;
import org.springframework.oxm.castor.CastorUnmarshallingFailureException;
import org.springframework.oxm.castor.CastorUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.xml.dom.DomContentHandler;
import org.springframework.xml.stream.StaxEventContentHandler;
import org.springframework.xml.stream.StaxEventXmlReader;
import org.springframework.xml.stream.StaxStreamContentHandler;
import org.springframework.xml.stream.StaxStreamXmlReader;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class CastorMarshaller
extends AbstractMarshaller
implements InitializingBean {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private Resource[] mappingLocations;
    private String encoding = "UTF-8";
    private Class targetClass;
    private XMLClassDescriptorResolver classDescriptorResolver;
    private boolean validating = false;
    private boolean whitespacePreserve = false;

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public void setWhitespacePreserve(boolean whitespacePreserve) {
        this.whitespacePreserve = whitespacePreserve;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setTargetClass(Class targetClass) {
        this.targetClass = targetClass;
    }

    public void setMappingLocation(Resource mappingLocation) {
        this.mappingLocations = new Resource[]{mappingLocation};
    }

    public void setMappingLocations(Resource[] mappingLocations) {
        this.mappingLocations = mappingLocations;
    }

    public final void afterPropertiesSet() throws IOException {
        if (this.mappingLocations != null && this.targetClass != null) {
            throw new IllegalArgumentException("Cannot set both the 'mappingLocations' and 'targetClass' property. Set targetClass for unmarshalling a single class, and 'mappingLocations' for multiple classes'");
        }
        if (this.logger.isInfoEnabled()) {
            if (this.mappingLocations != null) {
                this.logger.info((Object)("Configured using " + StringUtils.arrayToCommaDelimitedString((Object[])this.mappingLocations)));
            } else if (this.targetClass != null) {
                this.logger.info((Object)("Configured for target class [" + this.targetClass.getName() + "]"));
            } else {
                this.logger.info((Object)"Using default configuration");
            }
        }
        try {
            this.classDescriptorResolver = this.createClassDescriptorResolver(this.mappingLocations, this.targetClass);
        }
        catch (MappingException ex) {
            throw new CastorSystemException("Could not load Castor mapping: " + ex.getMessage(), ex);
        }
    }

    public boolean supports(Class clazz) {
        return true;
    }

    protected XMLClassDescriptorResolver createClassDescriptorResolver(Resource[] mappingLocations, Class targetClass) throws MappingException, IOException {
        XMLClassDescriptorResolver classDescriptorResolver = (XMLClassDescriptorResolver)ClassDescriptorResolverFactory.createClassDescriptorResolver((BindingType)BindingType.XML);
        if (!ObjectUtils.isEmpty((Object[])mappingLocations)) {
            Mapping mapping = new Mapping();
            for (int i = 0; i < mappingLocations.length; ++i) {
                mapping.loadMapping(new InputSource(mappingLocations[i].getInputStream()));
            }
            MappingUnmarshaller mappingUnmarshaller = new MappingUnmarshaller();
            MappingLoader mappingLoader = mappingUnmarshaller.getMappingLoader(mapping, BindingType.XML);
            classDescriptorResolver.setMappingLoader(mappingLoader);
            classDescriptorResolver.setClassLoader(mapping.getClassLoader());
        } else if (targetClass != null) {
            classDescriptorResolver.setClassLoader(targetClass.getClassLoader());
        }
        return classDescriptorResolver;
    }

    public XmlMappingException convertCastorException(XMLException ex, boolean marshalling) {
        return CastorUtils.convertXmlException(ex, marshalling);
    }

    private Unmarshaller createUnmarshaller() {
        Unmarshaller unmarshaller = null;
        unmarshaller = this.targetClass != null ? new Unmarshaller(this.targetClass) : new Unmarshaller();
        unmarshaller.setResolver(this.classDescriptorResolver);
        unmarshaller.setValidation(this.validating);
        unmarshaller.setWhitespacePreserve(this.whitespacePreserve);
        return unmarshaller;
    }

    private void marshal(Object graph, Marshaller marshaller) {
        try {
            marshaller.setResolver(this.classDescriptorResolver);
            marshaller.marshal(graph);
        }
        catch (XMLException ex) {
            throw this.convertCastorException(ex, true);
        }
    }

    protected void marshalDomNode(Object graph, Node node) throws XmlMappingException {
        DomContentHandler contentHandler = new DomContentHandler(node);
        this.marshalSaxHandlers(graph, (ContentHandler)contentHandler, null);
    }

    protected void marshalXmlEventWriter(Object graph, XMLEventWriter eventWriter) throws XmlMappingException {
        StaxEventContentHandler contentHandler = new StaxEventContentHandler((XMLEventConsumer)eventWriter);
        this.marshalSaxHandlers(graph, (ContentHandler)contentHandler, null);
    }

    protected void marshalXmlStreamWriter(Object graph, XMLStreamWriter streamWriter) throws XmlMappingException {
        StaxStreamContentHandler contentHandler = new StaxStreamContentHandler(streamWriter);
        this.marshalSaxHandlers(graph, (ContentHandler)contentHandler, null);
    }

    protected void marshalOutputStream(Object graph, OutputStream outputStream) throws XmlMappingException, IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, this.encoding);
        this.marshalWriter(graph, writer);
    }

    protected void marshalSaxHandlers(Object graph, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws XmlMappingException {
        try {
            Marshaller marshaller = new Marshaller(contentHandler);
            this.marshal(graph, marshaller);
        }
        catch (IOException ex) {
            throw new CastorSystemException("Could not construct Castor ContentHandler Marshaller", ex);
        }
    }

    protected void marshalWriter(Object graph, Writer writer) throws XmlMappingException, IOException {
        Marshaller marshaller = new Marshaller(writer);
        this.marshal(graph, marshaller);
    }

    protected Object unmarshalDomNode(Node node) throws XmlMappingException {
        try {
            return this.createUnmarshaller().unmarshal(node);
        }
        catch (XMLException ex) {
            throw this.convertCastorException(ex, false);
        }
    }

    protected Object unmarshalXmlEventReader(XMLEventReader eventReader) {
        StaxEventXmlReader reader = new StaxEventXmlReader(eventReader);
        try {
            return this.unmarshalSaxReader((XMLReader)reader, new InputSource());
        }
        catch (IOException ex) {
            throw new CastorUnmarshallingFailureException(new MarshalException((Throwable)ex));
        }
    }

    protected Object unmarshalXmlStreamReader(XMLStreamReader streamReader) {
        StaxStreamXmlReader reader = new StaxStreamXmlReader(streamReader);
        try {
            return this.unmarshalSaxReader((XMLReader)reader, new InputSource());
        }
        catch (IOException ex) {
            throw new CastorUnmarshallingFailureException(new MarshalException((Throwable)ex));
        }
    }

    protected Object unmarshalSaxReader(XMLReader xmlReader, InputSource inputSource) throws XmlMappingException, IOException {
        UnmarshalHandler unmarshalHandler = this.createUnmarshaller().createHandler();
        try {
            ContentHandler contentHandler = Unmarshaller.getContentHandler((UnmarshalHandler)unmarshalHandler);
            xmlReader.setContentHandler(contentHandler);
            xmlReader.parse(inputSource);
            return unmarshalHandler.getObject();
        }
        catch (SAXException ex) {
            throw new CastorUnmarshallingFailureException(ex);
        }
    }

    protected Object unmarshalInputStream(InputStream inputStream) throws XmlMappingException, IOException {
        try {
            return this.createUnmarshaller().unmarshal(new InputSource(inputStream));
        }
        catch (XMLException ex) {
            throw this.convertCastorException(ex, false);
        }
    }

    protected Object unmarshalReader(Reader reader) throws XmlMappingException, IOException {
        try {
            return this.createUnmarshaller().unmarshal(new InputSource(reader));
        }
        catch (XMLException ex) {
            throw this.convertCastorException(ex, false);
        }
    }
}

