/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class ExchangeMutatorWebFilter
implements WebFilter {
    private final Function<ServerWebExchange, ServerWebExchange> processor;
    private final Map<String, Function<ServerWebExchange, ServerWebExchange>> perRequestProcessors = new ConcurrentHashMap<String, Function<ServerWebExchange, ServerWebExchange>>(4);

    public ExchangeMutatorWebFilter() {
        this(exchange -> exchange);
    }

    public ExchangeMutatorWebFilter(Function<ServerWebExchange, ServerWebExchange> processor) {
        Assert.notNull(processor, (String)"'processor' is required");
        this.processor = processor;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        exchange = this.getProcessor(exchange).apply(exchange);
        return chain.filter(exchange);
    }

    private Function<ServerWebExchange, ServerWebExchange> getProcessor(ServerWebExchange exchange) {
        String id = this.getRequestId(exchange.getRequest().getHeaders());
        Function<ServerWebExchange, ServerWebExchange> clientMutator = this.perRequestProcessors.remove(id);
        return clientMutator != null ? this.processor.andThen(clientMutator) : this.processor;
    }

    private String getRequestId(HttpHeaders headers) {
        String id = headers.getFirst("WebTestClient-Request-Id");
        Assert.notNull((Object)id, (String)"No \"WebTestClient-Request-Id\" header");
        return id;
    }

    public ExchangeFilterFunction perClient(Function<ServerWebExchange, ServerWebExchange> processor) {
        return (request, next) -> {
            String id = this.getRequestId(request.headers());
            this.perRequestProcessors.compute(id, (s, value) -> value != null ? value.andThen(processor) : processor);
            return next.exchange(request);
        };
    }
}

