/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.web.server;

import java.util.ArrayList;
import java.util.Optional;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authorization.AuthenticatedAuthorizationManager;
import org.springframework.security.authorization.AuthorityAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.config.web.server.AbstractServerWebExchangeMatcherRegistry;
import org.springframework.security.config.web.server.HeaderBuilder;
import org.springframework.security.config.web.server.HttpBasicBuilder;
import org.springframework.security.web.server.MatcherSecurityWebFilterChain;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.authorization.AuthorizationContext;
import org.springframework.security.web.server.authorization.AuthorizationWebFilter;
import org.springframework.security.web.server.authorization.DelegatingReactiveAuthorizationManager;
import org.springframework.security.web.server.authorization.ExceptionTranslationWebFilter;
import org.springframework.security.web.server.context.SecurityContextRepository;
import org.springframework.security.web.server.context.SecurityContextRepositoryWebFilter;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcherEntry;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.util.Assert;
import org.springframework.web.server.WebFilter;
import reactor.core.publisher.Mono;

public class HttpSecurity {
    private ServerWebExchangeMatcher securityMatcher = ServerWebExchangeMatchers.anyExchange();
    private AuthorizeExchangeBuilder authorizeExchangeBuilder;
    private HeaderBuilder headers = new HeaderBuilder();
    private HttpBasicBuilder httpBasic;
    private ReactiveAuthenticationManager authenticationManager;
    private Optional<SecurityContextRepository> securityContextRepository = Optional.empty();

    public HttpSecurity securityMatcher(ServerWebExchangeMatcher matcher) {
        Assert.notNull((Object)matcher, (String)"matcher cannot be null");
        this.securityMatcher = matcher;
        return this;
    }

    private ServerWebExchangeMatcher getSecurityMatcher() {
        return this.securityMatcher;
    }

    public HttpSecurity securityContextRepository(SecurityContextRepository securityContextRepository) {
        Assert.notNull((Object)securityContextRepository, (String)"securityContextRepository cannot be null");
        this.securityContextRepository = Optional.of(securityContextRepository);
        return this;
    }

    public HttpBasicBuilder httpBasic() {
        if (this.httpBasic == null) {
            this.httpBasic = new HttpBasicBuilder();
        }
        return this.httpBasic;
    }

    public HeaderBuilder headers() {
        return this.headers;
    }

    public AuthorizeExchangeBuilder authorizeExchange() {
        if (this.authorizeExchangeBuilder == null) {
            this.authorizeExchangeBuilder = new AuthorizeExchangeBuilder();
        }
        return this.authorizeExchangeBuilder;
    }

    public HttpSecurity authenticationManager(ReactiveAuthenticationManager manager) {
        this.authenticationManager = manager;
        return this;
    }

    public SecurityWebFilterChain build() {
        ArrayList<Object> filters = new ArrayList<Object>();
        if (this.headers != null) {
            filters.add(this.headers.build());
        }
        this.securityContextRepositoryWebFilter().ifPresent(f -> filters.add(f));
        if (this.httpBasic != null) {
            this.httpBasic.authenticationManager(this.authenticationManager);
            this.securityContextRepository.ifPresent(scr -> this.httpBasic.securityContextRepository((SecurityContextRepository)scr));
            filters.add(this.httpBasic.build());
        }
        if (this.authorizeExchangeBuilder != null) {
            filters.add(new ExceptionTranslationWebFilter());
            filters.add(this.authorizeExchangeBuilder.build());
        }
        return new MatcherSecurityWebFilterChain(this.getSecurityMatcher(), filters);
    }

    public static HttpSecurity http() {
        return new HttpSecurity();
    }

    private Optional<SecurityContextRepositoryWebFilter> securityContextRepositoryWebFilter() {
        return this.securityContextRepository.flatMap(r -> Optional.of(new SecurityContextRepositoryWebFilter(r)));
    }

    private HttpSecurity() {
    }

    public class AuthorizeExchangeBuilder
    extends AbstractServerWebExchangeMatcherRegistry<Access> {
        private DelegatingReactiveAuthorizationManager.Builder managerBldr = DelegatingReactiveAuthorizationManager.builder();
        private ServerWebExchangeMatcher matcher;
        private boolean anyExchangeRegistered;

        public HttpSecurity and() {
            return HttpSecurity.this;
        }

        @Override
        public Access anyExchange() {
            Access result = (Access)super.anyExchange();
            this.anyExchangeRegistered = true;
            return result;
        }

        @Override
        protected Access registerMatcher(ServerWebExchangeMatcher matcher) {
            if (this.anyExchangeRegistered) {
                throw new IllegalStateException("Cannot register " + matcher + " which would be unreachable because anyExchange() has already been registered.");
            }
            if (this.matcher != null) {
                throw new IllegalStateException("The matcher " + matcher + " does not have an access rule defined");
            }
            this.matcher = matcher;
            return new Access();
        }

        protected WebFilter build() {
            if (this.matcher != null) {
                throw new IllegalStateException("The matcher " + this.matcher + " does not have an access rule defined");
            }
            return new AuthorizationWebFilter((ReactiveAuthorizationManager)this.managerBldr.build());
        }

        public final class Access {
            public AuthorizeExchangeBuilder permitAll() {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)((ReactiveAuthorizationManager)(a, e) -> Mono.just((Object)new AuthorizationDecision(true))));
            }

            public AuthorizeExchangeBuilder denyAll() {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)((ReactiveAuthorizationManager)(a, e) -> Mono.just((Object)new AuthorizationDecision(false))));
            }

            public AuthorizeExchangeBuilder hasRole(String role) {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)AuthorityAuthorizationManager.hasRole((String)role));
            }

            public AuthorizeExchangeBuilder hasAuthority(String authority) {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)AuthorityAuthorizationManager.hasAuthority((String)authority));
            }

            public AuthorizeExchangeBuilder authenticated() {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)AuthenticatedAuthorizationManager.authenticated());
            }

            public AuthorizeExchangeBuilder access(ReactiveAuthorizationManager<AuthorizationContext> manager) {
                AuthorizeExchangeBuilder.this.managerBldr.add(new ServerWebExchangeMatcherEntry(AuthorizeExchangeBuilder.this.matcher, manager));
                AuthorizeExchangeBuilder.this.matcher = null;
                return AuthorizeExchangeBuilder.this;
            }
        }
    }

    public class HttpBasicSpec
    extends HttpBasicBuilder {
        public HttpSecurity disable() {
            HttpSecurity.this.httpBasic = null;
            return HttpSecurity.this;
        }
    }
}

