/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.web.server;

import java.util.function.Function;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.web.server.AuthenticationEntryPoint;
import org.springframework.security.web.server.HttpBasicAuthenticationConverter;
import org.springframework.security.web.server.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.AuthenticationWebFilter;
import org.springframework.security.web.server.authentication.DefaultAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.www.HttpBasicAuthenticationEntryPoint;
import org.springframework.security.web.server.context.SecurityContextRepository;

public class HttpBasicBuilder {
    private ReactiveAuthenticationManager authenticationManager;
    private SecurityContextRepository securityContextRepository;
    private AuthenticationEntryPoint entryPoint = new HttpBasicAuthenticationEntryPoint();

    public HttpBasicBuilder authenticationManager(ReactiveAuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
        return this;
    }

    public HttpBasicBuilder securityContextRepository(SecurityContextRepository securityContextRepository) {
        this.securityContextRepository = securityContextRepository;
        return this;
    }

    public AuthenticationWebFilter build() {
        AuthenticationWebFilter authenticationFilter = new AuthenticationWebFilter(this.authenticationManager);
        authenticationFilter.setEntryPoint(this.entryPoint);
        authenticationFilter.setAuthenticationConverter((Function)new HttpBasicAuthenticationConverter());
        if (this.securityContextRepository != null) {
            DefaultAuthenticationSuccessHandler handler = new DefaultAuthenticationSuccessHandler();
            handler.setSecurityContextRepository(this.securityContextRepository);
            authenticationFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)handler);
        }
        return authenticationFilter;
    }
}

