/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation.support;

import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class EmbeddedServiceConfigurationSupport
implements ImportBeanDefinitionRegistrar {
    protected static Properties setProperty(Properties properties, String key, Object value) {
        if (value != null) {
            EmbeddedServiceConfigurationSupport.setProperty(properties, key, value.toString());
        }
        return properties;
    }

    protected static Properties setProperty(Properties properties, String key, String value) {
        Assert.notNull((Object)properties, (String)"Properties must not be null");
        Assert.hasText((String)key, (String)"Key must not be null or empty");
        if (StringUtils.hasText((String)value)) {
            properties.setProperty(key, value);
        }
        return properties;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Map annotationAttributes;
        Properties customizedGemFireProperties;
        if (importingClassMetadata.hasAnnotation(this.getAnnotationTypeName()) && !CollectionUtils.isEmpty((Map)(customizedGemFireProperties = this.toGemFireProperties(annotationAttributes = importingClassMetadata.getAnnotationAttributes(this.getAnnotationTypeName()))))) {
            this.registerGemFirePropertiesBeanPostProcessor(registry, customizedGemFireProperties);
        }
    }

    protected String getAnnotationTypeName() {
        return this.getAnnotationType().getName();
    }

    protected String getAnnotationTypeSimpleName() {
        return this.getAnnotationType().getSimpleName();
    }

    protected abstract Class getAnnotationType();

    protected String getBeanName() {
        return String.format("%1$s.%2$s", this.getClass().getName(), this.getAnnotationTypeSimpleName());
    }

    protected BeanDefinitionHolder newBeanDefinitionHolder(BeanDefinitionBuilder builder) {
        return new BeanDefinitionHolder((BeanDefinition)builder.getBeanDefinition(), this.getBeanName());
    }

    protected abstract Properties toGemFireProperties(Map<String, Object> var1);

    protected void registerGemFirePropertiesBeanPostProcessor(BeanDefinitionRegistry registry, Properties customizedGemFireProperties) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(GemFirePropertiesBeanPostProcessor.class);
        builder.addConstructorArgValue((Object)customizedGemFireProperties);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)this.newBeanDefinitionHolder(builder), (BeanDefinitionRegistry)registry);
    }

    protected static class GemFirePropertiesBeanPostProcessor
    implements BeanPostProcessor {
        static final String GEMFIRE_PROPERTIES_BEAN_NAME = "gemfireProperties";
        private final Properties gemfireProperties;

        protected GemFirePropertiesBeanPostProcessor(Properties gemfireProperties) {
            Assert.notEmpty((Map)gemfireProperties, (String)"GemFire Properties must not be null or empty");
            this.gemfireProperties = gemfireProperties;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof Properties && GEMFIRE_PROPERTIES_BEAN_NAME.equals(beanName)) {
                Properties gemfirePropertiesBean = (Properties)bean;
                gemfirePropertiesBean.putAll((Map<?, ?>)this.gemfireProperties);
            }
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }
    }
}

