/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.metric.SpanMetricReporter;
import org.springframework.cloud.sleuth.zipkin.ZipkinSpanReporter;
import zipkin.Codec;
import zipkin.Span;

public final class HttpZipkinSpanReporter
implements ZipkinSpanReporter,
Flushable,
Closeable {
    private static final Log log = LogFactory.getLog(HttpZipkinSpanReporter.class);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final String url;
    private final BlockingQueue<Span> pending = new LinkedBlockingQueue<Span>(1000);
    private final Flusher flusher;
    private final boolean compressionEnabled;
    private final SpanMetricReporter spanMetricReporter;

    public HttpZipkinSpanReporter(String baseUrl, int flushInterval, boolean compressionEnabled, SpanMetricReporter spanMetricReporter) {
        this.url = String.valueOf(baseUrl) + (baseUrl.endsWith("/") ? "" : "/") + "api/v1/spans";
        this.flusher = flushInterval > 0 ? new Flusher(this, flushInterval) : null;
        this.compressionEnabled = compressionEnabled;
        this.spanMetricReporter = spanMetricReporter;
    }

    @Override
    public void report(Span span) {
        this.spanMetricReporter.incrementAcceptedSpans(1L);
        if (!this.pending.offer(span)) {
            this.spanMetricReporter.incrementDroppedSpans(1L);
        }
    }

    @Override
    public void flush() {
        if (this.pending.isEmpty()) {
            return;
        }
        ArrayList drained = new ArrayList(this.pending.size());
        this.pending.drainTo(drained);
        if (drained.isEmpty()) {
            return;
        }
        byte[] json = Codec.JSON.writeSpans(drained);
        if (json == null) {
            log.debug((Object)("failed to encode spans, dropping them: " + drained));
            this.spanMetricReporter.incrementDroppedSpans((long)drained.size());
            return;
        }
        try {
            this.postSpans(json);
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("error POSTing spans to " + this.url + ": as json: " + new String(json, UTF_8)), (Throwable)e);
            }
            this.spanMetricReporter.incrementDroppedSpans((long)drained.size());
        }
    }

    void postSpans(byte[] json) throws IOException {
        block34: {
            Object var5_10;
            Throwable throwable;
            Object gzipped;
            HttpURLConnection connection = (HttpURLConnection)new URL(this.url).openConnection();
            connection.setRequestMethod("POST");
            connection.addRequestProperty("Content-Type", "application/json");
            if (this.compressionEnabled) {
                connection.addRequestProperty("Content-Encoding", "gzip");
                gzipped = new ByteArrayOutputStream();
                throwable = null;
                var5_10 = null;
                try (GZIPOutputStream compressor = new GZIPOutputStream((OutputStream)gzipped);){
                    compressor.write(json);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                json = ((ByteArrayOutputStream)gzipped).toByteArray();
            }
            connection.setDoOutput(true);
            connection.setFixedLengthStreamingMode(json.length);
            connection.getOutputStream().write(json);
            try {
                gzipped = null;
                throwable = null;
                try (InputStream in = connection.getInputStream();){
                    while (in.read() != -1) {
                    }
                    break block34;
                }
                catch (Throwable throwable3) {
                    if (gzipped == null) {
                        gzipped = throwable3;
                    } else if (gzipped != throwable3) {
                        ((Throwable)gzipped).addSuppressed(throwable3);
                    }
                    throw gzipped;
                }
            }
            catch (IOException e) {
                throwable = null;
                var5_10 = null;
                try (InputStream err = connection.getErrorStream();){
                    if (err != null) {
                        while (err.read() != -1) {
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            throw e;
        }
    }

    @Override
    public void close() {
        if (this.flusher != null) {
            this.flusher.scheduler.shutdown();
        }
        int dropped = this.pending.drainTo(new LinkedList());
        this.spanMetricReporter.incrementDroppedSpans((long)dropped);
    }

    static final class Flusher
    implements Runnable {
        final Flushable flushable;
        final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

        Flusher(Flushable flushable, int flushInterval) {
            this.flushable = flushable;
            this.scheduler.scheduleWithFixedDelay(this, 0L, flushInterval, TimeUnit.SECONDS);
        }

        @Override
        public void run() {
            try {
                this.flushable.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

