/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.config.server.config.ConfigServerHealthIndicator;
import org.springframework.cloud.config.server.config.DefaultRepositoryConfiguration;
import org.springframework.cloud.config.server.config.GitRepositoryConfiguration;
import org.springframework.cloud.config.server.config.NativeRepositoryConfiguration;
import org.springframework.cloud.config.server.config.SvnRepositoryConfiguration;
import org.springframework.cloud.config.server.config.VaultRepositoryConfiguration;
import org.springframework.cloud.config.server.environment.ConsulEnvironmentWatch;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentWatch;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={VaultRepositoryConfiguration.class, SvnRepositoryConfiguration.class, NativeRepositoryConfiguration.class, GitRepositoryConfiguration.class, DefaultRepositoryConfiguration.class})
public class EnvironmentRepositoryConfiguration {
    @Bean
    @ConditionalOnProperty(value={"spring.cloud.config.server.health.enabled"}, matchIfMissing=true)
    public ConfigServerHealthIndicator configServerHealthIndicator(EnvironmentRepository repository) {
        return new ConfigServerHealthIndicator(repository);
    }

    @Configuration
    @ConditionalOnMissingBean(value={EnvironmentWatch.class})
    protected static class DefaultEnvironmentWatch {
        protected DefaultEnvironmentWatch() {
        }

        @Bean
        public EnvironmentWatch environmentWatch() {
            return new EnvironmentWatch.Default();
        }
    }

    @Configuration
    @ConditionalOnProperty(value={"spring.cloud.config.server.consul.watch.enabled"})
    protected static class ConsulEnvironmentWatchConfiguration {
        protected ConsulEnvironmentWatchConfiguration() {
        }

        @Bean
        public EnvironmentWatch environmentWatch() {
            return new ConsulEnvironmentWatch();
        }
    }
}

