/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.progress.MockingProgress;
import org.mockito.internal.stubbing.InvocationContainer;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.verification.MockAwareVerificationMode;
import org.mockito.verification.VerificationMode;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.util.AopTestUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class MockitoAopProxyTargetInterceptor
implements MethodInterceptor {
    private final Object source;
    private final Object target;
    private final Verification verification;

    MockitoAopProxyTargetInterceptor(Object source, Object target) throws Exception {
        this.source = source;
        this.target = target;
        this.verification = new Verification(target);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.verification.isVerifying()) {
            this.verification.replaceVerifyMock(this.source, this.target);
            return AopUtils.invokeJoinpointUsingReflection((Object)this.target, (Method)invocation.getMethod(), (Object[])invocation.getArguments());
        }
        return invocation.proceed();
    }

    @Autowired
    public static void applyTo(Object source) {
        Assert.state((boolean)AopUtils.isAopProxy((Object)source), (String)"Source must be an AOP proxy");
        try {
            Advised advised = (Advised)source;
            for (Advisor advisor : advised.getAdvisors()) {
                if (!(advisor instanceof MockitoAopProxyTargetInterceptor)) continue;
                return;
            }
            Object target = AopTestUtils.getUltimateTargetObject((Object)source);
            MockitoAopProxyTargetInterceptor advice = new MockitoAopProxyTargetInterceptor(source, target);
            advised.addAdvice(0, (Advice)advice);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to apply Mockito AOP support", ex);
        }
    }

    private static class Verification {
        private final MockingProgress progress;

        Verification(Object target) {
            MockUtil mockUtil = new MockUtil();
            InternalMockHandler handler = mockUtil.getMockHandler(target);
            InvocationContainer container = handler.getInvocationContainer();
            Field field = ReflectionUtils.findField(container.getClass(), (String)"mockingProgress");
            ReflectionUtils.makeAccessible((Field)field);
            this.progress = (MockingProgress)ReflectionUtils.getField((Field)field, (Object)container);
        }

        public synchronized boolean isVerifying() {
            VerificationMode mode = this.progress.pullVerificationMode();
            if (mode != null) {
                this.progress.verificationStarted(mode);
                return true;
            }
            return false;
        }

        public synchronized void replaceVerifyMock(Object source, Object target) {
            VerificationMode mode = this.progress.pullVerificationMode();
            if (mode != null) {
                MockAwareVerificationMode mockAwareMode;
                if (mode instanceof MockAwareVerificationMode && (mockAwareMode = (MockAwareVerificationMode)mode).getMock() == source) {
                    mode = new MockAwareVerificationMode(target, (VerificationMode)mockAwareMode);
                }
                this.progress.verificationStarted(mode);
            }
        }
    }
}

