/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import java.io.File;
import java.io.InputStream;
import org.springframework.boot.test.json.JsonContent;
import org.springframework.boot.test.json.JsonLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class BasicJsonTester {
    private final JsonLoader loader;

    public BasicJsonTester(Class<?> resourceLoadClass) {
        Assert.notNull(resourceLoadClass, (String)"ResourceLoadClass must not be null");
        this.loader = new JsonLoader(resourceLoadClass);
    }

    public JsonContent<Object> from(CharSequence source) {
        return this.getJsonContent(this.loader.getJson(source));
    }

    public JsonContent<Object> from(String path, Class<?> resourceLoadClass) {
        return this.getJsonContent(this.loader.getJson(path, resourceLoadClass));
    }

    public JsonContent<Object> from(byte[] source) {
        return this.getJsonContent(this.loader.getJson(source));
    }

    public JsonContent<Object> from(File source) {
        return this.getJsonContent(this.loader.getJson(source));
    }

    public JsonContent<Object> from(InputStream source) {
        return this.getJsonContent(this.loader.getJson(source));
    }

    public JsonContent<Object> from(Resource source) {
        return this.getJsonContent(this.loader.getJson(source));
    }

    private JsonContent<Object> getJsonContent(String json) {
        return new JsonContent<Object>(this.loader.getResourceLoadClass(), null, json);
    }
}

