/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.web.servlet;

import com.gargoylesoftware.htmlunit.WebClient;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.test.autoconfigure.web.servlet.MockMvcAutoConfiguration;
import org.springframework.boot.test.web.htmlunit.LocalHostWebClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.htmlunit.MockMvcWebClientBuilder;

@Configuration
@ConditionalOnClass(value={WebClient.class})
@AutoConfigureAfter(value={MockMvcAutoConfiguration.class})
@ConditionalOnProperty(prefix="spring.test.webmvc.webclient", name={"enabled"}, matchIfMissing=true)
class MockMvcWebClientAutoConfiguration {
    private final Environment environment;

    MockMvcWebClientAutoConfiguration(Environment environment) {
        this.environment = environment;
    }

    @Bean
    @ConditionalOnMissingBean(value={WebClient.class, MockMvcWebClientBuilder.class})
    @ConditionalOnBean(value={MockMvc.class})
    public MockMvcWebClientBuilder mockMvcWebClientBuilder(MockMvc mockMvc) {
        return MockMvcWebClientBuilder.mockMvcSetup((MockMvc)mockMvc).withDelegate((WebClient)new LocalHostWebClient(this.environment));
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={MockMvcWebClientBuilder.class})
    public WebClient htmlUnitWebClient(MockMvcWebClientBuilder builder) {
        return builder.build();
    }
}

