/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.filter;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.boot.context.TypeExcludeFilter;
import org.springframework.boot.test.autoconfigure.filter.TypeExcludeFilters;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.ReflectionUtils;

class TypeExcludeFiltersContextCustomizer
implements ContextCustomizer {
    private static final String EXCLUDE_FILTER_BEAN_NAME = TypeExcludeFilters.class.getName();
    private final Class<?> testClass;
    private final Set<Class<? extends TypeExcludeFilter>> filterClasses;

    TypeExcludeFiltersContextCustomizer(Class<?> testClass, Set<Class<? extends TypeExcludeFilter>> filterClasses) {
        this.testClass = testClass;
        this.filterClasses = filterClasses;
    }

    public int hashCode() {
        return this.filterClasses.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass()) && this.filterClasses.equals(((TypeExcludeFiltersContextCustomizer)obj).filterClasses);
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedContextConfiguration) {
        if (!this.filterClasses.isEmpty()) {
            context.getBeanFactory().registerSingleton(EXCLUDE_FILTER_BEAN_NAME, (Object)this.createDelegatingTypeExcludeFilter());
        }
    }

    private TypeExcludeFilter createDelegatingTypeExcludeFilter() {
        final LinkedHashSet<TypeExcludeFilter> filters = new LinkedHashSet<TypeExcludeFilter>(this.filterClasses.size());
        for (Class<? extends TypeExcludeFilter> filterClass : this.filterClasses) {
            filters.add(this.createTypeExcludeFilter(filterClass));
        }
        return new TypeExcludeFilter(){

            public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
                for (TypeExcludeFilter filter : filters) {
                    if (!filter.match(metadataReader, metadataReaderFactory)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private TypeExcludeFilter createTypeExcludeFilter(Class<?> type) {
        try {
            Constructor<?> constructor = this.getTypeExcludeFilterConstructor(type);
            ReflectionUtils.makeAccessible(constructor);
            if (constructor.getParameterTypes().length == 1) {
                return (TypeExcludeFilter)constructor.newInstance(this.testClass);
            }
            return (TypeExcludeFilter)constructor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to create filter for " + type, ex);
        }
    }

    private Constructor<?> getTypeExcludeFilterConstructor(Class<?> type) throws NoSuchMethodException {
        try {
            return type.getDeclaredConstructor(Class.class);
        }
        catch (Exception ex) {
            return type.getDeclaredConstructor(new Class[0]);
        }
    }
}

