/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationEventPublisher;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.DefaultAuthenticationEventPublisher;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.SecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfiguration;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.servlet.configuration.EnableWebMvcSecurity;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.writers.HstsHeaderWriter;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.web.servlet.support.RequestDataValueProcessor;

@Configuration
@EnableConfigurationProperties
@ConditionalOnClass(value={EnableWebSecurity.class})
@ConditionalOnMissingBean(value={WebSecurityConfiguration.class})
@ConditionalOnWebApplication
public class SpringBootWebSecurityConfiguration {
    private static List<String> DEFAULT_IGNORED = Arrays.asList("/css/**", "/js/**", "/images/**", "/**/favicon.ico");

    @Bean
    @ConditionalOnMissingBean
    public AuthenticationEventPublisher authenticationEventPublisher() {
        return new DefaultAuthenticationEventPublisher();
    }

    @Bean
    @ConditionalOnMissingBean(value={IgnoredPathsWebSecurityConfigurerAdapter.class})
    @ConditionalOnBean(value={SpringBootWebSecurityConfiguration.class})
    public SecurityConfigurer<Filter, WebSecurity> ignoredPathsWebSecurityConfigurerAdapter() {
        return new IgnoredPathsWebSecurityConfigurerAdapter();
    }

    public static void configureHeaders(HeadersConfigurer<?> configurer, SecurityProperties.Headers headers) throws Exception {
        if (headers.getHsts() != SecurityProperties.Headers.HSTS.none) {
            boolean includeSubdomains = headers.getHsts() == SecurityProperties.Headers.HSTS.all;
            HstsHeaderWriter writer = new HstsHeaderWriter(includeSubdomains);
            writer.setRequestMatcher(AnyRequestMatcher.INSTANCE);
            configurer.addHeaderWriter((HeaderWriter)writer);
        }
        if (headers.isContentType()) {
            configurer.contentTypeOptions();
        }
        if (headers.isXss()) {
            configurer.xssProtection();
        }
        if (headers.isCache()) {
            configurer.cacheControl();
        }
        if (headers.isFrame()) {
            configurer.frameOptions();
        }
    }

    public static List<String> getIgnored(SecurityProperties security) {
        ArrayList<String> ignored = new ArrayList<String>(security.getIgnored());
        if (ignored.isEmpty()) {
            ignored.addAll(DEFAULT_IGNORED);
        } else if (ignored.contains("none")) {
            ignored.remove("none");
        }
        return ignored;
    }

    @ConditionalOnExpression(value="${security.basic.enabled:true}")
    @Configuration
    @Order(value=0x7FFFFFFA)
    protected static class ApplicationWebSecurityConfigurerAdapter
    extends WebSecurityConfigurerAdapter {
        @Autowired
        private SecurityProperties security;
        @Autowired
        private AuthenticationEventPublisher authenticationEventPublisher;

        protected ApplicationWebSecurityConfigurerAdapter() {
        }

        protected void configure(HttpSecurity http) throws Exception {
            if (this.security.isRequireSsl()) {
                ((ChannelSecurityConfigurer.RequiresChannelUrl)http.requiresChannel().anyRequest()).requiresSecure();
            }
            String[] paths = this.getSecureApplicationPaths();
            if (this.security.getBasic().isEnabled() && paths.length > 0) {
                http.exceptionHandling().authenticationEntryPoint(this.entryPoint());
                http.requestMatchers().antMatchers(paths);
                ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).hasAnyRole(this.security.getUser().getRole().toArray(new String[0])).and()).httpBasic().and()).anonymous().disable();
            }
            if (!this.security.isEnableCsrf()) {
                http.csrf().disable();
            }
            http.sessionManagement().sessionCreationPolicy(this.security.getSessions());
            SpringBootWebSecurityConfiguration.configureHeaders(http.headers(), this.security.getHeaders());
        }

        private String[] getSecureApplicationPaths() {
            ArrayList<String> list = new ArrayList<String>();
            for (String path : this.security.getBasic().getPath()) {
                String string = path = path == null ? "" : path.trim();
                if (path.equals("/**")) {
                    return new String[]{path};
                }
                if (path.equals("")) continue;
                list.add(path);
            }
            return list.toArray(new String[list.size()]);
        }

        private AuthenticationEntryPoint entryPoint() {
            BasicAuthenticationEntryPoint entryPoint = new BasicAuthenticationEntryPoint();
            entryPoint.setRealmName(this.security.getBasic().getRealm());
            return entryPoint;
        }

        protected AuthenticationManager authenticationManager() throws Exception {
            AuthenticationManager manager = super.authenticationManager();
            if (manager instanceof ProviderManager) {
                ((ProviderManager)manager).setAuthenticationEventPublisher(this.authenticationEventPublisher);
            }
            return manager;
        }
    }

    @ConditionalOnMissingBean(value={WebMvcSecurityConfigurationConditions.class})
    @ConditionalOnMissingClass(name={"org.springframework.web.servlet.support.RequestDataValueProcessor"})
    @ConditionalOnExpression(value="${security.basic.enabled:true}")
    @Configuration
    @EnableWebSecurity
    protected static class DefaultWebSecurityConfiguration {
        protected DefaultWebSecurityConfiguration() {
        }
    }

    @ConditionalOnClass(value={RequestDataValueProcessor.class})
    @ConditionalOnMissingBean(value={RequestDataValueProcessor.class})
    @ConditionalOnExpression(value="${security.basic.enabled:true}")
    @Configuration
    protected static class WebMvcSecurityConfigurationConditions {
        protected WebMvcSecurityConfigurationConditions() {
        }

        @Configuration
        @EnableWebMvcSecurity
        protected static class DefaultWebMvcSecurityConfiguration {
            protected DefaultWebMvcSecurityConfiguration() {
            }
        }
    }

    @Order(value=-2147483648)
    private static class IgnoredPathsWebSecurityConfigurerAdapter
    implements SecurityConfigurer<Filter, WebSecurity> {
        @Autowired
        private SecurityProperties security;

        private IgnoredPathsWebSecurityConfigurerAdapter() {
        }

        public void configure(WebSecurity builder) throws Exception {
        }

        public void init(WebSecurity builder) throws Exception {
            WebSecurity.IgnoredRequestConfigurer ignoring = builder.ignoring();
            List<String> ignored = SpringBootWebSecurityConfiguration.getIgnored(this.security);
            ignoring.antMatchers(ignored.toArray(new String[0]));
        }
    }
}

