/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security;

import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.SecurityPrequisite;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.InMemoryUserDetailsManagerConfigurer;

@Configuration
@ConditionalOnBean(value={ObjectPostProcessor.class})
@ConditionalOnMissingBean(value={AuthenticationManager.class})
public class AuthenticationManagerConfiguration {
    private static Log logger = LogFactory.getLog(AuthenticationManagerConfiguration.class);
    @Autowired
    private SecurityProperties security;
    @Autowired
    private List<SecurityPrequisite> dependencies;

    @Bean
    public AuthenticationManager authenticationManager(ObjectPostProcessor<Object> objectPostProcessor) throws Exception {
        InMemoryUserDetailsManagerConfigurer builder = new AuthenticationManagerBuilder(objectPostProcessor).inMemoryAuthentication();
        SecurityProperties.User user = this.security.getUser();
        if (user.isDefaultPassword()) {
            logger.info((Object)("\n\nUsing default password for application endpoints: " + user.getPassword() + "\n\n"));
        }
        LinkedHashSet<String> roles = new LinkedHashSet<String>(user.getRole());
        builder.withUser(user.getName()).password(user.getPassword()).roles(roles.toArray(new String[roles.size()]));
        return (AuthenticationManager)((AuthenticationManagerBuilder)builder.and()).build();
    }
}

