/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data;

import com.mongodb.Mongo;
import com.mongodb.MongoURI;
import java.net.UnknownHostException;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.MongoRepositoriesAutoConfigureRegistrar;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.repository.MongoRepository;

@Configuration
@ConditionalOnClass(value={Mongo.class, MongoRepository.class})
public class MongoRepositoriesAutoConfiguration {

    @ConfigurationProperties(name="spring.data.mongo")
    public static class MongoProperties {
        private String host;
        private int port = 27017;
        private String uri = "mongodb://localhost/test";
        private String database;

        public String getHost() {
            return this.host;
        }

        public String database() {
            return this.database == null ? new MongoURI(this.uri).getDatabase() : this.database;
        }

        public Mongo mongo() throws UnknownHostException {
            return this.host != null ? new Mongo(this.host, this.port) : new Mongo(new MongoURI(this.uri));
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getDatabase() {
            return this.database;
        }

        public void setDatabase(String database) {
            this.database = database;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }

    @Import(value={MongoRepositoriesAutoConfigureRegistrar.class})
    @Configuration
    @EnableConfigurationProperties(value={MongoProperties.class})
    protected static class MongoRepositoriesConfiguration {
        @Autowired
        private MongoProperties config;
        private Mongo mongo;

        protected MongoRepositoriesConfiguration() {
        }

        @PreDestroy
        public void close() throws UnknownHostException {
            if (this.mongo != null) {
                this.mongo.close();
            }
        }

        @Bean
        @ConditionalOnMissingBean(value={Mongo.class})
        Mongo mongo() throws UnknownHostException {
            this.mongo = this.config.mongo();
            return this.mongo;
        }

        @Bean
        @ConditionalOnMissingBean(value={MongoTemplate.class})
        MongoTemplate mongoTemplate(Mongo mongo) throws UnknownHostException {
            return new MongoTemplate(mongo, this.config.database());
        }
    }
}

