/*
 * Decompiled with CFR 0.152.
 */
package org.scalastyle;

import com.typesafe.config.Config;
import java.io.File;
import java.io.PrintWriter;
import org.scalastyle.Checker;
import org.scalastyle.FileSpec;
import org.scalastyle.Level;
import org.scalastyle.Message;
import org.scalastyle.MessageHelper;
import org.scalastyle.Output$;
import org.scalastyle.StyleError;
import org.scalastyle.StyleException;
import org.scalastyle.XmlOutput;
import org.scalastyle.XmlPrettyPrinter;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.xml.Attribute$;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

public final class XmlOutput$ {
    public static final XmlOutput$ MODULE$;

    static {
        new XmlOutput$();
    }

    public <T extends FileSpec> void save(Config config, String target, String encoding, Seq<Message<T>> messages) {
        this.save(config, new File(target), encoding, (Iterable<Message<T>>)messages);
    }

    public <T extends FileSpec> void save(Config config, String target, String encoding, java.util.List<Message<T>> messages) {
        this.save(config, new File(target), encoding, JavaConversions$.MODULE$.collectionAsScalaIterable(messages));
    }

    public <T extends FileSpec> void save(Config config, File target, String encoding, Iterable<Message<T>> messages) {
        int width = 1000;
        int step = 1;
        MessageHelper messageHelper = new MessageHelper(config);
        String decl = new StringBuilder().append((Object)"<?xml version=\"1.0\" encoding=\"").append((Object)encoding).append((Object)"\"?>").toString();
        XmlPrettyPrinter qual$1 = new XmlPrettyPrinter(width, step);
        Elem x$2 = this.toCheckstyleFormat(messageHelper, messages);
        NamespaceBinding x$3 = qual$1.format$default$2();
        String s = qual$1.format((Node)x$2, x$3);
        this.printToFile(target, encoding, (Function1<PrintWriter, BoxedUnit>)new Serializable(decl, s){
            private final String decl$1;
            private final String s$1;

            public final void apply(PrintWriter pw) {
                pw.println(this.decl$1);
                pw.println(this.s$1);
            }
            {
                this.decl$1 = decl$1;
                this.s$1 = s$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void printToFile(File f, String encoding, Function1<PrintWriter, BoxedUnit> op) {
        File parent = f.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) void var4_4;
        throw new IllegalStateException(new StringBuilder().append((Object)"Couldn't create dir: ").append((Object)var4_4).toString());
        PrintWriter p = new PrintWriter(f, encoding);
        try {
            op.apply((Object)p);
            p.close();
            return;
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                void var5_5;
                var5_5.close();
                throw throwable2;
            }
        }
    }

    private <T extends FileSpec> Elem toCheckstyleFormat(MessageHelper messageHelper, Iterable<Message<T>> messages) {
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("version", (Seq)new Text("5.0"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus(((TraversableLike)messages.collect((PartialFunction)new Serializable(messageHelper){
            private final MessageHelper messageHelper$1;

            public final <A1 extends Message<T>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof StyleError) {
                    StyleError styleError = (StyleError)A1;
                    T file = styleError.fileSpec();
                    Class<Checker<?>> clazz = styleError.clazz();
                    String key = styleError.key();
                    Level level = styleError.level();
                    List<String> args = styleError.args();
                    Option<Object> line = styleError.lineNumber();
                    Option<Object> column = styleError.column();
                    Option<String> customMessage = styleError.customMessage();
                    object = new XmlOutput.Alert(file.name(), this.messageHelper$1.text(level.name()), Output$.MODULE$.findMessage(this.messageHelper$1, key, args, customMessage), (Option<Class<?>>)new Some(clazz), line, column);
                } else if (A1 instanceof StyleException) {
                    StyleException styleException = (StyleException)A1;
                    T file = styleException.fileSpec();
                    Option<Class<Checker<?>>> clazz = styleException.clazz();
                    String message = styleException.message();
                    Option<Object> line = styleException.lineNumber();
                    Option<Object> column = styleException.column();
                    object = new XmlOutput.Alert(file.name(), "error", message, clazz, line, column);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Message<T> x1) {
                Message<T> message = x1;
                boolean bl = message instanceof StyleError ? true : message instanceof StyleException;
                return bl;
            }
            {
                this.messageHelper$1 = messageHelper$1;
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).groupBy((Function1)new Serializable(){

            public final String apply(XmlOutput.Alert x$1) {
                return x$1.filename();
            }
        }).map((Function1)new Serializable(){

            public final Elem apply(Tuple2<String, Iterable<XmlOutput.Alert>> x0$1) {
                Tuple2<String, Iterable<XmlOutput.Alert>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String filename = (String)tuple2._1();
                    Iterable alerts = (Iterable)tuple2._2();
                    Null$ $md = Null$.MODULE$;
                    $md = new UnprefixedAttribute("name", filename, (MetaData)$md);
                    NodeBuffer $buf = new NodeBuffer();
                    $buf.$amp$plus((Object)new Text("\n          "));
                    $buf.$amp$plus(alerts.map((Function1)new Serializable(this){

                        public final Elem apply(XmlOutput.Alert x0$2) {
                            XmlOutput.Alert alert = x0$2;
                            if (alert != null) {
                                String severity = alert.severity();
                                String message = alert.message();
                                Option<Class<?>> source = alert.source();
                                Option<Object> line = alert.line();
                                Option<Object> column = alert.column();
                                Option s = source.collect((PartialFunction)new Serializable(this){

                                    public final <A1 extends Class<?>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                        Object object;
                                        A1 A1 = x2;
                                        if (A1 != null) {
                                            A1 A12 = A1;
                                            object = A12.getName();
                                        } else {
                                            object = function1.apply(x2);
                                        }
                                        return (B1)object;
                                    }

                                    public final boolean isDefinedAt(Class<?> x2) {
                                        Class<?> clazz = x2;
                                        boolean bl = clazz != null;
                                        return bl;
                                    }
                                });
                                Null$ $md = Null$.MODULE$;
                                $md = new UnprefixedAttribute("message", message, (MetaData)$md);
                                $md = new UnprefixedAttribute("severity", severity, (MetaData)$md);
                                Elem elem = new Elem(null, "error", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])).$percent(XmlOutput$.MODULE$.org$scalastyle$XmlOutput$$attr("source", (Option<Object>)s)).$percent(XmlOutput$.MODULE$.org$scalastyle$XmlOutput$$attr("line", line)).$percent(XmlOutput$.MODULE$.org$scalastyle$XmlOutput$$attr("column", column));
                                return elem;
                            }
                            throw new MatchError((Object)alert);
                        }
                    }, scala.collection.Iterable$.MODULE$.canBuildFrom()));
                    $buf.$amp$plus((Object)new Text("\n        "));
                    Elem elem = new Elem(null, "file", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                    return elem;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom()));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "checkstyle", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    public MetaData org$scalastyle$XmlOutput$$attr(String name, Option<Object> value) {
        Option<Object> option;
        block4: {
            Null$ null$;
            block3: {
                block2: {
                    option = value;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Object x = some.x();
                    null$ = (MetaData)Attribute$.MODULE$.apply("", name, x.toString(), (MetaData)Null$.MODULE$);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                null$ = Null$.MODULE$;
            }
            return null$;
        }
        throw new MatchError(option);
    }

    private XmlOutput$() {
        MODULE$ = this;
    }
}

