/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.credentials.password;

import org.apache.commons.codec.digest.DigestUtils;
import org.pac4j.core.credentials.password.PasswordEncoder;
import org.pac4j.core.util.CommonHelper;

public class BasicSaltedSha512PasswordEncoder
implements PasswordEncoder {
    protected String salt;

    public BasicSaltedSha512PasswordEncoder() {
    }

    public BasicSaltedSha512PasswordEncoder(String salt) {
        this.salt = salt;
    }

    @Override
    public String encode(String password) {
        CommonHelper.assertNotBlank("salt", this.salt);
        return DigestUtils.sha512Hex((String)(password + this.salt));
    }

    @Override
    public boolean matches(String plainPassword, String encodedPassword) {
        CommonHelper.assertNotBlank("salt", this.salt);
        return CommonHelper.areEquals(this.encode(plainPassword), encodedPassword);
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }
}

