/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.compiler.emitters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.neo4j.ogm.compiler.CypherEmitter;
import org.neo4j.ogm.model.Edge;
import org.neo4j.ogm.model.Property;

public class NewRelationshipEmitter
implements CypherEmitter {
    private Set<Edge> edges;

    public NewRelationshipEmitter(Set<Edge> edges) {
        this.edges = edges;
    }

    public void emit(StringBuilder queryBuilder, Map<String, Object> parameters) {
        boolean hasProperties = false;
        if (this.edges != null && this.edges.size() > 0) {
            Edge firstEdge = this.edges.iterator().next();
            String relType = firstEdge.getType();
            if (firstEdge.getPropertyList().size() > 0) {
                hasProperties = true;
            }
            queryBuilder.append("UNWIND {rows} as row ").append("MATCH (startNode) WHERE ID(startNode) = row.startNodeId ").append("MATCH (endNode) WHERE ID(endNode) = row.endNodeId ").append("MERGE (startNode)-[rel:`").append(relType).append("`");
            if (hasProperties) {
                boolean firstProperty = true;
                queryBuilder.append("{ ");
                TreeSet<String> sortedProperties = new TreeSet<String>();
                for (Property property : firstEdge.getPropertyList()) {
                    sortedProperties.add("`" + property.getKey() + "`: row.props." + property.getKey());
                }
                for (String propertyString : sortedProperties) {
                    if (!firstProperty) {
                        queryBuilder.append(", ");
                    }
                    queryBuilder.append(propertyString);
                    firstProperty = false;
                }
                queryBuilder.append("}");
            }
            queryBuilder.append("]->(endNode) ").append("RETURN row.relRef as ref, ID(rel) as id, row.type as type");
            ArrayList rows = new ArrayList();
            for (Edge edge : this.edges) {
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                rowMap.put("startNodeId", edge.getStartNode());
                rowMap.put("endNodeId", edge.getEndNode());
                rowMap.put("relRef", edge.getId());
                rowMap.put("type", "rel");
                if (hasProperties) {
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    for (Property property : edge.getPropertyList()) {
                        props.put((String)property.getKey(), property.getValue());
                    }
                    rowMap.put("props", props);
                }
                rows.add(rowMap);
            }
            parameters.put("rows", rows);
        }
    }
}

