/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert.internal;

import java.util.Iterator;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.api.store.StoreNodeRelationshipCursor;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.Direction;

abstract class BatchRelationshipIterable<T>
implements Iterable<T> {
    private final StoreNodeRelationshipCursor relationshipCursor;

    public BatchRelationshipIterable(NeoStores neoStores, long nodeId, RecordCursors cursors) {
        RelationshipStore relationshipStore = neoStores.getRelationshipStore();
        RecordStore<RelationshipGroupRecord> relationshipGroupStore = neoStores.getRelationshipGroupStore();
        RelationshipRecord relationshipRecord = (RelationshipRecord)relationshipStore.newRecord();
        RelationshipGroupRecord relationshipGroupRecord = relationshipGroupStore.newRecord();
        this.relationshipCursor = new StoreNodeRelationshipCursor(relationshipRecord, relationshipGroupRecord, cursor -> {}, cursors, LockService.NO_LOCK_SERVICE);
        try {
            NodeStore nodeStore = neoStores.getNodeStore();
            NodeRecord nodeRecord = (NodeRecord)nodeStore.getRecord(nodeId, nodeStore.newRecord(), RecordLoad.NORMAL);
            this.relationshipCursor.init(nodeRecord.isDense(), nodeRecord.getNextRel(), nodeId, Direction.BOTH);
        }
        catch (InvalidRecordException e) {
            throw new NotFoundException("Node " + nodeId + " not found");
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new PrefetchingIterator<T>(){

            protected T fetchNextOrNull() {
                if (!BatchRelationshipIterable.this.relationshipCursor.next()) {
                    return null;
                }
                return BatchRelationshipIterable.this.nextFrom(BatchRelationshipIterable.this.relationshipCursor.id(), BatchRelationshipIterable.this.relationshipCursor.type(), BatchRelationshipIterable.this.relationshipCursor.startNode(), BatchRelationshipIterable.this.relationshipCursor.endNode());
            }
        };
    }

    protected abstract T nextFrom(long var1, int var3, long var4, long var6);
}

