/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.function.Function;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.ExecutingQuery;
import org.neo4j.kernel.api.ProcedureCallOperations;
import org.neo4j.kernel.api.QueryRegistryOperations;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.TokenWriteOperations;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.txstate.LegacyIndexTransactionState;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.ExecutingQueryList;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.OperationsFacade;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.storageengine.api.StorageStatement;

public class KernelStatement
implements TxStateHolder,
Statement {
    private final TxStateHolder txStateHolder;
    private final StorageStatement storeStatement;
    private final AccessCapability accessCapability;
    private final KernelTransactionImplementation transaction;
    private final OperationsFacade facade;
    private StatementLocks statementLocks;
    private int referenceCount;
    private volatile ExecutingQueryList executingQueryList;

    public KernelStatement(KernelTransactionImplementation transaction, TxStateHolder txStateHolder, StorageStatement storeStatement, Procedures procedures, AccessCapability accessCapability) {
        this.transaction = transaction;
        this.txStateHolder = txStateHolder;
        this.storeStatement = storeStatement;
        this.accessCapability = accessCapability;
        this.facade = new OperationsFacade(transaction, this, procedures);
        this.executingQueryList = ExecutingQueryList.EMPTY;
    }

    @Override
    public ReadOperations readOperations() {
        this.assertAllows(AccessMode::allowsReads, "Read");
        return this.facade;
    }

    @Override
    public ProcedureCallOperations procedureCallOperations() {
        return this.facade;
    }

    @Override
    public TokenWriteOperations tokenWriteOperations() {
        this.accessCapability.assertCanWrite();
        return this.facade;
    }

    @Override
    public DataWriteOperations dataWriteOperations() throws InvalidTransactionTypeKernelException {
        this.accessCapability.assertCanWrite();
        this.assertAllows(AccessMode::allowsWrites, "Write");
        this.transaction.upgradeToDataWrites();
        return this.facade;
    }

    @Override
    public SchemaWriteOperations schemaWriteOperations() throws InvalidTransactionTypeKernelException {
        this.accessCapability.assertCanWrite();
        this.assertAllows(AccessMode::allowsSchemaWrites, "Schema");
        this.transaction.upgradeToSchemaWrites();
        return this.facade;
    }

    @Override
    public QueryRegistryOperations queryRegistration() {
        return this.facade;
    }

    @Override
    public TransactionState txState() {
        return this.txStateHolder.txState();
    }

    @Override
    public LegacyIndexTransactionState legacyIndexTxState() {
        return this.txStateHolder.legacyIndexTxState();
    }

    @Override
    public boolean hasTxStateWithChanges() {
        return this.txStateHolder.hasTxStateWithChanges();
    }

    public void close() {
        if (this.referenceCount > 0 && --this.referenceCount == 0) {
            this.cleanupResources();
        }
    }

    void assertOpen() {
        if (this.referenceCount == 0) {
            throw new NotInTransactionException("The statement has been closed.");
        }
        Status terminationReason = this.transaction.getReasonIfTerminated();
        if (terminationReason != null) {
            throw new TransactionTerminatedException(terminationReason);
        }
    }

    public void initialize(StatementLocks statementLocks, StatementOperationParts operationParts) {
        this.statementLocks = statementLocks;
        this.facade.initialize(operationParts);
    }

    public StatementLocks locks() {
        return this.statementLocks;
    }

    public final void acquire() {
        if (this.referenceCount++ == 0) {
            this.storeStatement.acquire();
        }
    }

    final boolean isAcquired() {
        return this.referenceCount > 0;
    }

    final void forceClose() {
        if (this.referenceCount > 0) {
            this.referenceCount = 0;
            this.cleanupResources();
        }
    }

    final String username() {
        return this.transaction.securityContext().subject().username();
    }

    final ExecutingQueryList executingQueryList() {
        return this.executingQueryList;
    }

    final void startQueryExecution(ExecutingQuery query) {
        this.executingQueryList = this.executingQueryList.push(query);
    }

    final void stopQueryExecution(ExecutingQuery executingQuery) {
        this.executingQueryList = this.executingQueryList.remove(executingQuery);
    }

    public StorageStatement getStoreStatement() {
        return this.storeStatement;
    }

    private void cleanupResources() {
        this.storeStatement.release();
        this.executingQueryList = ExecutingQueryList.EMPTY;
    }

    public KernelTransactionImplementation getTransaction() {
        return this.transaction;
    }

    void assertAllows(Function<AccessMode, Boolean> allows, String mode) {
        AccessMode accessMode = this.transaction.securityContext().mode();
        if (!allows.apply(accessMode).booleanValue()) {
            throw accessMode.onViolation(String.format("%s operations are not allowed for %s.", mode, this.transaction.securityContext().description()));
        }
    }
}

