/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.controlagent;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.anotheria.util.StringUtils;
import org.configureme.annotations.AbortedConfiguration;
import org.configureme.annotations.AfterConfiguration;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigureMe(name="agent")
public class AgentConfig {
    private static Logger log = LoggerFactory.getLogger(AgentConfig.class);
    @Configure
    private String includedProducers;
    @Configure
    private String excludedProducers;
    private List<String> includedProducersList;
    private List<String> excludedProducersList;

    public String getIncludedProducers() {
        return this.includedProducers;
    }

    public void setIncludedProducers(String includedProducers) {
        this.includedProducers = includedProducers;
    }

    public String getExcludedProducers() {
        return this.excludedProducers;
    }

    public void setExcludedProducers(String excludedProducers) {
        this.excludedProducers = excludedProducers;
    }

    @AfterConfiguration
    @AbortedConfiguration
    public void afterConfiguration() {
        int i;
        String[] tt;
        if (this.includedProducers == null || this.includedProducers.length() == 0 || this.includedProducers.trim().equals("*")) {
            this.includedProducersList = Collections.EMPTY_LIST;
        } else {
            tt = StringUtils.tokenize((String)this.includedProducers, (char)',');
            for (i = 0; i < tt.length; ++i) {
                tt[i] = tt[i].trim();
            }
            this.includedProducersList = Arrays.asList(tt);
        }
        if (this.excludedProducers == null || this.excludedProducers.length() == 0) {
            this.excludedProducersList = Collections.EMPTY_LIST;
        } else {
            tt = StringUtils.tokenize((String)this.excludedProducers, (char)',');
            for (i = 0; i < tt.length; ++i) {
                tt[i] = tt[i].trim();
            }
            this.excludedProducersList = Arrays.asList(tt);
        }
        log.info("AgentConfig parsed and finished, includeAll: " + this.includeAll() + ", inclList: " + this.includedProducersList + ", exclList: " + this.excludedProducersList);
    }

    public List<String> getIncludedProducersList() {
        return this.includedProducersList;
    }

    public List<String> getExcludedProducersList() {
        return this.excludedProducersList;
    }

    public boolean includeAll() {
        return this.includedProducersList.size() == 0 && this.excludedProducersList.size() == 0;
    }
}

