/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.controlagent;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.anotheria.moskito.core.accumulation.AccumulatedValue;
import net.anotheria.moskito.core.accumulation.Accumulator;
import net.anotheria.moskito.core.accumulation.AccumulatorRepository;
import net.anotheria.moskito.core.threshold.ExtendedThresholdStatus;
import net.anotheria.moskito.core.threshold.Threshold;
import net.anotheria.moskito.core.threshold.ThresholdInStatus;
import net.anotheria.moskito.core.threshold.ThresholdRepository;
import net.anotheria.moskito.core.threshold.ThresholdStatus;
import org.configureme.ConfigurationManager;
import org.moskito.controlagent.AgentConfig;
import org.moskito.controlagent.data.accumulator.AccumulatorDataItem;
import org.moskito.controlagent.data.accumulator.AccumulatorHolder;
import org.moskito.controlagent.data.accumulator.AccumulatorListItem;
import org.moskito.controlagent.data.status.ThresholdInfo;
import org.moskito.controlagent.data.status.ThresholdStatusHolder;
import org.moskito.controlagent.data.threshold.ThresholdDataItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Agent {
    private ThresholdRepository repository = ThresholdRepository.getInstance();
    private AgentConfig agentConfig = new AgentConfig();
    private static Logger log = LoggerFactory.getLogger(Agent.class);

    private Agent() {
        try {
            ConfigurationManager.INSTANCE.configure((Object)this.agentConfig);
        }
        catch (IllegalArgumentException e) {
            log.info("No agent configuration found, consult MoSKito-Control-Agent documentation for details on configuring the agent.");
            this.agentConfig.afterConfiguration();
        }
    }

    public static Agent getInstance() {
        return AgentInstanceHolder.instance;
    }

    public ThresholdStatusHolder getThresholdStatus() {
        if (this.repository == null) {
            return new ThresholdStatusHolder();
        }
        ThresholdStatusHolder tsh = new ThresholdStatusHolder();
        ExtendedThresholdStatus thresholdStatus = this.agentConfig.includeAll() ? this.repository.getExtendedWorstStatus(null) : (this.agentConfig.getIncludedProducersList().size() > 0 ? this.repository.getExtendedWorstStatus(this.agentConfig.getIncludedProducersList()) : this.repository.getExtendedWorstStatusWithout(this.agentConfig.getExcludedProducersList()));
        tsh.setStatus(thresholdStatus.getStatus());
        if (thresholdStatus.getStatus() != ThresholdStatus.GREEN) {
            List tisList = thresholdStatus.getThresholds();
            for (ThresholdInStatus tis : tisList) {
                ThresholdInfo info = new ThresholdInfo();
                info.setValue(tis.getValue());
                info.setMessage(tis.getAdditionalMessage());
                info.setThreshold(tis.getThresholdName());
                tsh.addThresholdInfo(info);
            }
        }
        return tsh;
    }

    public List<ThresholdDataItem> getThresholds() {
        if (this.repository == null) {
            return new LinkedList<ThresholdDataItem>();
        }
        LinkedList<ThresholdDataItem> items = new LinkedList<ThresholdDataItem>();
        List thresholds = this.repository.getThresholds();
        for (Threshold threshold : thresholds) {
            ThresholdDataItem item = new ThresholdDataItem();
            item.setName(threshold.getName());
            item.setStatus(threshold.getStatus());
            item.setLastValue(threshold.getLastValue());
            item.setStatusChangeTimestamp(threshold.getStatusChangeTimestamp());
            items.add(item);
        }
        return items;
    }

    public List<AccumulatorListItem> getAvailableAccumulators() {
        List accumulators = AccumulatorRepository.getInstance().getAccumulators();
        LinkedList<AccumulatorListItem> ret = new LinkedList<AccumulatorListItem>();
        for (Accumulator acc : accumulators) {
            ret.add(new AccumulatorListItem(acc.getName(), acc.getValues().size()));
        }
        return ret;
    }

    public Map<String, AccumulatorHolder> getAccumulatorsData(List<String> accumulatorNames) {
        HashMap<String, AccumulatorHolder> ret = new HashMap<String, AccumulatorHolder>();
        for (String requestedAccumulatorName : accumulatorNames) {
            try {
                requestedAccumulatorName = URLDecoder.decode(requestedAccumulatorName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("End of the known world is near, UTF-8 is not supported", e);
            }
            Accumulator acc = (Accumulator)AccumulatorRepository.getInstance().getByName(requestedAccumulatorName);
            if (acc == null) {
                log.warn("Requested not existing accumulator " + requestedAccumulatorName);
                continue;
            }
            AccumulatorHolder holder = new AccumulatorHolder(acc.getName());
            List accValues = acc.getValues();
            for (AccumulatedValue accValue : accValues) {
                holder.addItem(new AccumulatorDataItem(accValue.getTimestamp(), accValue.getValue()));
            }
            ret.put(holder.getName(), holder);
        }
        return ret;
    }

    private static class AgentInstanceHolder {
        static final Agent instance = new Agent();

        private AgentInstanceHolder() {
        }
    }
}

