/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.bytebuddy;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.exceptions.VerificationAwareInvocation;
import org.mockito.internal.invocation.ArgumentsProcessor;
import org.mockito.internal.invocation.MockitoMethod;
import org.mockito.internal.invocation.RealMethod;
import org.mockito.internal.reporting.PrintSettings;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;
import org.mockito.invocation.StubInfo;

public class InterceptedInvocation
implements Invocation,
VerificationAwareInvocation {
    private static final long serialVersionUID = 475027563923510472L;
    private final Object mock;
    private final MockitoMethod mockitoMethod;
    private final Object[] arguments;
    private final Object[] rawArguments;
    private final RealMethod realMethod;
    private final int sequenceNumber;
    private final Location location;
    private boolean verified;
    private boolean isIgnoredForVerification;
    private StubInfo stubInfo;
    public static final RealMethod NO_OP = new RealMethod(){

        @Override
        public boolean isInvokable() {
            return false;
        }

        @Override
        public Object invoke() throws Throwable {
            return null;
        }
    };

    public InterceptedInvocation(Object mock, MockitoMethod mockitoMethod, Object[] arguments, RealMethod realMethod, Location location, int sequenceNumber) {
        this.mock = mock;
        this.mockitoMethod = mockitoMethod;
        this.arguments = ArgumentsProcessor.expandArgs(mockitoMethod, arguments);
        this.rawArguments = arguments;
        this.realMethod = realMethod;
        this.location = location;
        this.sequenceNumber = sequenceNumber;
    }

    @Override
    public boolean isVerified() {
        return this.verified || this.isIgnoredForVerification;
    }

    @Override
    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public Object[] getRawArguments() {
        return this.rawArguments;
    }

    @Override
    public Class<?> getRawReturnType() {
        return this.mockitoMethod.getReturnType();
    }

    @Override
    public void markVerified() {
        this.verified = true;
    }

    @Override
    public StubInfo stubInfo() {
        return this.stubInfo;
    }

    @Override
    public void markStubbed(StubInfo stubInfo) {
        this.stubInfo = stubInfo;
    }

    @Override
    public boolean isIgnoredForVerification() {
        return this.isIgnoredForVerification;
    }

    @Override
    public void ignoreForVerification() {
        this.isIgnoredForVerification = true;
    }

    @Override
    public Object getMock() {
        return this.mock;
    }

    @Override
    public Method getMethod() {
        return this.mockitoMethod.getJavaMethod();
    }

    @Override
    public Object[] getArguments() {
        return this.arguments;
    }

    @Override
    public <T> T getArgument(int index) {
        return (T)this.arguments[index];
    }

    @Override
    public Object callRealMethod() throws Throwable {
        if (!this.realMethod.isInvokable()) {
            throw Reporter.cannotCallAbstractRealMethod();
        }
        return this.realMethod.invoke();
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        InterceptedInvocation other = (InterceptedInvocation)o;
        return this.mock.equals(other.mock) && this.mockitoMethod.equals(other.mockitoMethod) && this.equalArguments(other.arguments);
    }

    private boolean equalArguments(Object[] arguments) {
        return Arrays.equals(arguments, this.arguments);
    }

    @Override
    public String toString() {
        return new PrintSettings().print(ArgumentsProcessor.argumentsToMatchers(this.getArguments()), this);
    }
}

