/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.utils;

import org.javasimon.EnabledManager;
import org.javasimon.Manager;
import org.javasimon.Split;
import org.javasimon.StopwatchSample;

public class BenchmarkUtils {
    private static final Manager MANAGER = new EnabledManager();

    public static StopwatchSample[] run(int warmupRuns, int measuredRuns, Task ... tasks) {
        BenchmarkUtils.warmup(warmupRuns, tasks);
        BenchmarkUtils.measure(measuredRuns, tasks);
        BenchmarkUtils.presentSummary(tasks);
        StopwatchSample[] result = new StopwatchSample[tasks.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = MANAGER.getStopwatch(tasks[i].stopwatchName).sample();
        }
        return result;
    }

    private static void warmup(int warmupRuns, Task[] tasks) {
        for (int i = 1; i <= warmupRuns; ++i) {
            System.out.println("\nWarmup run #" + i);
            for (Task task : tasks) {
                BenchmarkUtils.warmupTask(task);
            }
        }
    }

    private static void warmupTask(Task task) {
        try {
            task.perform();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void measure(int measuredRuns, Task[] tasks) {
        for (int i = 1; i <= measuredRuns; ++i) {
            System.out.println("\nMeasured run #" + i);
            for (Task task : tasks) {
                task.run();
            }
        }
    }

    private static void presentSummary(Task[] tasks) {
        System.out.println("\nSUMMARY:");
        for (Task task : tasks) {
            System.out.println(task.stopwatchName + ": " + MANAGER.getStopwatch(task.stopwatchName));
        }
    }

    public static abstract class Task
    implements Runnable {
        private String stopwatchName;

        protected Task(String stopwatchName) {
            this.stopwatchName = stopwatchName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            System.out.print(this.stopwatchName + ": ");
            Split split = new Split();
            try {
                this.perform();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                split.stop();
                System.out.println(split.presentRunningFor());
                MANAGER.getStopwatch(this.stopwatchName).addSplit(split);
            }
        }

        public abstract void perform() throws Exception;
    }
}

