/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.impl;

import java.util.Set;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.AbstractRequest;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.impl.RequestRepository;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SingleTargetRequest<T>
extends AbstractRequest<T> {
    private static final Log log = LogFactory.getLog(SingleTargetRequest.class);
    private final Address target;

    public SingleTargetRequest(ResponseCollector<T> wrapper, long requestId, RequestRepository repository, Address target) {
        super(requestId, wrapper, repository);
        this.target = target;
    }

    @Override
    public void onResponse(Address sender, Response response) {
        if (!this.target.equals(sender)) {
            this.completeExceptionally(new IllegalStateException("Received response from " + sender + ", but target was " + this.target));
        }
        this.receiveResponse(sender, response);
    }

    @Override
    public void onNewView(Set<Address> members) {
        boolean targetIsMissing;
        boolean bl = targetIsMissing = !members.contains(this.target);
        if (targetIsMissing) {
            this.receiveResponse(this.target, CacheNotFoundResponse.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveResponse(Address sender, Response response) {
        try {
            Object result;
            ResponseCollector responseCollector = this.responseCollector;
            synchronized (responseCollector) {
                result = this.responseCollector.addResponse(sender, response);
                if (result == null) {
                    result = this.responseCollector.finish();
                }
            }
            this.complete(result);
        }
        catch (Exception e) {
            this.completeExceptionally(e);
        }
    }

    @Override
    protected void onTimeout() {
        this.completeExceptionally((Throwable)((Object)log.requestTimedOut(this.requestId, this.target.toString())));
    }
}

